/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty.server;

import io.rsocket.Closeable;
import io.rsocket.DuplexConnection;
import io.rsocket.fragmentation.FragmentationDuplexConnection;
import io.rsocket.fragmentation.ReassemblyDuplexConnection;
import io.rsocket.transport.ServerTransport;
import io.rsocket.transport.netty.WebsocketDuplexConnection;
import io.rsocket.transport.netty.server.BaseWebsocketServerTransport;
import io.rsocket.transport.netty.server.CloseableChannel;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerRoutes;
import reactor.netty.http.server.WebsocketServerSpec;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;

public final class WebsocketRouteTransport
extends BaseWebsocketServerTransport<Closeable> {
    private final String path;
    private final Consumer<? super HttpServerRoutes> routesBuilder;
    private final HttpServer server;

    public WebsocketRouteTransport(HttpServer server, Consumer<? super HttpServerRoutes> routesBuilder, String path) {
        this.server = (HttpServer)serverConfigurer.apply(Objects.requireNonNull(server, "server must not be null"));
        this.routesBuilder = Objects.requireNonNull(routesBuilder, "routesBuilder must not be null");
        this.path = Objects.requireNonNull(path, "path must not be null");
    }

    public Mono<Closeable> start(ServerTransport.ConnectionAcceptor acceptor, int mtu) {
        Objects.requireNonNull(acceptor, "acceptor must not be null");
        return this.server.route(routes -> {
            this.routesBuilder.accept((HttpServerRoutes)routes);
            routes.ws(this.path, WebsocketRouteTransport.newHandler(acceptor, mtu), ((WebsocketServerSpec.Builder)WebsocketServerSpec.builder().maxFramePayloadLength(0xFFFFFF)).build());
        }).bind().map(CloseableChannel::new);
    }

    public static BiFunction<WebsocketInbound, WebsocketOutbound, Publisher<Void>> newHandler(ServerTransport.ConnectionAcceptor acceptor) {
        return WebsocketRouteTransport.newHandler(acceptor, 0);
    }

    public static BiFunction<WebsocketInbound, WebsocketOutbound, Publisher<Void>> newHandler(ServerTransport.ConnectionAcceptor acceptor, int mtu) {
        return (in, out) -> {
            WebsocketDuplexConnection connection = new WebsocketDuplexConnection((Connection)in);
            connection = mtu > 0 ? new FragmentationDuplexConnection((DuplexConnection)connection, mtu, false, "server") : new ReassemblyDuplexConnection((DuplexConnection)connection, false);
            return acceptor.apply((DuplexConnection)connection).then(out.neverComplete());
        };
    }
}

