/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport.netty.websocket;

import io.netty.channel.ChannelOption;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.scalecube.cluster.transport.api.Message;
import io.scalecube.cluster.transport.api.TransportConfig;
import io.scalecube.net.Address;
import io.scalecube.transport.netty.Sender;
import io.scalecube.transport.netty.TransportImpl;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.WebsocketClientSpec;

final class WebsocketSender
implements Sender {
    private final TransportConfig config;

    WebsocketSender(TransportConfig config) {
        this.config = config;
    }

    @Override
    public Mono<Connection> connect(Address address) {
        return Mono.deferContextual(context -> Mono.just((Object)context.get(TransportImpl.SenderContext.class))).map(context -> this.newWebsocketSender((TransportImpl.SenderContext)context, address)).flatMap(sender -> ((HttpClient.WebsocketSender)sender.uri("/")).connect());
    }

    @Override
    public Mono<Void> send(Message message) {
        return Mono.deferContextual(context -> {
            Connection connection = (Connection)context.get(Connection.class);
            TransportImpl.SenderContext senderContext = (TransportImpl.SenderContext)context.get(TransportImpl.SenderContext.class);
            return connection.outbound().sendObject((Publisher)Mono.just((Object)message).map(senderContext.messageEncoder()).map(BinaryWebSocketFrame::new), bb -> true).then();
        });
    }

    private HttpClient.WebsocketSender newWebsocketSender(TransportImpl.SenderContext context, Address address) {
        HttpClient httpClient = (HttpClient)((HttpClient)((HttpClient)((HttpClient)((HttpClient)((HttpClient)HttpClient.newConnection().runOn(context.loopResources())).host(address.host())).port(address.port()).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.config.connectTimeout());
        if (this.config.isClientSecured()) {
            httpClient = httpClient.secure();
        }
        return httpClient.websocket(((WebsocketClientSpec.Builder)WebsocketClientSpec.builder().maxFramePayloadLength(this.config.maxFrameLength())).build());
    }
}

