/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.facet;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.core.search.facet.Facet;
import java.util.ArrayList;
import java.util.List;

public class GeoDistanceFacet
extends Facet {
    public static final String TYPE = "geo_distance";
    private List<Range> ranges;

    public GeoDistanceFacet(String name, JsonObject geoDistanceFacet) {
        this.name = name;
        this.ranges = new ArrayList<Range>();
        for (JsonElement termv : geoDistanceFacet.get("ranges").getAsJsonArray()) {
            JsonObject term = (JsonObject)termv;
            Range range = new Range(term.get("from") != null ? Double.valueOf(term.get("from").getAsDouble()) : null, term.get("to") != null ? Double.valueOf(term.get("to").getAsDouble()) : null, term.get("total_count").getAsLong(), term.get("total").getAsDouble(), term.get("min").getAsDouble(), term.get("max").getAsDouble(), term.get("mean").getAsDouble());
            this.ranges.add(range);
        }
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public class Range {
        private Double from;
        private Double to;
        private Long totalCount;
        private Double total;
        private Double min;
        private Double max;
        private Double mean;

        Range(Double from, Double to, Long totalCount, Double total, Double min, Double max, Double mean) {
            this.from = from;
            this.to = to;
            this.totalCount = totalCount;
            this.total = total;
            this.min = min;
            this.max = max;
            this.mean = mean;
        }

        public Double getFrom() {
            return this.from;
        }

        public Double getTo() {
            return this.to;
        }

        public Long getTotalCount() {
            return this.totalCount;
        }

        public Double getTotal() {
            return this.total;
        }

        public Double getMin() {
            return this.min;
        }

        public Double getMax() {
            return this.max;
        }

        public Double getMean() {
            return this.mean;
        }
    }
}

