/*
 * Decompiled with CFR 0.152.
 */
package io.seata.common.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public class LowerCaseLinkHashMap<V>
implements Map<String, V> {
    private final LinkedHashMap<String, V> targetMap;
    private final LinkedHashMap<String, String> lowerKeyToOriginMap;

    public LowerCaseLinkHashMap() {
        this.targetMap = new LinkedHashMap(16, 1.001f);
        this.lowerKeyToOriginMap = new LinkedHashMap(16, 1.001f);
    }

    public LowerCaseLinkHashMap(Integer initialCapacity, float loadFactor) {
        this.targetMap = new LinkedHashMap(initialCapacity, loadFactor);
        this.lowerKeyToOriginMap = new LinkedHashMap(initialCapacity, loadFactor);
    }

    public LowerCaseLinkHashMap(Map<String, V> map) {
        this.targetMap = new LinkedHashMap(16, 1.001f);
        this.lowerKeyToOriginMap = new LinkedHashMap(16, 1.001f);
        this.putAll((Map<? extends String, ? extends V>)map);
    }

    @Override
    public int size() {
        return this.targetMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.targetMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        if (o instanceof String) {
            return this.targetMap.containsKey(((String)o).toLowerCase());
        }
        return false;
    }

    @Override
    public boolean containsValue(Object o) {
        return this.targetMap.containsValue(o);
    }

    @Override
    public V get(Object o) {
        if (o instanceof String) {
            return this.targetMap.get(((String)o).toLowerCase());
        }
        return null;
    }

    @Override
    public V put(String s, V v) {
        this.lowerKeyToOriginMap.put(s.toLowerCase(), s);
        return this.targetMap.put(s.toLowerCase(), v);
    }

    @Override
    public V remove(Object o) {
        if (o instanceof String) {
            this.lowerKeyToOriginMap.remove(((String)o).toLowerCase());
            return this.targetMap.remove(((String)o).toLowerCase());
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> map) {
        map.forEach((k, v) -> this.lowerKeyToOriginMap.put(k.toLowerCase(), (String)k));
        map.forEach((k, v) -> this.targetMap.put(k.toLowerCase(), v));
    }

    @Override
    public void clear() {
        this.targetMap.clear();
        this.lowerKeyToOriginMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return new HashSet<String>(this.lowerKeyToOriginMap.values());
    }

    @Override
    public Collection<V> values() {
        return this.targetMap.values();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return this.targetMap.entrySet();
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        if (key instanceof String) {
            return Map.super.getOrDefault(((String)key).toLowerCase(), defaultValue);
        }
        return defaultValue;
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super V, ? extends V> function) {
        Map.super.replaceAll(function);
    }

    @Override
    public V putIfAbsent(String key, V value) {
        return Map.super.putIfAbsent(key.toLowerCase(), value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (key instanceof String) {
            return Map.super.remove(((String)key).toLowerCase(), value);
        }
        return false;
    }

    @Override
    public boolean replace(String key, V oldValue, V newValue) {
        return Map.super.replace(key.toLowerCase(), oldValue, newValue);
    }

    @Override
    public V replace(String key, V value) {
        return Map.super.replace(key.toLowerCase(), value);
    }

    @Override
    public V computeIfAbsent(String key, Function<? super String, ? extends V> mappingFunction) {
        return Map.super.computeIfAbsent(key.toLowerCase(), mappingFunction);
    }

    @Override
    public V computeIfPresent(String key, BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
        return Map.super.computeIfPresent(key.toLowerCase(), remappingFunction);
    }

    @Override
    public V compute(String key, BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
        return Map.super.compute(key.toLowerCase(), remappingFunction);
    }

    @Override
    public V merge(String key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return Map.super.merge(key.toLowerCase(), value, remappingFunction);
    }

    protected LowerCaseLinkHashMap<V> clone() throws CloneNotSupportedException {
        return new LowerCaseLinkHashMap<V>(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LowerCaseLinkHashMap that = (LowerCaseLinkHashMap)o;
        return Objects.equals(this.targetMap, that.targetMap);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.targetMap);
    }

    public String toString() {
        return this.targetMap.toString();
    }
}

