/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc;

import io.netty.channel.Channel;
import io.seata.common.util.StringUtils;
import io.seata.core.rpc.netty.ChannelUtil;
import io.seata.core.rpc.netty.NettyPoolKey;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(RpcContext.class);
    private NettyPoolKey.TransactionRole clientRole;
    private String version;
    private String applicationId;
    private String transactionServiceGroup;
    private String clientId;
    private Channel channel;
    private Set<String> resourceSets;
    private ConcurrentMap<Channel, RpcContext> clientIDHolderMap;
    private ConcurrentMap<Integer, RpcContext> clientTMHolderMap;
    private ConcurrentMap<String, ConcurrentMap<Integer, RpcContext>> clientRMHolderMap;

    public void release() {
        Integer clientPort = ChannelUtil.getClientPortFromChannel(this.channel);
        if (this.clientIDHolderMap != null) {
            this.clientIDHolderMap = null;
        }
        if (this.clientRole == NettyPoolKey.TransactionRole.TMROLE && this.clientTMHolderMap != null) {
            this.clientTMHolderMap.remove(clientPort);
            this.clientTMHolderMap = null;
        }
        if (this.clientRole == NettyPoolKey.TransactionRole.RMROLE && this.clientRMHolderMap != null) {
            for (Map portMap : this.clientRMHolderMap.values()) {
                portMap.remove(clientPort);
            }
            this.clientRMHolderMap = null;
        }
        if (this.resourceSets != null) {
            this.resourceSets.clear();
        }
    }

    public void holdInClientChannels(ConcurrentMap<Integer, RpcContext> clientTMHolderMap) {
        if (this.clientTMHolderMap != null) {
            throw new IllegalStateException();
        }
        this.clientTMHolderMap = clientTMHolderMap;
        Integer clientPort = ChannelUtil.getClientPortFromChannel(this.channel);
        this.clientTMHolderMap.put(clientPort, this);
    }

    public void holdInIdentifiedChannels(ConcurrentMap<Channel, RpcContext> clientIDHolderMap) {
        if (this.clientIDHolderMap != null) {
            throw new IllegalStateException();
        }
        this.clientIDHolderMap = clientIDHolderMap;
        this.clientIDHolderMap.put(this.channel, this);
    }

    public void holdInResourceManagerChannels(String resourceId, ConcurrentMap<Integer, RpcContext> portMap) {
        if (this.clientRMHolderMap == null) {
            this.clientRMHolderMap = new ConcurrentHashMap<String, ConcurrentMap<Integer, RpcContext>>();
        }
        Integer clientPort = ChannelUtil.getClientPortFromChannel(this.channel);
        portMap.put(clientPort, this);
        this.clientRMHolderMap.put(resourceId, portMap);
    }

    public void holdInResourceManagerChannels(String resourceId, Integer clientPort) {
        if (this.clientRMHolderMap == null) {
            this.clientRMHolderMap = new ConcurrentHashMap<String, ConcurrentMap<Integer, RpcContext>>();
        }
        this.clientRMHolderMap.putIfAbsent(resourceId, new ConcurrentHashMap());
        ConcurrentMap portMap = (ConcurrentMap)this.clientRMHolderMap.get(resourceId);
        portMap.put(clientPort, this);
    }

    public ConcurrentMap<String, ConcurrentMap<Integer, RpcContext>> getClientRMHolderMap() {
        return this.clientRMHolderMap;
    }

    public Map<Integer, RpcContext> getPortMap(String resourceId) {
        return (Map)this.clientRMHolderMap.get(resourceId);
    }

    public String getClientId() {
        return this.clientId;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getTransactionServiceGroup() {
        return this.transactionServiceGroup;
    }

    public void setTransactionServiceGroup(String transactionServiceGroup) {
        this.transactionServiceGroup = transactionServiceGroup;
    }

    public NettyPoolKey.TransactionRole getClientRole() {
        return this.clientRole;
    }

    public void setClientRole(NettyPoolKey.TransactionRole clientRole) {
        this.clientRole = clientRole;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Set<String> getResourceSets() {
        return this.resourceSets;
    }

    public void setResourceSets(Set<String> resourceSets) {
        this.resourceSets = resourceSets;
    }

    public void addResource(String resource) {
        if (StringUtils.isBlank((String)resource)) {
            return;
        }
        if (this.resourceSets == null) {
            this.resourceSets = new HashSet<String>();
        }
        this.resourceSets.add(resource);
    }

    public void addResources(Set<String> resources) {
        if (resources == null) {
            return;
        }
        if (this.resourceSets == null) {
            this.resourceSets = new HashSet<String>();
        }
        this.resourceSets.addAll(resources);
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String toString() {
        return "RpcContext{applicationId='" + this.applicationId + '\'' + ", transactionServiceGroup='" + this.transactionServiceGroup + '\'' + ", clientId='" + this.clientId + '\'' + ", channel=" + this.channel + ", resourceSets=" + this.resourceSets + '}';
    }
}

