/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.netty;

import io.netty.channel.Channel;
import io.seata.common.exception.FrameworkException;
import io.seata.common.util.StringUtils;
import io.seata.core.protocol.IncompatibleVersionException;
import io.seata.core.protocol.RegisterRMRequest;
import io.seata.core.protocol.RegisterTMRequest;
import io.seata.core.protocol.Version;
import io.seata.core.rpc.RpcContext;
import io.seata.core.rpc.netty.ChannelUtil;
import io.seata.core.rpc.netty.NettyPoolKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelManager.class);
    private static final ConcurrentMap<Channel, RpcContext> IDENTIFIED_CHANNELS = new ConcurrentHashMap<Channel, RpcContext>();
    private static final ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<Integer, RpcContext>>>> RM_CHANNELS = new ConcurrentHashMap<String, ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<Integer, RpcContext>>>>();
    private static final ConcurrentMap<String, ConcurrentMap<Integer, RpcContext>> TM_CHANNELS = new ConcurrentHashMap<String, ConcurrentMap<Integer, RpcContext>>();

    public static boolean isRegistered(Channel channel) {
        return IDENTIFIED_CHANNELS.containsKey(channel);
    }

    public static NettyPoolKey.TransactionRole getRoleFromChannel(Channel channel) {
        if (IDENTIFIED_CHANNELS.containsKey(channel)) {
            return ((RpcContext)IDENTIFIED_CHANNELS.get(channel)).getClientRole();
        }
        return null;
    }

    public static RpcContext getContextFromIdentified(Channel channel) {
        return (RpcContext)IDENTIFIED_CHANNELS.get(channel);
    }

    private static String buildClientId(String applicationId, Channel channel) {
        return applicationId + ":" + ChannelUtil.getAddressFromChannel(channel);
    }

    private static String[] readClientId(String clientId) {
        return clientId.split(":");
    }

    private static RpcContext buildChannelHolder(NettyPoolKey.TransactionRole clientRole, String version, String applicationId, String txServiceGroup, String dbkeys, Channel channel) {
        RpcContext holder = new RpcContext();
        holder.setClientRole(clientRole);
        holder.setVersion(version);
        holder.setClientId(ChannelManager.buildClientId(applicationId, channel));
        holder.setApplicationId(applicationId);
        holder.setTransactionServiceGroup(txServiceGroup);
        holder.addResources(ChannelManager.dbKeytoSet(dbkeys));
        holder.setChannel(channel);
        return holder;
    }

    public static void registerTMChannel(RegisterTMRequest request, Channel channel) throws IncompatibleVersionException {
        Version.checkVersion(request.getVersion());
        RpcContext rpcContext = ChannelManager.buildChannelHolder(NettyPoolKey.TransactionRole.TMROLE, request.getVersion(), request.getApplicationId(), request.getTransactionServiceGroup(), null, channel);
        rpcContext.holdInIdentifiedChannels(IDENTIFIED_CHANNELS);
        String clientIdentified = rpcContext.getApplicationId() + ":" + ChannelUtil.getClientIpFromChannel(channel);
        TM_CHANNELS.putIfAbsent(clientIdentified, new ConcurrentHashMap());
        ConcurrentMap clientIdentifiedMap = (ConcurrentMap)TM_CHANNELS.get(clientIdentified);
        rpcContext.holdInClientChannels(clientIdentifiedMap);
    }

    public static void registerRMChannel(RegisterRMRequest resourceManagerRequest, Channel channel) throws IncompatibleVersionException {
        RpcContext rpcContext;
        Version.checkVersion(resourceManagerRequest.getVersion());
        Set<String> dbkeySet = ChannelManager.dbKeytoSet(resourceManagerRequest.getResourceIds());
        if (!IDENTIFIED_CHANNELS.containsKey(channel)) {
            rpcContext = ChannelManager.buildChannelHolder(NettyPoolKey.TransactionRole.RMROLE, resourceManagerRequest.getVersion(), resourceManagerRequest.getApplicationId(), resourceManagerRequest.getTransactionServiceGroup(), resourceManagerRequest.getResourceIds(), channel);
            rpcContext.holdInIdentifiedChannels(IDENTIFIED_CHANNELS);
        } else {
            rpcContext = (RpcContext)IDENTIFIED_CHANNELS.get(channel);
            rpcContext.addResources(dbkeySet);
        }
        if (dbkeySet == null || dbkeySet.isEmpty()) {
            return;
        }
        for (String resourceId : dbkeySet) {
            String clientIp = ChannelUtil.getClientIpFromChannel(channel);
            ConcurrentMap portMap = RM_CHANNELS.computeIfAbsent(resourceId, resourceIdKey -> new ConcurrentHashMap()).computeIfAbsent(resourceManagerRequest.getApplicationId(), applicationId -> new ConcurrentHashMap()).computeIfAbsent(clientIp, clientIpKey -> new ConcurrentHashMap());
            rpcContext.holdInResourceManagerChannels(resourceId, portMap);
            ChannelManager.updateChannelsResource(resourceId, clientIp, resourceManagerRequest.getApplicationId());
        }
    }

    private static void updateChannelsResource(String resourceId, String clientIp, String applicationId) {
        ConcurrentMap sourcePortMap = (ConcurrentMap)((ConcurrentMap)((ConcurrentMap)RM_CHANNELS.get(resourceId)).get(applicationId)).get(clientIp);
        for (Map.Entry rmChannelEntry : RM_CHANNELS.entrySet()) {
            ConcurrentMap clientIpMap;
            ConcurrentMap applicationIdMap;
            if (((String)rmChannelEntry.getKey()).equals(resourceId) || !(applicationIdMap = (ConcurrentMap)rmChannelEntry.getValue()).containsKey(applicationId) || !(clientIpMap = (ConcurrentMap)applicationIdMap.get(applicationId)).containsKey(clientIp)) continue;
            ConcurrentMap portMap = (ConcurrentMap)clientIpMap.get(clientIp);
            for (Map.Entry portMapEntry : portMap.entrySet()) {
                Integer port = (Integer)portMapEntry.getKey();
                if (sourcePortMap.containsKey(port)) continue;
                RpcContext rpcContext = (RpcContext)portMapEntry.getValue();
                sourcePortMap.put(port, rpcContext);
                rpcContext.holdInResourceManagerChannels(resourceId, port);
            }
        }
    }

    private static Set<String> dbKeytoSet(String dbkey) {
        if (StringUtils.isNullOrEmpty((String)dbkey)) {
            return null;
        }
        return new HashSet<String>(Arrays.asList(dbkey.split(",")));
    }

    public static void releaseRpcContext(Channel channel) {
        if (IDENTIFIED_CHANNELS.containsKey(channel)) {
            RpcContext rpcContext = ChannelManager.getContextFromIdentified(channel);
            rpcContext.release();
        }
    }

    public static Channel getSameClientChannel(Channel channel) {
        if (channel.isActive()) {
            return channel;
        }
        RpcContext rpcContext = ChannelManager.getContextFromIdentified(channel);
        if (rpcContext == null) {
            LOGGER.error("rpcContext is null,channel:{},active:{}", (Object)channel, (Object)channel.isActive());
            return null;
        }
        if (rpcContext.getChannel().isActive()) {
            return rpcContext.getChannel();
        }
        Integer clientPort = ChannelUtil.getClientPortFromChannel(channel);
        NettyPoolKey.TransactionRole clientRole = rpcContext.getClientRole();
        if (clientRole == NettyPoolKey.TransactionRole.TMROLE) {
            String clientIdentified = rpcContext.getApplicationId() + ":" + ChannelUtil.getClientIpFromChannel(channel);
            if (!TM_CHANNELS.containsKey(clientIdentified)) {
                return null;
            }
            ConcurrentMap clientRpcMap = (ConcurrentMap)TM_CHANNELS.get(clientIdentified);
            return ChannelManager.getChannelFromSameClientMap(clientRpcMap, clientPort);
        }
        if (clientRole == NettyPoolKey.TransactionRole.RMROLE) {
            for (Map clientRmMap : rpcContext.getClientRMHolderMap().values()) {
                Channel sameClientChannel = ChannelManager.getChannelFromSameClientMap(clientRmMap, clientPort);
                if (sameClientChannel == null) continue;
                return sameClientChannel;
            }
        }
        return null;
    }

    private static Channel getChannelFromSameClientMap(Map<Integer, RpcContext> clientChannelMap, int exclusivePort) {
        if (clientChannelMap != null && !clientChannelMap.isEmpty()) {
            for (Map.Entry<Integer, RpcContext> entry : clientChannelMap.entrySet()) {
                if (entry.getKey() == exclusivePort) {
                    clientChannelMap.remove(entry.getKey());
                    continue;
                }
                Channel channel = entry.getValue().getChannel();
                if (channel.isActive()) {
                    return channel;
                }
                clientChannelMap.remove(entry.getKey());
            }
        }
        return null;
    }

    public static Channel getChannel(String resourceId, String clientId) {
        Channel resultChannel = null;
        String[] clientIdInfo = ChannelManager.readClientId(clientId);
        if (clientIdInfo == null || clientIdInfo.length != 3) {
            throw new FrameworkException("Invalid Client ID: " + clientId);
        }
        String targetApplicationId = clientIdInfo[0];
        String targetIP = clientIdInfo[1];
        int targetPort = Integer.parseInt(clientIdInfo[2]);
        ConcurrentMap applicationIdMap = (ConcurrentMap)RM_CHANNELS.get(resourceId);
        if (targetApplicationId == null || applicationIdMap == null || applicationIdMap.isEmpty()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("No channel is available for resource[{}]", (Object)resourceId);
            }
            return null;
        }
        ConcurrentMap ipMap = (ConcurrentMap)applicationIdMap.get(targetApplicationId);
        if (ipMap != null && !ipMap.isEmpty()) {
            ConcurrentMap portMapOnTargetIP = (ConcurrentMap)ipMap.get(targetIP);
            if (portMapOnTargetIP != null && !portMapOnTargetIP.isEmpty()) {
                RpcContext exactRpcContext = (RpcContext)portMapOnTargetIP.get(targetPort);
                if (exactRpcContext != null) {
                    Channel channel = exactRpcContext.getChannel();
                    if (channel.isActive()) {
                        resultChannel = channel;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Just got exactly the one {} for {}", (Object)channel, (Object)clientId);
                        }
                    } else if (portMapOnTargetIP.remove(targetPort, exactRpcContext) && LOGGER.isInfoEnabled()) {
                        LOGGER.info("Removed inactive {}", (Object)channel);
                    }
                }
                if (resultChannel == null) {
                    for (Map.Entry entry : portMapOnTargetIP.entrySet()) {
                        Channel channel = ((RpcContext)entry.getValue()).getChannel();
                        if (channel.isActive()) {
                            resultChannel = channel;
                            if (!LOGGER.isInfoEnabled()) break;
                            LOGGER.info("Choose {} on the same IP[{}] as alternative of {}", new Object[]{channel, targetIP, clientId});
                            break;
                        }
                        if (!portMapOnTargetIP.remove(entry.getKey(), entry.getValue()) || !LOGGER.isInfoEnabled()) continue;
                        LOGGER.info("Removed inactive {}", (Object)channel);
                    }
                }
            }
            if (resultChannel == null) {
                for (Map.Entry ipMapEntry : ipMap.entrySet()) {
                    ConcurrentMap concurrentMap;
                    if (((String)ipMapEntry.getKey()).equals(targetIP) || (concurrentMap = (ConcurrentMap)ipMapEntry.getValue()) == null || concurrentMap.isEmpty()) continue;
                    for (Map.Entry portMapOnOtherIPEntry : concurrentMap.entrySet()) {
                        Channel channel = ((RpcContext)portMapOnOtherIPEntry.getValue()).getChannel();
                        if (channel.isActive()) {
                            resultChannel = channel;
                            if (!LOGGER.isInfoEnabled()) break;
                            LOGGER.info("Choose {} on the same application[{}] as alternative of {}", new Object[]{channel, targetApplicationId, clientId});
                            break;
                        }
                        if (!concurrentMap.remove(portMapOnOtherIPEntry.getKey(), portMapOnOtherIPEntry.getValue()) || !LOGGER.isInfoEnabled()) continue;
                        LOGGER.info("Removed inactive {}", (Object)channel);
                    }
                    if (resultChannel == null) continue;
                    break;
                }
            }
        }
        if (resultChannel == null) {
            resultChannel = ChannelManager.tryOtherApp(applicationIdMap, targetApplicationId);
            if (resultChannel == null) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("No channel is available for resource[{}] as alternative of {}", (Object)resourceId, (Object)clientId);
                }
            } else if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Choose {} on the same resource[{}] as alternative of {}", new Object[]{resultChannel, resourceId, clientId});
            }
        }
        return resultChannel;
    }

    private static Channel tryOtherApp(ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<Integer, RpcContext>>> applicationIdMap, String myApplicationId) {
        Channel chosenChannel = null;
        for (Map.Entry applicationIdMapEntry : applicationIdMap.entrySet()) {
            ConcurrentMap targetIPMap;
            if (!StringUtils.isNullOrEmpty((String)myApplicationId) && ((String)applicationIdMapEntry.getKey()).equals(myApplicationId) || (targetIPMap = (ConcurrentMap)applicationIdMapEntry.getValue()) == null || targetIPMap.isEmpty()) continue;
            for (Map.Entry targetIPMapEntry : targetIPMap.entrySet()) {
                ConcurrentMap portMap = (ConcurrentMap)targetIPMapEntry.getValue();
                if (portMap == null || portMap.isEmpty()) continue;
                for (Map.Entry portMapEntry : portMap.entrySet()) {
                    Channel channel = ((RpcContext)portMapEntry.getValue()).getChannel();
                    if (channel.isActive()) {
                        chosenChannel = channel;
                        break;
                    }
                    if (!portMap.remove(portMapEntry.getKey(), portMapEntry.getValue()) || !LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("Removed inactive {}", (Object)channel);
                }
                if (chosenChannel == null) continue;
                break;
            }
            if (chosenChannel == null) continue;
            break;
        }
        return chosenChannel;
    }

    public static Map<String, Channel> getRmChannels() {
        if (RM_CHANNELS.isEmpty()) {
            return null;
        }
        HashMap<String, Channel> channels = new HashMap<String, Channel>(RM_CHANNELS.size());
        for (String resourceId : RM_CHANNELS.keySet()) {
            Channel channel = ChannelManager.tryOtherApp((ConcurrentMap)RM_CHANNELS.get(resourceId), null);
            if (channel == null) continue;
            channels.put(resourceId, channel);
        }
        return channels;
    }
}

