/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.netty;

import io.netty.channel.Channel;
import io.seata.common.exception.FrameworkErrorCode;
import io.seata.common.exception.FrameworkException;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.NetUtil;
import io.seata.core.protocol.RegisterRMRequest;
import io.seata.core.rpc.netty.NettyClientConfig;
import io.seata.core.rpc.netty.NettyPoolKey;
import io.seata.core.rpc.netty.NettyPoolableFactory;
import io.seata.discovery.registry.RegistryFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NettyClientChannelManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyClientChannelManager.class);
    private final ConcurrentMap<String, Object> channelLocks = new ConcurrentHashMap<String, Object>();
    private final ConcurrentMap<String, NettyPoolKey> poolKeyMap = new ConcurrentHashMap<String, NettyPoolKey>();
    private final ConcurrentMap<String, Channel> channels = new ConcurrentHashMap<String, Channel>();
    private final GenericKeyedObjectPool<NettyPoolKey, Channel> nettyClientKeyPool;
    private Function<String, NettyPoolKey> poolKeyFunction;

    NettyClientChannelManager(NettyPoolableFactory keyPoolableFactory, Function<String, NettyPoolKey> poolKeyFunction, NettyClientConfig clientConfig) {
        this.nettyClientKeyPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)keyPoolableFactory);
        this.nettyClientKeyPool.setConfig(this.getNettyPoolConfig(clientConfig));
        this.poolKeyFunction = poolKeyFunction;
    }

    private GenericKeyedObjectPool.Config getNettyPoolConfig(NettyClientConfig clientConfig) {
        GenericKeyedObjectPool.Config poolConfig = new GenericKeyedObjectPool.Config();
        poolConfig.maxActive = clientConfig.getMaxPoolActive();
        poolConfig.minIdle = clientConfig.getMinPoolIdle();
        poolConfig.maxWait = clientConfig.getMaxAcquireConnMills();
        poolConfig.testOnBorrow = clientConfig.isPoolTestBorrow();
        poolConfig.testOnReturn = clientConfig.isPoolTestReturn();
        poolConfig.lifo = clientConfig.isPoolLifo();
        return poolConfig;
    }

    ConcurrentMap<String, Channel> getChannels() {
        return this.channels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Channel acquireChannel(String serverAddress) {
        Channel channelToServer = (Channel)this.channels.get(serverAddress);
        if (channelToServer != null && (channelToServer = this.getExistAliveChannel(channelToServer, serverAddress)) != null) {
            return channelToServer;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("will connect to " + serverAddress);
        }
        this.channelLocks.putIfAbsent(serverAddress, new Object());
        Object v = this.channelLocks.get(serverAddress);
        synchronized (v) {
            return this.doConnect(serverAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseChannel(Channel channel, String serverAddress) {
        if (channel == null || serverAddress == null) {
            return;
        }
        try {
            Object v = this.channelLocks.get(serverAddress);
            synchronized (v) {
                Channel ch = (Channel)this.channels.get(serverAddress);
                if (ch == null) {
                    this.nettyClientKeyPool.returnObject(this.poolKeyMap.get(serverAddress), (Object)channel);
                    return;
                }
                if (ch.compareTo((Object)channel) == 0) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("return to pool, rm channel:{}", (Object)channel);
                    }
                    this.destroyChannel(serverAddress, channel);
                } else {
                    this.nettyClientKeyPool.returnObject(this.poolKeyMap.get(serverAddress), (Object)channel);
                }
            }
        }
        catch (Exception exx) {
            LOGGER.error(exx.getMessage());
        }
    }

    void destroyChannel(String serverAddress, Channel channel) {
        if (channel == null) {
            return;
        }
        try {
            if (channel.equals(this.channels.get(serverAddress))) {
                this.channels.remove(serverAddress);
            }
            this.nettyClientKeyPool.returnObject(this.poolKeyMap.get(serverAddress), (Object)channel);
        }
        catch (Exception exx) {
            LOGGER.error("return channel to rmPool error:{}", (Object)exx.getMessage());
        }
    }

    void reconnect(String transactionServiceGroup) {
        List<String> availList = null;
        try {
            availList = this.getAvailServerList(transactionServiceGroup);
        }
        catch (Exception e) {
            LOGGER.error("Failed to get available servers: {}", (Object)e.getMessage(), (Object)e);
            return;
        }
        if (CollectionUtils.isEmpty(availList)) {
            String serviceGroup = RegistryFactory.getInstance().getServiceGroup(transactionServiceGroup);
            LOGGER.error("no available service '{}' found, please make sure registry config correct", (Object)serviceGroup);
            return;
        }
        for (String serverAddress : availList) {
            try {
                this.acquireChannel(serverAddress);
            }
            catch (Exception e) {
                LOGGER.error("{} can not connect to {} cause:{}", new Object[]{FrameworkErrorCode.NetConnect.getErrCode(), serverAddress, e.getMessage(), e});
            }
        }
    }

    void invalidateObject(String serverAddress, Channel channel) throws Exception {
        this.nettyClientKeyPool.invalidateObject(this.poolKeyMap.get(serverAddress), (Object)channel);
    }

    void registerChannel(String serverAddress, Channel channel) {
        if (this.channels.get(serverAddress) != null && ((Channel)this.channels.get(serverAddress)).isActive()) {
            return;
        }
        this.channels.put(serverAddress, channel);
    }

    private Channel doConnect(String serverAddress) {
        Channel channelFromPool;
        Channel channelToServer = (Channel)this.channels.get(serverAddress);
        if (channelToServer != null && channelToServer.isActive()) {
            return channelToServer;
        }
        try {
            NettyPoolKey currentPoolKey = this.poolKeyFunction.apply(serverAddress);
            NettyPoolKey previousPoolKey = this.poolKeyMap.putIfAbsent(serverAddress, currentPoolKey);
            if (previousPoolKey != null && previousPoolKey.getMessage() instanceof RegisterRMRequest) {
                RegisterRMRequest registerRMRequest = (RegisterRMRequest)currentPoolKey.getMessage();
                ((RegisterRMRequest)previousPoolKey.getMessage()).setResourceIds(registerRMRequest.getResourceIds());
            }
            channelFromPool = (Channel)this.nettyClientKeyPool.borrowObject(this.poolKeyMap.get(serverAddress));
            this.channels.put(serverAddress, channelFromPool);
        }
        catch (Exception exx) {
            LOGGER.error("{} register RM failed.", (Object)FrameworkErrorCode.RegisterRM.getErrCode(), (Object)exx);
            throw new FrameworkException("can not register RM,err:" + exx.getMessage());
        }
        return channelFromPool;
    }

    private List<String> getAvailServerList(String transactionServiceGroup) throws Exception {
        List availInetSocketAddressList = RegistryFactory.getInstance().lookup(transactionServiceGroup);
        if (CollectionUtils.isEmpty((Collection)availInetSocketAddressList)) {
            return Collections.emptyList();
        }
        return availInetSocketAddressList.stream().map(NetUtil::toStringAddress).collect(Collectors.toList());
    }

    private Channel getExistAliveChannel(Channel rmChannel, String serverAddress) {
        int i;
        if (rmChannel.isActive()) {
            return rmChannel;
        }
        for (i = 0; i < NettyClientConfig.getMaxCheckAliveRetry(); ++i) {
            try {
                Thread.sleep(NettyClientConfig.getCheckAliveInternal());
            }
            catch (InterruptedException exx) {
                LOGGER.error(exx.getMessage());
            }
            rmChannel = (Channel)this.channels.get(serverAddress);
            if (rmChannel == null || !rmChannel.isActive()) continue;
            return rmChannel;
        }
        if (i == NettyClientConfig.getMaxCheckAliveRetry()) {
            LOGGER.warn("channel {} is not active after long wait, close it.", (Object)rmChannel);
            this.releaseChannel(rmChannel, serverAddress);
            return null;
        }
        return null;
    }
}

