/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.serializer;

import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.core.serializer.Serializer;
import io.seata.core.serializer.SerializerType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SerializerFactory {
    protected static final Map<SerializerType, Serializer> CODEC_MAP = new ConcurrentHashMap<SerializerType, Serializer>();

    public static Serializer getSerializer(byte serializeCode) {
        SerializerType serializerType = SerializerType.getByCode(serializeCode);
        if (CODEC_MAP.get((Object)serializerType) != null) {
            return CODEC_MAP.get((Object)serializerType);
        }
        Serializer codecImpl = (Serializer)EnhancedServiceLoader.load(Serializer.class, (String)serializerType.name());
        CODEC_MAP.putIfAbsent(serializerType, codecImpl);
        return codecImpl;
    }

    public static <T> byte[] encode(byte serializeCode, T t) {
        return SerializerFactory.getSerializer(serializeCode).serialize(t);
    }

    public static <T> T decode(byte codec, byte[] bytes) {
        return SerializerFactory.getSerializer(codec).deserialize(bytes);
    }
}

