/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec;

import io.seata.common.util.StringUtils;
import io.seata.core.context.RootContext;
import io.seata.rm.datasource.StatementProxy;
import io.seata.rm.datasource.exec.BaseTransactionalExecutor;
import io.seata.rm.datasource.exec.LockConflictException;
import io.seata.rm.datasource.exec.LockRetryController;
import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.rm.datasource.sql.SQLRecognizer;
import io.seata.rm.datasource.sql.SQLSelectRecognizer;
import io.seata.rm.datasource.sql.struct.TableRecords;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectForUpdateExecutor<T, S extends Statement>
extends BaseTransactionalExecutor<T, S> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectForUpdateExecutor.class);

    public SelectForUpdateExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T doExecute(Object ... args) throws Throwable {
        Connection conn = this.statementProxy.getConnection();
        DatabaseMetaData dbmd = conn.getMetaData();
        T rs = null;
        Savepoint sp = null;
        LockRetryController lockRetryController = new LockRetryController();
        boolean originalAutoCommit = conn.getAutoCommit();
        ArrayList<List<Object>> paramAppenderList = new ArrayList<List<Object>>();
        String selectPKSQL = this.buildSelectSQL(paramAppenderList);
        try {
            if (originalAutoCommit) {
                conn.setAutoCommit(false);
            } else if (dbmd.supportsSavepoints()) {
                sp = conn.setSavepoint();
            } else {
                throw new SQLException("not support savepoint. please check your db version");
            }
            while (true) {
                try {
                    rs = this.statementCallback.execute(this.statementProxy.getTargetStatement(), args);
                    TableRecords selectPKRows = this.buildTableRecords(this.getTableMeta(), selectPKSQL, paramAppenderList);
                    String lockKeys = this.buildLockKey(selectPKRows);
                    if (StringUtils.isNullOrEmpty((String)lockKeys)) {
                        break;
                    }
                    if (RootContext.inGlobalTransaction()) {
                        this.statementProxy.getConnectionProxy().checkLock(lockKeys);
                        break;
                    }
                    if (RootContext.requireGlobalLock()) {
                        this.statementProxy.getConnectionProxy().appendLockKey(lockKeys);
                        break;
                    }
                    throw new RuntimeException("Unknown situation!");
                }
                catch (LockConflictException lce) {
                    if (sp != null) {
                        conn.rollback(sp);
                    } else {
                        conn.rollback();
                    }
                    lockRetryController.sleep(lce);
                    continue;
                }
                break;
            }
        }
        finally {
            block22: {
                if (sp != null) {
                    try {
                        conn.releaseSavepoint(sp);
                    }
                    catch (SQLException e) {
                        if (!LOGGER.isWarnEnabled()) break block22;
                        LOGGER.warn("{} does not support release save point, but this is not a error.", (Object)this.getDbType());
                    }
                }
            }
            if (originalAutoCommit) {
                conn.setAutoCommit(true);
            }
        }
        return rs;
    }

    private String buildSelectSQL(ArrayList<List<Object>> paramAppenderList) {
        SQLSelectRecognizer recognizer = (SQLSelectRecognizer)this.sqlRecognizer;
        StringBuilder selectSQLAppender = new StringBuilder("SELECT ");
        selectSQLAppender.append(this.getColumnNameInSQL(this.getTableMeta().getPkName()));
        selectSQLAppender.append(" FROM ").append(this.getFromTableInSQL());
        String whereCondition = this.buildWhereCondition(recognizer, paramAppenderList);
        if (StringUtils.isNotBlank((String)whereCondition)) {
            selectSQLAppender.append(" WHERE ").append(whereCondition);
        }
        selectSQLAppender.append(" FOR UPDATE");
        return selectSQLAppender.toString();
    }
}

