/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.sql;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import io.seata.rm.datasource.sql.SQLOperateRecognizerHolder;
import io.seata.rm.datasource.sql.SQLOperateRecognizerHolderFactory;
import io.seata.rm.datasource.sql.SQLRecognizer;
import java.util.List;

public class SQLVisitorFactory {
    public static SQLRecognizer get(String sql, String dbType) {
        List asts = SQLUtils.parseStatements((String)sql, (String)dbType);
        if (asts == null || asts.size() != 1) {
            throw new UnsupportedOperationException("Unsupported SQL: " + sql);
        }
        SQLRecognizer recognizer = null;
        SQLStatement ast = (SQLStatement)asts.get(0);
        SQLOperateRecognizerHolder recognizerHolder = SQLOperateRecognizerHolderFactory.getSQLRecognizerHolder(dbType.toLowerCase());
        if (ast instanceof SQLInsertStatement) {
            recognizer = recognizerHolder.getInsertRecognizer(sql, ast);
        } else if (ast instanceof SQLUpdateStatement) {
            recognizer = recognizerHolder.getUpdateRecognizer(sql, ast);
        } else if (ast instanceof SQLDeleteStatement) {
            recognizer = recognizerHolder.getDeleteRecognizer(sql, ast);
        } else if (ast instanceof SQLSelectStatement) {
            recognizer = recognizerHolder.getSelectForUpdateRecognizer(sql, ast);
        }
        return recognizer;
    }
}

