/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.executor;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import io.shardingsphere.core.executor.ShardingExecuteEngine;
import io.shardingsphere.core.executor.ShardingExecuteGroup;
import io.shardingsphere.core.executor.StatementExecuteUnit;
import io.shardingsphere.core.executor.sql.execute.SQLExecuteCallback;
import io.shardingsphere.core.executor.sql.execute.SQLExecuteTemplate;
import io.shardingsphere.core.executor.sql.prepare.SQLExecutePrepareTemplate;
import io.shardingsphere.shardingjdbc.jdbc.core.connection.ShardingConnection;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class AbstractStatementExecutor {
    private final DatabaseType databaseType;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final int resultSetHoldability;
    private final ShardingConnection connection;
    private final SQLExecutePrepareTemplate sqlExecutePrepareTemplate;
    private final SQLExecuteTemplate sqlExecuteTemplate;
    private final Collection<Connection> connections = new LinkedList<Connection>();
    private final List<List<Object>> parameterSets = new LinkedList<List<Object>>();
    private final List<Statement> statements = new LinkedList<Statement>();
    private final List<ResultSet> resultSets = new CopyOnWriteArrayList<ResultSet>();
    private final Collection<ShardingExecuteGroup<StatementExecuteUnit>> executeGroups = new LinkedList<ShardingExecuteGroup<StatementExecuteUnit>>();

    public AbstractStatementExecutor(int resultSetType, int resultSetConcurrency, int resultSetHoldability, ShardingConnection shardingConnection) {
        this.databaseType = shardingConnection.getShardingContext().getDatabaseType();
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.connection = shardingConnection;
        int maxConnectionsSizePerQuery = (Integer)this.connection.getShardingContext().getShardingProperties().getValue(ShardingPropertiesConstant.MAX_CONNECTIONS_SIZE_PER_QUERY);
        ShardingExecuteEngine executeEngine = this.connection.getShardingContext().getExecuteEngine();
        this.sqlExecutePrepareTemplate = new SQLExecutePrepareTemplate(maxConnectionsSizePerQuery);
        this.sqlExecuteTemplate = new SQLExecuteTemplate(executeEngine);
    }

    protected final void cacheStatements() {
        for (ShardingExecuteGroup<StatementExecuteUnit> each : this.executeGroups) {
            this.statements.addAll(Lists.transform((List)each.getInputs(), (Function)new Function<StatementExecuteUnit, Statement>(){

                public Statement apply(StatementExecuteUnit input) {
                    return input.getStatement();
                }
            }));
            this.parameterSets.addAll(Lists.transform((List)each.getInputs(), (Function)new Function<StatementExecuteUnit, List<Object>>(){

                public List<Object> apply(StatementExecuteUnit input) {
                    return (List)input.getRouteUnit().getSqlUnit().getParameterSets().get(0);
                }
            }));
        }
    }

    protected final <T> List<T> executeCallback(SQLExecuteCallback<T> executeCallback) throws SQLException {
        return this.sqlExecuteTemplate.executeGroup(this.executeGroups, executeCallback);
    }

    public void clear() throws SQLException {
        this.clearStatements();
        this.statements.clear();
        this.parameterSets.clear();
        this.connections.clear();
        this.resultSets.clear();
        this.executeGroups.clear();
    }

    private void clearStatements() throws SQLException {
        for (Statement each : this.getStatements()) {
            each.close();
        }
    }

    protected DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    protected ShardingConnection getConnection() {
        return this.connection;
    }

    protected SQLExecutePrepareTemplate getSqlExecutePrepareTemplate() {
        return this.sqlExecutePrepareTemplate;
    }

    protected SQLExecuteTemplate getSqlExecuteTemplate() {
        return this.sqlExecuteTemplate;
    }

    protected Collection<Connection> getConnections() {
        return this.connections;
    }

    protected Collection<ShardingExecuteGroup<StatementExecuteUnit>> getExecuteGroups() {
        return this.executeGroups;
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public List<List<Object>> getParameterSets() {
        return this.parameterSets;
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public List<ResultSet> getResultSets() {
        return this.resultSets;
    }
}

