/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingjdbc.jdbc.core.statement;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.SQLType;
import io.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import io.shardingsphere.core.executor.sql.execute.result.StreamQueryResult;
import io.shardingsphere.core.merger.MergeEngine;
import io.shardingsphere.core.merger.MergeEngineFactory;
import io.shardingsphere.core.metadata.table.ShardingTableMetaData;
import io.shardingsphere.core.metadata.table.executor.TableMetaDataConnectionManager;
import io.shardingsphere.core.metadata.table.executor.TableMetaDataLoader;
import io.shardingsphere.core.parsing.antlr.sql.statement.ddl.AlterTableStatement;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dal.DALStatement;
import io.shardingsphere.core.parsing.parser.sql.ddl.create.table.CreateTableStatement;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.DQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.routing.SQLRouteResult;
import io.shardingsphere.core.routing.StatementRoutingEngine;
import io.shardingsphere.core.routing.router.sharding.GeneratedKey;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.shardingjdbc.executor.StatementExecutor;
import io.shardingsphere.shardingjdbc.jdbc.adapter.AbstractStatementAdapter;
import io.shardingsphere.shardingjdbc.jdbc.core.ShardingContext;
import io.shardingsphere.shardingjdbc.jdbc.core.connection.ShardingConnection;
import io.shardingsphere.shardingjdbc.jdbc.core.resultset.GeneratedKeysResultSet;
import io.shardingsphere.shardingjdbc.jdbc.core.resultset.ShardingResultSet;
import io.shardingsphere.shardingjdbc.jdbc.metadata.JDBCTableMetaDataConnectionManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;

public final class ShardingStatement
extends AbstractStatementAdapter {
    private final ShardingConnection connection;
    private final StatementExecutor statementExecutor;
    private boolean returnGeneratedKeys;
    private SQLRouteResult routeResult;
    private ResultSet currentResultSet;

    public ShardingStatement(ShardingConnection connection) {
        this(connection, 1003, 1007, 1);
    }

    public ShardingStatement(ShardingConnection connection, int resultSetType, int resultSetConcurrency) {
        this(connection, resultSetType, resultSetConcurrency, 1);
    }

    public ShardingStatement(ShardingConnection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(Statement.class);
        this.connection = connection;
        this.statementExecutor = new StatementExecutor(resultSetType, resultSetConcurrency, resultSetHoldability, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        ShardingResultSet result;
        try {
            this.clearPrevious();
            this.sqlRoute(sql);
            this.initStatementExecutor();
            MergeEngine mergeEngine = MergeEngineFactory.newInstance((ShardingRule)this.connection.getShardingContext().getShardingRule(), this.statementExecutor.executeQuery(), (SQLStatement)this.routeResult.getSqlStatement(), (ShardingTableMetaData)this.connection.getShardingContext().getMetaData().getTable());
            result = new ShardingResultSet(this.statementExecutor.getResultSets(), mergeEngine.merge(), this);
        }
        finally {
            this.currentResultSet = null;
        }
        this.currentResultSet = result;
        return result;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            this.clearPrevious();
            this.sqlRoute(sql);
            this.initStatementExecutor();
            int n = this.statementExecutor.executeUpdate();
            return n;
        }
        finally {
            this.refreshTableMetaData();
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (1 == autoGeneratedKeys) {
            this.returnGeneratedKeys = true;
        }
        try {
            this.clearPrevious();
            this.sqlRoute(sql);
            this.initStatementExecutor();
            int n = this.statementExecutor.executeUpdate(autoGeneratedKeys);
            return n;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            this.clearPrevious();
            this.sqlRoute(sql);
            this.initStatementExecutor();
            int n = this.statementExecutor.executeUpdate(columnIndexes);
            return n;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            this.clearPrevious();
            this.sqlRoute(sql);
            this.initStatementExecutor();
            int n = this.statementExecutor.executeUpdate(columnNames);
            return n;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            this.clearPrevious();
            this.sqlRoute(sql);
            this.initStatementExecutor();
            boolean bl = this.statementExecutor.execute();
            return bl;
        }
        finally {
            this.refreshTableMetaData();
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        if (1 == autoGeneratedKeys) {
            this.returnGeneratedKeys = true;
        }
        try {
            this.clearPrevious();
            this.sqlRoute(sql);
            this.initStatementExecutor();
            boolean bl = this.statementExecutor.execute(autoGeneratedKeys);
            return bl;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            this.clearPrevious();
            this.sqlRoute(sql);
            this.initStatementExecutor();
            boolean bl = this.statementExecutor.execute(columnIndexes);
            return bl;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.returnGeneratedKeys = true;
        try {
            this.clearPrevious();
            this.sqlRoute(sql);
            this.initStatementExecutor();
            boolean bl = this.statementExecutor.execute(columnNames);
            return bl;
        }
        finally {
            this.currentResultSet = null;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (null != this.currentResultSet) {
            return this.currentResultSet;
        }
        if (1 == this.statementExecutor.getStatements().size() && this.routeResult.getSqlStatement() instanceof DQLStatement) {
            this.currentResultSet = this.statementExecutor.getStatements().iterator().next().getResultSet();
            return this.currentResultSet;
        }
        ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>(this.statementExecutor.getStatements().size());
        ArrayList<StreamQueryResult> queryResults = new ArrayList<StreamQueryResult>(this.statementExecutor.getStatements().size());
        for (Statement each : this.statementExecutor.getStatements()) {
            ResultSet resultSet = each.getResultSet();
            resultSets.add(resultSet);
            queryResults.add(new StreamQueryResult(resultSet));
        }
        if (this.routeResult.getSqlStatement() instanceof SelectStatement || this.routeResult.getSqlStatement() instanceof DALStatement) {
            MergeEngine mergeEngine = MergeEngineFactory.newInstance((ShardingRule)this.connection.getShardingContext().getShardingRule(), queryResults, (SQLStatement)this.routeResult.getSqlStatement(), (ShardingTableMetaData)this.connection.getShardingContext().getMetaData().getTable());
            this.currentResultSet = new ShardingResultSet(resultSets, mergeEngine.merge(), this);
        }
        return this.currentResultSet;
    }

    private void initStatementExecutor() throws SQLException {
        this.statementExecutor.init(this.routeResult);
        this.replayMethodForStatements();
    }

    private void replayMethodForStatements() {
        for (Statement each : this.statementExecutor.getStatements()) {
            this.replayMethodsInvocation(each);
        }
    }

    private void sqlRoute(String sql) {
        ShardingContext shardingContext = this.connection.getShardingContext();
        this.routeResult = new StatementRoutingEngine(shardingContext.getShardingRule(), shardingContext.getMetaData().getTable(), shardingContext.getDatabaseType(), ((Boolean)shardingContext.getShardingProperties().getValue(ShardingPropertiesConstant.SQL_SHOW)).booleanValue(), shardingContext.getMetaData().getDataSource()).route(sql);
    }

    private void refreshTableMetaData() throws SQLException {
        if (null != this.routeResult && null != this.connection && SQLType.DDL == this.routeResult.getSqlStatement().getType() && !this.routeResult.getSqlStatement().getTables().isEmpty()) {
            String logicTableName = this.routeResult.getSqlStatement().getTables().getSingleTableName();
            if (this.routeResult.getSqlStatement() instanceof CreateTableStatement) {
                CreateTableStatement createStatement = (CreateTableStatement)this.routeResult.getSqlStatement();
                this.connection.getShardingContext().getMetaData().getTable().put(logicTableName, createStatement.getTableMetaData());
            } else if (this.routeResult.getSqlStatement() instanceof AlterTableStatement) {
                AlterTableStatement alterStatement = (AlterTableStatement)this.routeResult.getSqlStatement();
                this.connection.getShardingContext().getMetaData().getTable().put(logicTableName, alterStatement.getTableMetaData());
            } else {
                TableMetaDataLoader tableMetaDataLoader = new TableMetaDataLoader(this.connection.getShardingContext().getMetaData().getDataSource(), this.connection.getShardingContext().getExecuteEngine(), (TableMetaDataConnectionManager)new JDBCTableMetaDataConnectionManager(this.connection.getDataSourceMap()), ((Integer)this.connection.getShardingContext().getShardingProperties().getValue(ShardingPropertiesConstant.MAX_CONNECTIONS_SIZE_PER_QUERY)).intValue());
                this.connection.getShardingContext().getMetaData().getTable().put(logicTableName, tableMetaDataLoader.load(logicTableName, this.connection.getShardingContext().getShardingRule()));
            }
        }
    }

    private void clearPrevious() throws SQLException {
        this.statementExecutor.clear();
    }

    @Override
    public int getResultSetType() {
        return this.statementExecutor.getResultSetType();
    }

    @Override
    public int getResultSetConcurrency() {
        return this.statementExecutor.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() {
        return this.statementExecutor.getResultSetHoldability();
    }

    public Collection<Statement> getRoutedStatements() {
        return this.statementExecutor.getStatements();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        Optional<GeneratedKey> generatedKey = this.getGeneratedKey();
        if (this.returnGeneratedKeys && generatedKey.isPresent()) {
            return new GeneratedKeysResultSet(this.routeResult.getGeneratedKey().getGeneratedKeys().iterator(), ((GeneratedKey)generatedKey.get()).getColumn().getName(), this);
        }
        if (1 == this.getRoutedStatements().size()) {
            return this.getRoutedStatements().iterator().next().getGeneratedKeys();
        }
        return new GeneratedKeysResultSet();
    }

    private Optional<GeneratedKey> getGeneratedKey() {
        if (null != this.routeResult && this.routeResult.getSqlStatement() instanceof InsertStatement) {
            return Optional.fromNullable((Object)this.routeResult.getGeneratedKey());
        }
        return Optional.absent();
    }

    @Override
    public ShardingConnection getConnection() {
        return this.connection;
    }
}

