/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.checkstyle.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import io.spring.javaformat.checkstyle.check.AbstractSpringCheck;
import io.spring.javaformat.config.IndentationStyle;
import io.spring.javaformat.config.JavaFormatConfig;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpringLeadingWhitespaceCheck
extends AbstractSpringCheck {
    private static final Pattern PATTERN = Pattern.compile("^([\\ \\t]+)\\S");
    private static final Map<IndentationStyle, Pattern> INDENTATION_STYLE_PATTERN;
    private IndentationStyle indentationStyle;

    public int[] getAcceptableTokens() {
        return NO_REQUIRED_TOKENS;
    }

    public void beginTree(DetailAST rootAST) {
        super.beginTree(rootAST);
        FileContents fileContents = this.getFileContents();
        FileText fileText = fileContents.getText();
        File file = fileText.getFile();
        if (file == null) {
            return;
        }
        IndentationStyle indentationStyle = this.indentationStyle != null ? this.indentationStyle : JavaFormatConfig.findFrom((File)file.getParentFile()).getIndentationStyle();
        for (int i = 0; i < fileText.size(); ++i) {
            String line = fileText.get(i);
            int lineNo = i + 1;
            Matcher matcher = PATTERN.matcher(line);
            boolean found = matcher.find(0);
            while (found && fileContents.hasIntersectionWithComment(lineNo, matcher.start(0), lineNo, matcher.end(0) - 1)) {
                found = matcher.find(matcher.end(0));
            }
            if (!found || INDENTATION_STYLE_PATTERN.get(indentationStyle).matcher(matcher.group(1)).matches()) continue;
            this.log(lineNo, "leadingwhitespace.incorrect", new Object[]{indentationStyle.toString().toLowerCase()});
        }
    }

    public void setIndentationStyle(String indentationStyle) {
        this.indentationStyle = indentationStyle != null && !"".equals(indentationStyle) ? IndentationStyle.valueOf((String)indentationStyle.toUpperCase()) : null;
    }

    static {
        HashMap<IndentationStyle, Pattern> indentationStylePatterns = new HashMap<IndentationStyle, Pattern>();
        indentationStylePatterns.put(IndentationStyle.TABS, Pattern.compile("\\t*"));
        indentationStylePatterns.put(IndentationStyle.SPACES, Pattern.compile("\\ *"));
        INDENTATION_STYLE_PATTERN = Collections.unmodifiableMap(indentationStylePatterns);
    }
}

