/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.dump;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.task.NacosTask;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.manager.TaskManager;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoAggr;
import com.alibaba.nacos.config.server.model.ConfigInfoChanged;
import com.alibaba.nacos.config.server.model.ConfigInfoWrapper;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import com.alibaba.nacos.config.server.service.datasource.DynamicDataSource;
import com.alibaba.nacos.config.server.service.dump.processor.DumpAllBetaProcessor;
import com.alibaba.nacos.config.server.service.dump.processor.DumpAllProcessor;
import com.alibaba.nacos.config.server.service.dump.processor.DumpAllTagProcessor;
import com.alibaba.nacos.config.server.service.dump.processor.DumpChangeProcessor;
import com.alibaba.nacos.config.server.service.dump.processor.DumpProcessor;
import com.alibaba.nacos.config.server.service.dump.task.DumpAllBetaTask;
import com.alibaba.nacos.config.server.service.dump.task.DumpAllTagTask;
import com.alibaba.nacos.config.server.service.dump.task.DumpAllTask;
import com.alibaba.nacos.config.server.service.dump.task.DumpChangeTask;
import com.alibaba.nacos.config.server.service.dump.task.DumpTask;
import com.alibaba.nacos.config.server.service.merge.MergeTaskProcessor;
import com.alibaba.nacos.config.server.service.repository.PersistService;
import com.alibaba.nacos.config.server.utils.ConfigExecutor;
import com.alibaba.nacos.config.server.utils.ContentUtils;
import com.alibaba.nacos.config.server.utils.DiskUtil;
import com.alibaba.nacos.config.server.utils.GroupKey;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.utils.TimerContext;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.utils.InetUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DumpService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DumpService.class);
    protected DumpProcessor processor;
    protected DumpAllProcessor dumpAllProcessor;
    protected DumpAllBetaProcessor dumpAllBetaProcessor;
    protected DumpAllTagProcessor dumpAllTagProcessor;
    protected final PersistService persistService;
    protected final ServerMemberManager memberManager;
    static final int DUMP_ALL_INTERVAL_IN_MINUTE = 360;
    static final int INITIAL_DELAY_IN_MINUTE = 360;
    private TaskManager dumpTaskMgr;
    private TaskManager dumpAllTaskMgr;
    static final AtomicInteger FINISHED = new AtomicInteger();
    static final int INIT_THREAD_COUNT = 10;
    int total = 0;
    private static final String TRUE_STR = "true";
    private static final String BETA_TABLE_NAME = "config_info_beta";
    private static final String TAG_TABLE_NAME = "config_info_tag";
    Boolean isQuickStart = false;
    private int retentionDays = 30;

    public DumpService(PersistService persistService, ServerMemberManager memberManager) {
        this.persistService = persistService;
        this.memberManager = memberManager;
        this.processor = new DumpProcessor(this);
        this.dumpAllProcessor = new DumpAllProcessor(this);
        this.dumpAllBetaProcessor = new DumpAllBetaProcessor(this);
        this.dumpAllTagProcessor = new DumpAllTagProcessor(this);
        this.dumpTaskMgr = new TaskManager("com.alibaba.nacos.server.DumpTaskManager");
        this.dumpTaskMgr.setDefaultTaskProcessor(this.processor);
        this.dumpAllTaskMgr = new TaskManager("com.alibaba.nacos.server.DumpAllTaskManager");
        this.dumpAllTaskMgr.setDefaultTaskProcessor(this.dumpAllProcessor);
        this.dumpAllTaskMgr.addProcessor("dumpAllConfigTask", this.dumpAllProcessor);
        this.dumpAllTaskMgr.addProcessor("dumpAllBetaConfigTask", this.dumpAllBetaProcessor);
        this.dumpAllTaskMgr.addProcessor("dumpAllTagConfigTask", this.dumpAllTagProcessor);
        DynamicDataSource.getInstance().getDataSource();
    }

    public PersistService getPersistService() {
        return this.persistService;
    }

    public ServerMemberManager getMemberManager() {
        return this.memberManager;
    }

    protected abstract void init() throws Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpOperate(DumpProcessor processor, DumpAllProcessor dumpAllProcessor, DumpAllBetaProcessor dumpAllBetaProcessor, DumpAllTagProcessor dumpAllTagProcessor) throws NacosException {
        String dumpFileContext = "CONFIG_DUMP_TO_FILE";
        TimerContext.start((String)dumpFileContext);
        try {
            LogUtil.DEFAULT_LOG.warn("DumpService start");
            Runnable dumpAll = () -> this.dumpAllTaskMgr.addTask((Object)"dumpAllConfigTask", new DumpAllTask());
            Runnable dumpAllBeta = () -> this.dumpAllTaskMgr.addTask((Object)"dumpAllBetaConfigTask", new DumpAllBetaTask());
            Runnable dumpAllTag = () -> this.dumpAllTaskMgr.addTask((Object)"dumpAllTagConfigTask", new DumpAllTagTask());
            Runnable clearConfigHistory = () -> {
                LOGGER.warn("clearConfigHistory start");
                if (this.canExecute()) {
                    try {
                        Timestamp startTime = this.getBeforeStamp(TimeUtils.getCurrentTime(), 24 * this.getRetentionDays());
                        int totalCount = this.persistService.findConfigHistoryCountByTime(startTime);
                        if (totalCount > 0) {
                            int removeTime;
                            int pageSize = 1000;
                            LOGGER.warn("clearConfigHistory, getBeforeStamp:{}, totalCount:{}, pageSize:{}, removeTime:{}", new Object[]{startTime, totalCount, pageSize, removeTime});
                            for (removeTime = (totalCount + pageSize - 1) / pageSize; removeTime > 0; --removeTime) {
                                this.persistService.removeConfigHistory(startTime, pageSize);
                            }
                        }
                    }
                    catch (Throwable e) {
                        LOGGER.error("clearConfigHistory error : {}", (Object)e.toString());
                    }
                }
            };
            try {
                List<ConfigInfoChanged> configList;
                this.dumpConfigInfo(dumpAllProcessor);
                LogUtil.DEFAULT_LOG.info("start clear all config-info-beta.");
                DiskUtil.clearAllBeta();
                if (this.persistService.isExistTable(BETA_TABLE_NAME)) {
                    dumpAllBetaProcessor.process((NacosTask)new DumpAllBetaTask());
                }
                LogUtil.DEFAULT_LOG.info("start clear all config-info-tag.");
                DiskUtil.clearAllTag();
                if (this.persistService.isExistTable(TAG_TABLE_NAME)) {
                    dumpAllTagProcessor.process((NacosTask)new DumpAllTagTask());
                }
                if ((configList = this.persistService.findAllAggrGroup()) != null && !configList.isEmpty()) {
                    this.total = configList.size();
                    List<List<ConfigInfoChanged>> splitList = DumpService.splitList(configList, 10);
                    for (List<ConfigInfoChanged> list : splitList) {
                        MergeAllDataWorker work = new MergeAllDataWorker(list);
                        work.start();
                    }
                    LOGGER.info("server start, schedule merge end.");
                }
            }
            catch (Exception e) {
                LogUtil.FATAL_LOG.error("Nacos Server did not start because dumpservice bean construction failure :\n" + e.toString());
                throw new NacosException(500, "Nacos Server did not start because dumpservice bean construction failure :\n" + e.getMessage(), (Throwable)e);
            }
            if (!EnvUtil.getStandaloneMode()) {
                Runnable heartbeat = () -> {
                    String heartBeatTime = TimeUtils.getCurrentTime().toString();
                    try {
                        DiskUtil.saveHeartBeatToDisk(heartBeatTime);
                    }
                    catch (IOException e) {
                        LogUtil.FATAL_LOG.error("save heartbeat fail" + e.getMessage());
                    }
                };
                ConfigExecutor.scheduleConfigTask(heartbeat, 0L, 10L, TimeUnit.SECONDS);
                long initialDelay = new Random().nextInt(360) + 10;
                LogUtil.DEFAULT_LOG.warn("initialDelay:{}", (Object)initialDelay);
                ConfigExecutor.scheduleConfigTask(dumpAll, initialDelay, 360L, TimeUnit.MINUTES);
                ConfigExecutor.scheduleConfigTask(dumpAllBeta, initialDelay, 360L, TimeUnit.MINUTES);
                ConfigExecutor.scheduleConfigTask(dumpAllTag, initialDelay, 360L, TimeUnit.MINUTES);
            }
            ConfigExecutor.scheduleConfigTask(clearConfigHistory, 10L, 10L, TimeUnit.MINUTES);
        }
        finally {
            TimerContext.end((String)dumpFileContext, (Logger)LogUtil.DUMP_LOG);
        }
    }

    private void dumpConfigInfo(DumpAllProcessor dumpAllProcessor) throws IOException {
        int timeStep = 6;
        boolean isAllDump = true;
        FileInputStream fis = null;
        Timestamp heartheatLastStamp = null;
        try {
            File heartbeatFile;
            if (this.isQuickStart().booleanValue() && (heartbeatFile = DiskUtil.heartBeatFile()).exists()) {
                fis = new FileInputStream(heartbeatFile);
                String heartheatTempLast = IoUtils.toString((InputStream)fis, (String)"UTF-8");
                heartheatLastStamp = Timestamp.valueOf(heartheatTempLast);
                if (TimeUtils.getCurrentTime().getTime() - heartheatLastStamp.getTime() < (long)(timeStep * 60 * 60 * 1000)) {
                    isAllDump = false;
                }
            }
            if (isAllDump) {
                LogUtil.DEFAULT_LOG.info("start clear all config-info.");
                DiskUtil.clearAll();
                dumpAllProcessor.process((NacosTask)new DumpAllTask());
            } else {
                Timestamp beforeTimeStamp = this.getBeforeStamp(heartheatLastStamp, timeStep);
                DumpChangeProcessor dumpChangeProcessor = new DumpChangeProcessor(this, beforeTimeStamp, TimeUtils.getCurrentTime());
                dumpChangeProcessor.process((NacosTask)new DumpChangeTask());
                Runnable checkMd5Task = () -> {
                    LogUtil.DEFAULT_LOG.error("start checkMd5Task");
                    List<String> diffList = ConfigCacheService.checkMd5();
                    for (String groupKey : diffList) {
                        String[] dg = GroupKey.parseKey(groupKey);
                        String dataId = dg[0];
                        String group = dg[1];
                        String tenant = dg[2];
                        ConfigInfoWrapper configInfo = this.persistService.queryConfigInfo(dataId, group, tenant);
                        ConfigCacheService.dumpChange(dataId, group, tenant, configInfo.getContent(), configInfo.getLastModified());
                    }
                    LogUtil.DEFAULT_LOG.error("end checkMd5Task");
                };
                ConfigExecutor.scheduleConfigTask(checkMd5Task, 0L, 12L, TimeUnit.HOURS);
            }
        }
        catch (IOException e) {
            LogUtil.FATAL_LOG.error("dump config fail" + e.getMessage());
            throw e;
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LogUtil.DEFAULT_LOG.warn("close file failed");
                }
            }
        }
    }

    private Timestamp getBeforeStamp(Timestamp date, int step) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(11, -step);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return Timestamp.valueOf(format.format(cal.getTime()));
    }

    private Boolean isQuickStart() {
        try {
            String val = null;
            val = EnvUtil.getProperty((String)"isQuickStart");
            if (val != null && TRUE_STR.equals(val)) {
                this.isQuickStart = true;
            }
            LogUtil.FATAL_LOG.warn("isQuickStart:{}", (Object)this.isQuickStart);
        }
        catch (Exception e) {
            LogUtil.FATAL_LOG.error("read application.properties wrong", (Throwable)e);
        }
        return this.isQuickStart;
    }

    private int getRetentionDays() {
        String val = EnvUtil.getProperty((String)"nacos.config.retention.days");
        if (null == val) {
            return this.retentionDays;
        }
        int tmp = 0;
        try {
            tmp = Integer.parseInt(val);
            if (tmp > 0) {
                this.retentionDays = tmp;
            }
        }
        catch (NumberFormatException nfe) {
            LogUtil.FATAL_LOG.error("read nacos.config.retention.days wrong", (Throwable)nfe);
        }
        return this.retentionDays;
    }

    public void dump(String dataId, String group, String tenant, String tag, long lastModified, String handleIp) {
        this.dump(dataId, group, tenant, tag, lastModified, handleIp, false);
    }

    public void dump(String dataId, String group, String tenant, long lastModified, String handleIp) {
        this.dump(dataId, group, tenant, lastModified, handleIp, false);
    }

    public void dump(String dataId, String group, String tenant, long lastModified, String handleIp, boolean isBeta) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        String taskKey = String.join((CharSequence)"+", dataId, group, tenant, String.valueOf(isBeta));
        this.dumpTaskMgr.addTask((Object)taskKey, new DumpTask(groupKey, lastModified, handleIp, isBeta));
        LogUtil.DUMP_LOG.info("[dump-task] add task. groupKey={}, taskKey={}", (Object)groupKey, (Object)taskKey);
    }

    public void dump(String dataId, String group, String tenant, String tag, long lastModified, String handleIp, boolean isBeta) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        String taskKey = String.join((CharSequence)"+", dataId, group, tenant, String.valueOf(isBeta), tag);
        this.dumpTaskMgr.addTask((Object)taskKey, new DumpTask(groupKey, tag, lastModified, handleIp, isBeta));
        LogUtil.DUMP_LOG.info("[dump-task] add task. groupKey={}, taskKey={}", (Object)groupKey, (Object)taskKey);
    }

    public void dumpAll() {
        this.dumpAllTaskMgr.addTask((Object)"dumpAllConfigTask", new DumpAllTask());
    }

    static List<List<ConfigInfoChanged>> splitList(List<ConfigInfoChanged> list, int count) {
        int i;
        ArrayList<List<ConfigInfoChanged>> result = new ArrayList<List<ConfigInfoChanged>>(count);
        for (i = 0; i < count; ++i) {
            result.add(new ArrayList());
        }
        for (i = 0; i < list.size(); ++i) {
            ConfigInfoChanged config = list.get(i);
            ((List)result.get(i % count)).add(config);
        }
        return result;
    }

    protected abstract boolean canExecute();

    class MergeAllDataWorker
    extends Thread {
        static final int PAGE_SIZE = 10000;
        private List<ConfigInfoChanged> configInfoList;

        public MergeAllDataWorker(List<ConfigInfoChanged> configInfoList) {
            super("MergeAllDataWorker");
            this.configInfoList = configInfoList;
        }

        @Override
        public void run() {
            if (!DumpService.this.canExecute()) {
                return;
            }
            for (ConfigInfoChanged configInfo : this.configInfoList) {
                String dataId = configInfo.getDataId();
                String group = configInfo.getGroup();
                String tenant = configInfo.getTenant();
                try {
                    ArrayList<ConfigInfoAggr> datumList = new ArrayList<ConfigInfoAggr>();
                    int rowCount = DumpService.this.persistService.aggrConfigInfoCount(dataId, group, tenant);
                    int pageCount = (int)Math.ceil((double)rowCount * 1.0 / 10000.0);
                    for (int pageNo = 1; pageNo <= pageCount; ++pageNo) {
                        Page<ConfigInfoAggr> page = DumpService.this.persistService.findConfigInfoAggrByPage(dataId, group, tenant, pageNo, 10000);
                        if (page == null) continue;
                        datumList.addAll(page.getPageItems());
                        LOGGER.info("[merge-query] {}, {}, size/total={}/{}", new Object[]{dataId, group, datumList.size(), rowCount});
                    }
                    Timestamp time = TimeUtils.getCurrentTime();
                    if (datumList.size() > 0) {
                        String aggrConetentMD5;
                        ConfigInfo cf = MergeTaskProcessor.merge(dataId, group, tenant, datumList);
                        String aggrContent = cf.getContent();
                        String localContentMD5 = ConfigCacheService.getContentMd5(GroupKey.getKey(dataId, group));
                        if (!StringUtils.equals((String)localContentMD5, (String)(aggrConetentMD5 = MD5Utils.md5Hex((String)aggrContent, (String)"UTF-8")))) {
                            DumpService.this.persistService.insertOrUpdate(null, null, cf, time, null, false);
                            LOGGER.info("[merge-ok] {}, {}, size={}, length={}, md5={}, content={}", new Object[]{dataId, group, datumList.size(), cf.getContent().length(), cf.getMd5(), ContentUtils.truncateContent(cf.getContent())});
                        }
                    } else {
                        DumpService.this.persistService.removeConfigInfo(dataId, group, tenant, InetUtils.getSelfIP(), null);
                        LOGGER.warn("[merge-delete] delete config info because no datum. dataId=" + dataId + ", groupId=" + group);
                    }
                }
                catch (Throwable e) {
                    LOGGER.info("[merge-error] " + dataId + ", " + group + ", " + e.toString(), e);
                }
                FINISHED.incrementAndGet();
                if (FINISHED.get() % 100 != 0) continue;
                LOGGER.info("[all-merge-dump] {} / {}", (Object)FINISHED.get(), (Object)DumpService.this.total);
            }
            LOGGER.info("[all-merge-dump] {} / {}", (Object)FINISHED.get(), (Object)DumpService.this.total);
        }
    }
}

