/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.interceptor.KeyGenerator;
import springfox.documentation.spi.schema.contexts.ModelContext;

public class ModelContextKeyGenerator
implements KeyGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(ModelContextKeyGenerator.class);
    private final TypeResolver resolver;

    public ModelContextKeyGenerator(TypeResolver resolver) {
        this.resolver = resolver;
    }

    public Object generate(Object target, Method method, Object ... params) {
        Optional context = FluentIterable.from((Iterable)Lists.newArrayList((Object[])params)).filter(ModelContext.class).first();
        if (context.isPresent()) {
            String key = String.format("%s(%s)", ((ModelContext)context.get()).resolvedType(this.resolver).toString(), ((ModelContext)context.get()).isReturnType());
            LOG.info("Cache Key Generated: {}", (Object)key);
            return key;
        }
        throw new IllegalArgumentException("Key generator can only be used where at least one parameter is of type ModelContext");
    }
}

