/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.Types;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.ParameterContext;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;
import springfox.documentation.spring.web.readers.parameter.ExpansionContext;
import springfox.documentation.spring.web.readers.parameter.ModelAttributeParameterExpander;

@Component
@Order(value=-2147483648)
public class OperationParameterReader
implements OperationBuilderPlugin {
    private final ModelAttributeParameterExpander expander;
    private final EnumTypeDeterminer enumTypeDeterminer;
    @Autowired
    private DocumentationPluginsManager pluginsManager;

    @Autowired
    public OperationParameterReader(ModelAttributeParameterExpander expander, EnumTypeDeterminer enumTypeDeterminer) {
        this.expander = expander;
        this.enumTypeDeterminer = enumTypeDeterminer;
    }

    public void apply(OperationContext context) {
        context.operationBuilder().parameters(context.getGlobalOperationParameters());
        context.operationBuilder().parameters(this.readParameters(context));
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private List<Parameter> readParameters(OperationContext context) {
        List methodParameters = context.getParameters();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (ResolvedMethodParameter methodParameter : methodParameters) {
            ResolvedType alternate;
            if (this.shouldIgnore(methodParameter, alternate = context.alternateFor(methodParameter.getParameterType()), context.getIgnorableParameterTypes())) continue;
            ParameterContext parameterContext = new ParameterContext(methodParameter, new ParameterBuilder(), context.getDocumentationContext(), context.getGenericsNamingStrategy(), context);
            if (this.shouldExpand(methodParameter, alternate)) {
                parameters.addAll(this.expander.expand(new ExpansionContext("", alternate, context)));
                continue;
            }
            parameters.add(this.pluginsManager.parameter(parameterContext));
        }
        return parameters.stream().filter(((Predicate<Parameter>)Parameter::isHidden).negate()).collect(Collectors.toList());
    }

    private boolean shouldIgnore(ResolvedMethodParameter parameter, ResolvedType resolvedParameterType, Set<Class> ignorableParamTypes) {
        if (ignorableParamTypes.contains(resolvedParameterType.getErasedType())) {
            return true;
        }
        return ignorableParamTypes.stream().filter(Annotation.class::isAssignableFrom).anyMatch(arg_0 -> ((ResolvedMethodParameter)parameter).hasParameterAnnotation(arg_0));
    }

    private boolean shouldExpand(ResolvedMethodParameter parameter, ResolvedType resolvedParamType) {
        return !parameter.hasParameterAnnotation(RequestBody.class) && !parameter.hasParameterAnnotation(RequestPart.class) && !parameter.hasParameterAnnotation(RequestParam.class) && !parameter.hasParameterAnnotation(PathVariable.class) && !Types.isBaseType((String)Types.typeNameFor((Type)resolvedParamType.getErasedType())) && !this.enumTypeDeterminer.isEnum(resolvedParamType.getErasedType()) && !Collections.isContainerType((ResolvedType)resolvedParamType) && !Maps.isMapType((ResolvedType)resolvedParamType);
    }
}

