/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.utils.concurrent.threadpool;

import java.util.AbstractQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.springside.modules.utils.concurrent.threadpool.QueuableCachedThreadPool;
import org.springside.modules.utils.concurrent.threadpool.ThreadPoolUtil;

public class ThreadPoolBuilder {
    private static RejectedExecutionHandler defaultRejectHandler = new ThreadPoolExecutor.AbortPolicy();

    public static FixedThreadPoolBuilder fixedPool() {
        return new FixedThreadPoolBuilder();
    }

    public static CachedThreadPoolBuilder cachedPool() {
        return new CachedThreadPoolBuilder();
    }

    public static ScheduledThreadPoolBuilder scheduledPool() {
        return new ScheduledThreadPoolBuilder();
    }

    public static QueuableCachedThreadPoolBuilder queuableCachedPool() {
        return new QueuableCachedThreadPoolBuilder();
    }

    private static ThreadFactory createThreadFactory(ThreadFactory threadFactory, String threadNamePrefix, Boolean daemon) {
        if (threadFactory != null) {
            return threadFactory;
        }
        if (threadNamePrefix != null) {
            if (daemon != null) {
                return ThreadPoolUtil.buildThreadFactory(threadNamePrefix, daemon);
            }
            return ThreadPoolUtil.buildThreadFactory(threadNamePrefix);
        }
        return Executors.defaultThreadFactory();
    }

    public static class QueuableCachedThreadPoolBuilder {
        private int minSize = 0;
        private int maxSize = Integer.MAX_VALUE;
        private int keepAliveSecs = 10;
        private int queueSize = 100;
        private ThreadFactory threadFactory = null;
        private String threadNamePrefix = null;
        private Boolean daemon = null;
        private RejectedExecutionHandler rejectHandler;

        public QueuableCachedThreadPoolBuilder setMinSize(int minSize) {
            this.minSize = minSize;
            return this;
        }

        public QueuableCachedThreadPoolBuilder setMaxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public QueuableCachedThreadPoolBuilder setQueueSize(int queueSize) {
            this.queueSize = queueSize;
            return this;
        }

        public QueuableCachedThreadPoolBuilder setKeepAliveSecs(int keepAliveSecs) {
            this.keepAliveSecs = keepAliveSecs;
            return this;
        }

        public QueuableCachedThreadPoolBuilder setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public QueuableCachedThreadPoolBuilder setThreadNamePrefix(String threadNamePrefix) {
            this.threadNamePrefix = threadNamePrefix;
            return this;
        }

        public QueuableCachedThreadPoolBuilder setDaemon(Boolean daemon) {
            this.daemon = daemon;
            return this;
        }

        public QueuableCachedThreadPoolBuilder setRejectHanlder(RejectedExecutionHandler rejectHandler) {
            this.rejectHandler = rejectHandler;
            return this;
        }

        public QueuableCachedThreadPool build() {
            this.threadFactory = ThreadPoolBuilder.createThreadFactory(this.threadFactory, this.threadNamePrefix, this.daemon);
            if (this.rejectHandler == null) {
                this.rejectHandler = defaultRejectHandler;
            }
            return new QueuableCachedThreadPool(this.minSize, this.maxSize, (long)this.keepAliveSecs, TimeUnit.SECONDS, new QueuableCachedThreadPool.ControllableQueue(this.queueSize), this.threadFactory, this.rejectHandler);
        }
    }

    public static class ScheduledThreadPoolBuilder {
        private int poolSize = 1;
        private ThreadFactory threadFactory = null;
        private String threadNamePrefix = null;

        public ScheduledThreadPoolBuilder setPoolSize(int poolSize) {
            this.poolSize = poolSize;
            return this;
        }

        public ScheduledThreadPoolBuilder setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public ScheduledThreadPoolBuilder setThreadNamePrefix(String threadNamePrefix) {
            this.threadNamePrefix = threadNamePrefix;
            return this;
        }

        public ScheduledThreadPoolExecutor build() {
            this.threadFactory = ThreadPoolBuilder.createThreadFactory(this.threadFactory, this.threadNamePrefix, Boolean.TRUE);
            return new ScheduledThreadPoolExecutor(this.poolSize, this.threadFactory);
        }
    }

    public static class CachedThreadPoolBuilder {
        private int minSize = 0;
        private int maxSize = Integer.MAX_VALUE;
        private int keepAliveSecs = 10;
        private ThreadFactory threadFactory = null;
        private String threadNamePrefix = null;
        private Boolean daemon = null;
        private RejectedExecutionHandler rejectHandler;

        public CachedThreadPoolBuilder setMinSize(int minSize) {
            this.minSize = minSize;
            return this;
        }

        public CachedThreadPoolBuilder setMaxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public CachedThreadPoolBuilder setKeepAliveSecs(int keepAliveSecs) {
            this.keepAliveSecs = keepAliveSecs;
            return this;
        }

        public CachedThreadPoolBuilder setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public CachedThreadPoolBuilder setThreadNamePrefix(String threadNamePrefix) {
            this.threadNamePrefix = threadNamePrefix;
            return this;
        }

        public CachedThreadPoolBuilder setDaemon(Boolean daemon) {
            this.daemon = daemon;
            return this;
        }

        public CachedThreadPoolBuilder setRejectHanlder(RejectedExecutionHandler rejectHandler) {
            this.rejectHandler = rejectHandler;
            return this;
        }

        public ThreadPoolExecutor build() {
            this.threadFactory = ThreadPoolBuilder.createThreadFactory(this.threadFactory, this.threadNamePrefix, this.daemon);
            if (this.rejectHandler == null) {
                this.rejectHandler = defaultRejectHandler;
            }
            return new ThreadPoolExecutor(this.minSize, this.maxSize, this.keepAliveSecs, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.threadFactory, this.rejectHandler);
        }
    }

    public static class FixedThreadPoolBuilder {
        private int poolSize = 1;
        private int queueSize = -1;
        private ThreadFactory threadFactory = null;
        private String threadNamePrefix = null;
        private Boolean daemon = null;
        private RejectedExecutionHandler rejectHandler;

        public FixedThreadPoolBuilder setPoolSize(int poolSize) {
            Validate.isTrue((poolSize >= 1 ? 1 : 0) != 0);
            this.poolSize = poolSize;
            return this;
        }

        public FixedThreadPoolBuilder setQueueSize(int queueSize) {
            this.queueSize = queueSize;
            return this;
        }

        public FixedThreadPoolBuilder setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public FixedThreadPoolBuilder setThreadNamePrefix(String threadNamePrefix) {
            this.threadNamePrefix = threadNamePrefix;
            return this;
        }

        public FixedThreadPoolBuilder setDaemon(Boolean daemon) {
            this.daemon = daemon;
            return this;
        }

        public FixedThreadPoolBuilder setRejectHanlder(RejectedExecutionHandler rejectHandler) {
            this.rejectHandler = rejectHandler;
            return this;
        }

        public ThreadPoolExecutor build() {
            AbstractQueue queue = null;
            queue = this.queueSize < 1 ? new LinkedBlockingQueue() : new ArrayBlockingQueue(this.queueSize);
            this.threadFactory = ThreadPoolBuilder.createThreadFactory(this.threadFactory, this.threadNamePrefix, this.daemon);
            if (this.rejectHandler == null) {
                this.rejectHandler = defaultRejectHandler;
            }
            return new ThreadPoolExecutor(this.poolSize, this.poolSize, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)((Object)queue), this.threadFactory, this.rejectHandler);
        }
    }
}

