/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.utils.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassUtil {
    private static final String CGLIB_CLASS_SEPARATOR = "$$";
    private static Logger logger = LoggerFactory.getLogger(ClassUtil.class);
    private static final Map<Class<?>, Class<?>> primitiveWrapperTypeMap = new IdentityHashMap(8);
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    private static final String IS_PREFIX = "is";

    public static String getShortClassName(Class<?> cls) {
        return ClassUtils.getShortClassName(cls);
    }

    public static String getShortClassName(String className) {
        return ClassUtils.getShortClassName((String)className);
    }

    public static String getPackageName(Class<?> cls) {
        return ClassUtils.getPackageName(cls);
    }

    public static String getPackageName(String className) {
        return ClassUtils.getPackageName((String)className);
    }

    public static List<Class<?>> getAllSuperclasses(Class<?> cls) {
        return ClassUtils.getAllSuperclasses(cls);
    }

    public static List<Class<?>> getAllInterfaces(Class<?> cls) {
        return ClassUtils.getAllInterfaces(cls);
    }

    public static Set<Annotation> getAllAnnotations(Class<?> cls) {
        List<Class<?>> allTypes = ClassUtil.getAllSuperclasses(cls);
        allTypes.addAll(ClassUtil.getAllInterfaces(cls));
        allTypes.add(cls);
        HashSet<Annotation> anns = new HashSet<Annotation>();
        for (Class<?> type : allTypes) {
            anns.addAll(Arrays.asList(type.getDeclaredAnnotations()));
        }
        HashSet<Annotation> superAnnotations = new HashSet<Annotation>();
        for (Annotation ann : anns) {
            ClassUtil.getSupperAnnotations(ann.annotationType(), superAnnotations);
        }
        anns.addAll(superAnnotations);
        return anns;
    }

    private static <A extends Annotation> void getSupperAnnotations(Class<A> annotationType, Set<Annotation> visited) {
        Annotation[] anns;
        for (Annotation ann : anns = annotationType.getDeclaredAnnotations()) {
            if (ann.annotationType().getName().startsWith("java.lang") || !visited.add(ann)) continue;
            ClassUtil.getSupperAnnotations(ann.annotationType(), visited);
        }
    }

    public static <T extends Annotation> Set<Field> getAnnotatedPublicFields(Class<? extends Object> clazz, Class<T> annotation) {
        Field[] fields;
        if (Object.class.equals(clazz)) {
            return Collections.emptySet();
        }
        HashSet<Field> annotatedFields = new HashSet<Field>();
        for (Field field : fields = clazz.getFields()) {
            if (field.getAnnotation(annotation) == null) continue;
            annotatedFields.add(field);
        }
        return annotatedFields;
    }

    public static <T extends Annotation> Set<Field> getAnnotatedFields(Class<? extends Object> clazz, Class<T> annotation) {
        Field[] fields;
        if (Object.class.equals(clazz)) {
            return Collections.emptySet();
        }
        HashSet<Field> annotatedFields = new HashSet<Field>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (field.getAnnotation(annotation) == null) continue;
            annotatedFields.add(field);
        }
        annotatedFields.addAll(ClassUtil.getAnnotatedFields(clazz.getSuperclass(), annotation));
        return annotatedFields;
    }

    public static <T extends Annotation> Set<Method> getAnnotatedPublicMethods(Class<?> clazz, Class<T> annotation) {
        Method[] methods;
        if (Object.class.equals(clazz)) {
            return Collections.emptySet();
        }
        List ifcs = ClassUtils.getAllInterfaces(clazz);
        HashSet<Method> annotatedMethods = new HashSet<Method>();
        for (Method method : methods = clazz.getMethods()) {
            if (method.getAnnotation(annotation) == null && !ClassUtil.searchOnInterfaces(method, annotation, ifcs)) continue;
            annotatedMethods.add(method);
        }
        return annotatedMethods;
    }

    private static <T extends Annotation> boolean searchOnInterfaces(Method method, Class<T> annotationType, List<Class<?>> ifcs) {
        for (Class<?> iface : ifcs) {
            try {
                Method equivalentMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                if (equivalentMethod.getAnnotation(annotationType) == null) continue;
                return true;
            }
            catch (NoSuchMethodException ex) {
            }
        }
        return false;
    }

    public static Method getSetterMethod(Class<?> clazz, String propertyName, Class<?> parameterType) {
        String setterMethodName = SETTER_PREFIX + StringUtils.capitalize((String)propertyName);
        return ClassUtil.getAccessibleMethod(clazz, setterMethodName, parameterType);
    }

    public static Method getGetterMethod(Class<?> clazz, String propertyName) {
        String getterMethodName = GETTER_PREFIX + StringUtils.capitalize((String)propertyName);
        Method method = ClassUtil.getAccessibleMethod(clazz, getterMethodName, new Class[0]);
        if (method == null) {
            getterMethodName = IS_PREFIX + StringUtils.capitalize((String)propertyName);
            method = ClassUtil.getAccessibleMethod(clazz, getterMethodName, new Class[0]);
        }
        return method;
    }

    public static Field getAccessibleField(Class clazz, String fieldName) {
        Validate.notNull((Object)clazz, (String)"clazz can't be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)fieldName, (String)"fieldName can't be blank", (Object[])new Object[0]);
        for (Class superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(fieldName);
                ClassUtil.makeAccessible(field);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static Method getAccessibleMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Validate.notNull(clazz, (String)"class can't be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)methodName, (String)"methodName can't be blank", (Object[])new Object[0]);
        Class[] theParameterTypes = ArrayUtils.nullToEmpty((Class[])parameterTypes);
        ClassUtil.wrapClassses(theParameterTypes);
        for (Class<?> searchType = clazz; searchType != Object.class; searchType = searchType.getSuperclass()) {
            try {
                Method method = searchType.getDeclaredMethod(methodName, theParameterTypes);
                ClassUtil.makeAccessible(method);
                return method;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        return null;
    }

    public static Method getAccessibleMethodByName(Class clazz, String methodName) {
        Validate.notNull((Object)clazz, (String)"clazz can't be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)methodName, (String)"methodName can't be blank", (Object[])new Object[0]);
        for (Class searchType = clazz; searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                ClassUtil.makeAccessible(method);
                return method;
            }
        }
        return null;
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    private static void wrapClassses(Class<?>[] source) {
        for (int i = 0; i < source.length; ++i) {
            Class<?> wrapClass = primitiveWrapperTypeMap.get(source[i]);
            if (wrapClass == null) continue;
            source[i] = wrapClass;
        }
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable ex) {
            // empty catch block
        }
        if (cl == null && (cl = ClassUtils.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    public static Class<?> unwrapCglib(Object instance) {
        Class<?> superClass;
        Validate.notNull((Object)instance, (String)"Instance must not be null", (Object[])new Object[0]);
        Class<?> clazz = instance.getClass();
        if (clazz != null && clazz.getName().contains(CGLIB_CLASS_SEPARATOR) && (superClass = clazz.getSuperclass()) != null && !Object.class.equals(superClass)) {
            return superClass;
        }
        return clazz;
    }

    public static <T> Class<T> getClassGenricType(Class clazz) {
        return ClassUtil.getClassGenricType(clazz, 0);
    }

    public static Class getClassGenricType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            logger.warn(clazz.getSimpleName() + "'s superclass not ParameterizedType");
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            logger.warn("Index: " + index + ", Size of " + clazz.getSimpleName() + "'s Parameterized Type: " + params.length);
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            logger.warn(clazz.getSimpleName() + " not set the actual class on superclass generic parameter");
            return Object.class;
        }
        return (Class)params[index];
    }

    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            classLoader.loadClass(className);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    static {
        primitiveWrapperTypeMap.put(Boolean.class, Boolean.TYPE);
        primitiveWrapperTypeMap.put(Byte.class, Byte.TYPE);
        primitiveWrapperTypeMap.put(Character.class, Character.TYPE);
        primitiveWrapperTypeMap.put(Double.class, Double.TYPE);
        primitiveWrapperTypeMap.put(Float.class, Float.TYPE);
        primitiveWrapperTypeMap.put(Integer.class, Integer.TYPE);
        primitiveWrapperTypeMap.put(Long.class, Long.TYPE);
        primitiveWrapperTypeMap.put(Short.class, Short.TYPE);
    }
}

