/*
 * Decompiled with CFR 0.152.
 */
package org.springside.modules.utils.text;

import org.apache.commons.lang3.StringUtils;
import org.springside.modules.utils.base.Platforms;

public class WildcardMatcher {
    protected static final String PATH_MATCH = "**";
    protected static final String PATH_SEPARATORS = "/\\";

    public static boolean match(CharSequence string, CharSequence pattern) {
        return WildcardMatcher.match(string, pattern, 0, 0);
    }

    private static boolean match(CharSequence string, CharSequence pattern, int sNdx, int pNdx) {
        int pLen = pattern.length();
        if (pLen == 1 && pattern.charAt(0) == '*') {
            return true;
        }
        int sLen = string.length();
        boolean nextIsNotWildcard = false;
        while (true) {
            if (sNdx >= sLen) {
                while (pNdx < pLen && pattern.charAt(pNdx) == '*') {
                    ++pNdx;
                }
                return pNdx >= pLen;
            }
            if (pNdx >= pLen) {
                return false;
            }
            char p = pattern.charAt(pNdx);
            if (!nextIsNotWildcard) {
                if (p == '\\') {
                    ++pNdx;
                    nextIsNotWildcard = true;
                    continue;
                }
                if (p == '?') {
                    ++sNdx;
                    ++pNdx;
                    continue;
                }
                if (p == '*') {
                    int pNext = 0;
                    if (pNdx + 1 < pLen) {
                        pNext = pattern.charAt(pNdx + 1);
                    }
                    if (pNext == 42) {
                        ++pNdx;
                        continue;
                    }
                    ++pNdx;
                    for (int i = string.length(); i >= sNdx; --i) {
                        if (!WildcardMatcher.match(string, pattern, i, pNdx)) continue;
                        return true;
                    }
                    return false;
                }
            } else {
                nextIsNotWildcard = false;
            }
            if (p != string.charAt(sNdx)) {
                return false;
            }
            ++sNdx;
            ++pNdx;
        }
    }

    public static int matchOne(String src, String[] patterns) {
        for (int i = 0; i < patterns.length; ++i) {
            if (!WildcardMatcher.match(src, patterns[i])) continue;
            return i;
        }
        return -1;
    }

    public static int matchPathOne(String path, String[] patterns) {
        for (int i = 0; i < patterns.length; ++i) {
            if (!WildcardMatcher.matchPath(path, patterns[i])) continue;
            return i;
        }
        return -1;
    }

    public static boolean matchPath(String path, String pattern) {
        String[] pathElements = StringUtils.split((String)path, (char)Platforms.FILE_PATH_SEPARATOR_CHAR);
        String[] patternElements = StringUtils.split((String)pattern, (char)Platforms.FILE_PATH_SEPARATOR_CHAR);
        return WildcardMatcher.matchTokens(pathElements, patternElements);
    }

    protected static boolean matchTokens(String[] tokens, String[] patterns) {
        String patDir;
        int tokNdxStart;
        int patNdxStart = 0;
        int patNdxEnd = patterns.length - 1;
        int tokNdxEnd = tokens.length - 1;
        for (tokNdxStart = 0; patNdxStart <= patNdxEnd && tokNdxStart <= tokNdxEnd && !(patDir = patterns[patNdxStart]).equals(PATH_MATCH); ++patNdxStart, ++tokNdxStart) {
            if (WildcardMatcher.match(tokens[tokNdxStart], patDir)) continue;
            return false;
        }
        if (tokNdxStart > tokNdxEnd) {
            for (int i = patNdxStart; i <= patNdxEnd; ++i) {
                if (patterns[i].equals(PATH_MATCH)) continue;
                return false;
            }
            return true;
        }
        if (patNdxStart > patNdxEnd) {
            return false;
        }
        while (patNdxStart <= patNdxEnd && tokNdxStart <= tokNdxEnd && !(patDir = patterns[patNdxEnd]).equals(PATH_MATCH)) {
            if (!WildcardMatcher.match(tokens[tokNdxEnd], patDir)) {
                return false;
            }
            --patNdxEnd;
            --tokNdxEnd;
        }
        if (tokNdxStart > tokNdxEnd) {
            for (int i = patNdxStart; i <= patNdxEnd; ++i) {
                if (patterns[i].equals(PATH_MATCH)) continue;
                return false;
            }
            return true;
        }
        while (patNdxStart != patNdxEnd && tokNdxStart <= tokNdxEnd) {
            int patIdxTmp = -1;
            for (int i = patNdxStart + 1; i <= patNdxEnd; ++i) {
                if (!patterns[i].equals(PATH_MATCH)) continue;
                patIdxTmp = i;
                break;
            }
            if (patIdxTmp == patNdxStart + 1) {
                ++patNdxStart;
                continue;
            }
            int patLength = patIdxTmp - patNdxStart - 1;
            int strLength = tokNdxEnd - tokNdxStart + 1;
            int ndx = -1;
            block6: for (int i = 0; i <= strLength - patLength; ++i) {
                for (int j = 0; j < patLength; ++j) {
                    String subStr = tokens[tokNdxStart + i + j];
                    String subPat = patterns[patNdxStart + j + 1];
                    if (!WildcardMatcher.match(subStr, subPat)) continue block6;
                }
                ndx = tokNdxStart + i;
                break;
            }
            if (ndx == -1) {
                return false;
            }
            patNdxStart = patIdxTmp;
            tokNdxStart = ndx + patLength;
        }
        for (int i = patNdxStart; i <= patNdxEnd; ++i) {
            if (patterns[i].equals(PATH_MATCH)) continue;
            return false;
        }
        return true;
    }
}

