/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import io.trino.jdbc.$internal.client.CloseableIterator;
import io.trino.jdbc.$internal.client.Column;
import io.trino.jdbc.$internal.client.JsonDecodingUtils;
import io.trino.jdbc.$internal.guava.base.Verify;
import io.trino.jdbc.$internal.guava.base.VerifyException;
import io.trino.jdbc.$internal.guava.collect.AbstractIterator;
import io.trino.jdbc.$internal.guava.io.Closer;
import io.trino.jdbc.$internal.jackson.core.JsonFactory;
import io.trino.jdbc.$internal.jackson.core.JsonParser;
import io.trino.jdbc.$internal.jackson.core.JsonToken;
import io.trino.jdbc.$internal.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;

public final class JsonIterators {
    private static final JsonFactory JSON_FACTORY = JsonIterators.createJsonFactory();

    private JsonIterators() {
    }

    public static CloseableIterator<List<Object>> forJsonParser(JsonParser parser, List<Column> columns) throws IOException {
        return new JsonIterator(parser, JsonDecodingUtils.createTypeDecoders(columns));
    }

    public static CloseableIterator<List<Object>> forInputStream(InputStream stream, JsonDecodingUtils.TypeDecoder[] decoders) throws IOException {
        return new JsonIterator(stream, decoders);
    }

    @SuppressModernizer
    static JsonFactory createJsonFactory() {
        return new JsonFactory().setCodec(new ObjectMapper()).enable(JsonParser.Feature.USE_FAST_DOUBLE_PARSER).enable(JsonParser.Feature.USE_FAST_BIG_NUMBER_PARSER).disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
    }

    private static class JsonIterator
    extends AbstractIterator<List<Object>>
    implements CloseableIterator<List<Object>> {
        private final Closer closer = Closer.create();
        private boolean closed;
        private final JsonParser parser;
        private final JsonDecodingUtils.TypeDecoder[] decoders;

        public JsonIterator(JsonParser parser, JsonDecodingUtils.TypeDecoder[] decoders) throws IOException {
            Objects.requireNonNull(decoders, "decoders is null");
            this.parser = Objects.requireNonNull(parser, "parser is null");
            this.decoders = decoders;
            this.closer.register(parser);
            Verify.verify(parser.nextToken() == JsonToken.START_ARRAY, "Expected start of an array, but got %s", (Object)parser.currentToken());
            switch (parser.nextToken()) {
                case END_ARRAY: {
                    this.closed = true;
                    break;
                }
                case START_ARRAY: {
                    break;
                }
                default: {
                    throw new VerifyException("Expected start of the data array, but got " + String.valueOf((Object)parser.currentToken()));
                }
            }
        }

        public JsonIterator(InputStream stream, JsonDecodingUtils.TypeDecoder[] decoders) throws IOException {
            this(JSON_FACTORY.createParser(Objects.requireNonNull(stream, "stream is null")), decoders);
            this.closer.register(stream);
        }

        private void checkIfClosed() {
            try {
                Verify.verify(this.parser.nextToken() == JsonToken.END_ARRAY, "Expected end of data array, but got %s", (Object)this.parser.currentToken());
                switch (this.parser.nextToken()) {
                    case END_ARRAY: {
                        this.close();
                        break;
                    }
                    case START_ARRAY: {
                        break;
                    }
                    default: {
                        throw new VerifyException("Expected end of or start of next data array, but got " + String.valueOf((Object)this.parser.currentToken()));
                    }
                }
            }
            catch (IOException e) {
                this.closed = true;
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public List<Object> computeNext() {
            if (this.closed) {
                return (List)this.endOfData();
            }
            try {
                ArrayList<Object> row = new ArrayList<Object>(this.decoders.length);
                for (JsonDecodingUtils.TypeDecoder decoder : this.decoders) {
                    if (Objects.requireNonNull(this.parser.nextToken()) == JsonToken.VALUE_NULL) {
                        row.add(null);
                        continue;
                    }
                    row.add(decoder.decode(this.parser));
                }
                this.checkIfClosed();
                return Collections.unmodifiableList(row);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            this.closer.close();
        }
    }
}

