/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.airlift.units.DataSize;
import io.trino.jdbc.$internal.client.MaterializingInputStream;
import io.trino.jdbc.$internal.client.TrinoJsonCodec;
import io.trino.jdbc.$internal.guava.base.MoreObjects;
import io.trino.jdbc.$internal.jackson.core.JsonProcessingException;
import io.trino.jdbc.$internal.okhttp3.Call;
import io.trino.jdbc.$internal.okhttp3.Headers;
import io.trino.jdbc.$internal.okhttp3.MediaType;
import io.trino.jdbc.$internal.okhttp3.Request;
import io.trino.jdbc.$internal.okhttp3.Response;
import io.trino.jdbc.$internal.okhttp3.ResponseBody;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Optional;

public final class JsonResponse<T> {
    private static final DataSize MATERIALIZED_BUFFER_SIZE = DataSize.of(8L, DataSize.Unit.KILOBYTE);
    private final int statusCode;
    private final Headers headers;
    @.Nullable
    private final String responseBody;
    private final boolean hasValue;
    private final T value;
    private final IllegalArgumentException exception;

    private JsonResponse(int statusCode, Headers headers, String responseBody) {
        this.statusCode = statusCode;
        this.headers = Objects.requireNonNull(headers, "headers is null");
        this.responseBody = Objects.requireNonNull(responseBody, "responseBody is null");
        this.hasValue = false;
        this.value = null;
        this.exception = null;
    }

    private JsonResponse(int statusCode, Headers headers, @.Nullable String responseBody, @.Nullable T value, @.Nullable IllegalArgumentException exception) {
        this.statusCode = statusCode;
        this.headers = Objects.requireNonNull(headers, "headers is null");
        this.responseBody = responseBody;
        this.value = value;
        this.exception = exception;
        this.hasValue = exception == null;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    public T getValue() {
        if (!this.hasValue) {
            throw new IllegalStateException("Response does not contain a JSON value", this.exception);
        }
        return this.value;
    }

    public Optional<String> getResponseBody() {
        return Optional.ofNullable(this.responseBody);
    }

    @.Nullable
    public IllegalArgumentException getException() {
        return this.exception;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("statusCode", this.statusCode).add("headers", this.headers.toMultimap()).add("hasValue", this.hasValue).add("value", this.value).omitNullValues().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static <T> JsonResponse<T> execute(TrinoJsonCodec<T> codec, Call.Factory client, Request request) {
        try (Response response = client.newCall(request).execute();){
            ResponseBody responseBody = Objects.requireNonNull(response.body());
            if (JsonResponse.isJson(responseBody.contentType())) {
                JsonResponse<T> jsonResponse;
                MaterializingInputStream stream = new MaterializingInputStream(responseBody.byteStream(), MATERIALIZED_BUFFER_SIZE);
                try {
                    T value = codec.fromJson(stream);
                    jsonResponse = new JsonResponse<T>(response.code(), response.headers(), stream.getHeadString(responseBody.contentType().charset()), value, null);
                }
                catch (JsonProcessingException e) {
                    try {
                        JsonResponse<Object> jsonResponse2 = new JsonResponse<Object>(response.code(), response.headers(), stream.getHeadString(), null, new IllegalArgumentException(String.format("Unable to create %s from JSON response:\n[%s]", codec.getType(), stream.getHeadString()), e));
                        return jsonResponse2;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        stream.close();
                    }
                }
                stream.close();
                return jsonResponse;
            }
            JsonResponse<T> jsonResponse = new JsonResponse<T>(response.code(), response.headers(), responseBody.string());
            return jsonResponse;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static boolean isJson(MediaType type) {
        return type != null && "application".equals(type.type()) && "json".equals(type.subtype());
    }
}

