/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.client.ProtocolVersion;
import io.vertx.redis.client.RedisConnectOptionsConverter;
import io.vertx.redis.client.RedisOptions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public abstract class RedisConnectOptions {
    private volatile String password;
    private List<String> endpoints;
    private int maxNestedArrays;
    private boolean protocolNegotiation;
    private ProtocolVersion preferredProtocolVersion;
    private int maxWaitingHandlers;

    private void init() {
        this.maxNestedArrays = 32;
        this.protocolNegotiation = true;
        this.maxWaitingHandlers = 2048;
    }

    public RedisConnectOptions(RedisOptions options) {
        this.setEndpoints(new ArrayList<String>(options.getEndpoints()));
        this.setProtocolNegotiation(options.isProtocolNegotiation());
        this.setPreferredProtocolVersion(options.getPreferredProtocolVersion());
        this.setMaxNestedArrays(options.getMaxNestedArrays());
        this.setPassword(options.getPassword());
        this.setMaxWaitingHandlers(options.getMaxWaitingHandlers());
        this.setMaxNestedArrays(options.getMaxNestedArrays());
    }

    public RedisConnectOptions() {
        this.init();
    }

    public RedisConnectOptions(RedisConnectOptions other) {
        this.init();
        this.maxNestedArrays = other.maxNestedArrays;
        this.protocolNegotiation = other.protocolNegotiation;
        this.preferredProtocolVersion = other.preferredProtocolVersion;
        this.password = other.password;
        this.endpoints = new ArrayList<String>(other.endpoints);
        this.maxWaitingHandlers = other.maxWaitingHandlers;
    }

    public RedisConnectOptions(JsonObject json) {
        this.init();
        RedisConnectOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public int getMaxNestedArrays() {
        return this.maxNestedArrays;
    }

    public RedisConnectOptions setMaxNestedArrays(int maxNestedArrays) {
        this.maxNestedArrays = maxNestedArrays;
        return this;
    }

    public boolean isProtocolNegotiation() {
        return this.protocolNegotiation;
    }

    public RedisConnectOptions setProtocolNegotiation(boolean protocolNegotiation) {
        this.protocolNegotiation = protocolNegotiation;
        return this;
    }

    public ProtocolVersion getPreferredProtocolVersion() {
        return this.preferredProtocolVersion;
    }

    public RedisConnectOptions setPreferredProtocolVersion(ProtocolVersion preferredProtocolVersion) {
        this.preferredProtocolVersion = preferredProtocolVersion;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public RedisConnectOptions setPassword(String password) {
        this.password = password;
        return this;
    }

    public List<String> getEndpoints() {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<String>();
            this.endpoints.add("redis://localhost:6379");
        }
        return this.endpoints;
    }

    public String getEndpoint() {
        if (this.endpoints == null || this.endpoints.isEmpty()) {
            return "redis://localhost:6379";
        }
        return this.endpoints.get(0);
    }

    public RedisConnectOptions setEndpoints(List<String> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public RedisConnectOptions addConnectionString(String connectionString) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<String>();
        }
        this.endpoints.add(connectionString);
        return this;
    }

    public RedisConnectOptions setConnectionString(String connectionString) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<String>();
        } else {
            this.endpoints.clear();
        }
        this.endpoints.add(connectionString);
        return this;
    }

    public int getMaxWaitingHandlers() {
        return this.maxWaitingHandlers;
    }

    public RedisConnectOptions setMaxWaitingHandlers(int maxWaitingHandlers) {
        this.maxWaitingHandlers = maxWaitingHandlers;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        RedisConnectOptionsConverter.toJson(this, json);
        return json;
    }
}

