/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.PoolOptions;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnectOptions;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisRole;
import io.vertx.redis.client.RedisSentinelConnectOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.ResponseType;
import io.vertx.redis.client.impl.BaseRedisClient;
import io.vertx.redis.client.impl.PooledRedisConnection;
import io.vertx.redis.client.impl.RedisSentinelConnection;
import io.vertx.redis.client.impl.RedisStandaloneConnection;
import io.vertx.redis.client.impl.RedisURI;
import io.vertx.redis.client.impl.Resolver;
import io.vertx.redis.client.impl.types.ErrorType;
import java.util.List;
import java.util.Random;

public class RedisSentinelClient
extends BaseRedisClient
implements Redis {
    private static final Random RANDOM = new Random();
    private static final Logger LOG = LoggerFactory.getLogger(RedisSentinelClient.class);
    private final RedisSentinelConnectOptions connectOptions;

    public RedisSentinelClient(Vertx vertx, NetClientOptions tcpOptions, PoolOptions poolOptions, RedisSentinelConnectOptions connectOptions, TracingPolicy tracingPolicy) {
        super(vertx, tcpOptions, poolOptions, connectOptions, tracingPolicy);
        this.connectOptions = connectOptions;
        if (poolOptions.getMaxSize() < 2) {
            throw new IllegalStateException("Invalid options: maxSize must be at least 2");
        }
        if (poolOptions.getMaxWaiting() < poolOptions.getMaxSize()) {
            throw new IllegalStateException("Invalid options: maxWaiting < maxSize");
        }
    }

    @Override
    public Future<RedisConnection> connect() {
        PromiseInternal promise = this.vertx.promise();
        this.createConnectionInternal(this.connectOptions, this.connectOptions.getRole(), (Handler<AsyncResult<PooledRedisConnection>>)((Handler)arg_0 -> this.lambda$connect$4((Promise)promise, arg_0)));
        return promise.future();
    }

    private void createConnectionInternal(RedisSentinelConnectOptions options, RedisRole role, Handler<AsyncResult<PooledRedisConnection>> onCreate) {
        Handler createAndConnect = resolve -> {
            if (resolve.failed()) {
                onCreate.handle((Object)Future.failedFuture((Throwable)resolve.cause()));
                return;
            }
            RedisURI uri = (RedisURI)resolve.result();
            String endpoint = this.getBaseEndpoint(uri);
            Request setup = role != RedisRole.SENTINEL && uri.select() != null ? Request.cmd(Command.SELECT).arg(uri.select()) : null;
            this.connectionManager.getConnection(endpoint, setup).onComplete(onCreate);
        };
        switch (role) {
            case SENTINEL: {
                RedisSentinelClient.resolveClient(this::isSentinelOk, options, (Handler<AsyncResult<RedisURI>>)createAndConnect);
                break;
            }
            case MASTER: {
                RedisSentinelClient.resolveClient(this::getMasterFromEndpoint, options, (Handler<AsyncResult<RedisURI>>)createAndConnect);
                break;
            }
            case REPLICA: {
                RedisSentinelClient.resolveClient(this::getReplicaFromEndpoint, options, (Handler<AsyncResult<RedisURI>>)createAndConnect);
            }
        }
    }

    private static void resolveClient(Resolver checkEndpointFn, RedisSentinelConnectOptions options, Handler<AsyncResult<RedisURI>> callback) {
        RedisSentinelClient.iterate(0, checkEndpointFn, options, (Handler<AsyncResult<Pair<Integer, RedisURI>>>)((Handler)iterate -> {
            if (iterate.failed()) {
                callback.handle((Object)Future.failedFuture((Throwable)iterate.cause()));
            } else {
                Pair found = (Pair)iterate.result();
                List<String> endpoints = options.getEndpoints();
                String endpoint = endpoints.get((Integer)found.left);
                endpoints.set((Integer)found.left, endpoints.get(0));
                endpoints.set(0, endpoint);
                callback.handle((Object)Future.succeededFuture(found.right));
            }
        }));
    }

    private static void iterate(int idx, Resolver checkEndpointFn, RedisSentinelConnectOptions argument, Handler<AsyncResult<Pair<Integer, RedisURI>>> resultHandler) {
        List<String> endpoints = argument.getEndpoints();
        if (idx >= endpoints.size()) {
            resultHandler.handle((Object)Future.failedFuture((String)"No more endpoints in chain."));
            return;
        }
        checkEndpointFn.resolve(endpoints.get(idx), argument, (Handler<AsyncResult<RedisURI>>)((Handler)res -> {
            if (res.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture(new Pair<Integer, Object>(idx, res.result())));
            } else {
                RedisSentinelClient.iterate(idx + 1, checkEndpointFn, argument, resultHandler);
            }
        }));
    }

    private void isSentinelOk(String endpoint, RedisConnectOptions argument, Handler<AsyncResult<RedisURI>> handler) {
        RedisURI uri = new RedisURI(endpoint);
        this.connectionManager.getConnection(this.getBaseEndpoint(uri), null).onFailure(err -> handler.handle((Object)Future.failedFuture((Throwable)err))).onSuccess(conn -> conn.send(Request.cmd(Command.PING), (Handler<AsyncResult<Response>>)((Handler)ping -> {
            if (ping.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)ping.cause()));
            } else {
                handler.handle((Object)Future.succeededFuture((Object)uri));
            }
            conn.close().onFailure(arg_0 -> ((Logger)LOG).warn(arg_0));
        })));
    }

    private void getMasterFromEndpoint(String endpoint, RedisSentinelConnectOptions options, Handler<AsyncResult<RedisURI>> handler) {
        RedisURI uri = new RedisURI(endpoint);
        this.connectionManager.getConnection(this.getBaseEndpoint(uri), null).onFailure(err -> handler.handle((Object)Future.failedFuture((Throwable)err))).onSuccess(conn -> {
            String masterName = options.getMasterName();
            conn.send(Request.cmd(Command.SENTINEL).arg("GET-MASTER-ADDR-BY-NAME").arg(masterName), (Handler<AsyncResult<Response>>)((Handler)getMasterAddrByName -> {
                conn.close().onFailure(arg_0 -> ((Logger)LOG).warn(arg_0));
                if (getMasterAddrByName.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)getMasterAddrByName.cause()));
                } else {
                    Response response = (Response)getMasterAddrByName.result();
                    if (response == null) {
                        handler.handle((Object)Future.failedFuture((String)("Failed to GET-MASTER-ADDR-BY-NAME " + masterName)));
                    } else {
                        String rHost = response.get(0).toString();
                        Integer rPort = response.get(1).toInteger();
                        handler.handle((Object)Future.succeededFuture((Object)new RedisURI(uri, rHost.contains(":") ? "[" + rHost + "]" : rHost, rPort)));
                    }
                }
            }));
        });
    }

    private void getReplicaFromEndpoint(String endpoint, RedisSentinelConnectOptions options, Handler<AsyncResult<RedisURI>> handler) {
        RedisURI uri = new RedisURI(endpoint);
        this.connectionManager.getConnection(this.getBaseEndpoint(uri), null).onFailure(err -> handler.handle((Object)Future.failedFuture((Throwable)err))).onSuccess(conn -> {
            String masterName = options.getMasterName();
            conn.send(Request.cmd(Command.SENTINEL).arg("SLAVES").arg(masterName), (Handler<AsyncResult<Response>>)((Handler)sentinelReplicas -> {
                conn.close().onFailure(arg_0 -> ((Logger)LOG).warn(arg_0));
                if (sentinelReplicas.failed()) {
                    handler.handle((Object)Future.failedFuture((Throwable)sentinelReplicas.cause()));
                } else {
                    Response response = (Response)sentinelReplicas.result();
                    if (response == null || response.size() == 0) {
                        handler.handle((Object)Future.failedFuture((String)("No replicas linked to the master: " + masterName)));
                    } else {
                        Response replicaInfoArr = response.get(RANDOM.nextInt(response.size()));
                        if (replicaInfoArr.size() % 2 > 0) {
                            handler.handle((Object)Future.failedFuture((String)"Corrupted response from the sentinel"));
                        } else {
                            int port = 6379;
                            String ip = null;
                            if (replicaInfoArr.containsKey("port")) {
                                port = replicaInfoArr.get("port").toInteger();
                            }
                            if (replicaInfoArr.containsKey("ip")) {
                                ip = replicaInfoArr.get("ip").toString();
                            }
                            if (ip == null) {
                                handler.handle((Object)Future.failedFuture((String)"No IP found for a REPLICA node!"));
                            } else {
                                String host = ip.contains(":") ? "[" + ip + "]" : ip;
                                handler.handle((Object)Future.succeededFuture((Object)new RedisURI(uri, host, port)));
                            }
                        }
                    }
                }
            }));
        });
    }

    private String getBaseEndpoint(RedisURI uri) {
        StringBuilder sb = new StringBuilder();
        if (uri.unix()) {
            sb.append("unix://");
            sb.append(uri.socketAddress().path());
        } else {
            sb.append("redis");
            if (uri.ssl()) {
                sb.append('s');
            }
            sb.append("://");
            sb.append(uri.userinfo());
            sb.append(uri.socketAddress().host());
            sb.append(':');
            sb.append(uri.socketAddress().port());
        }
        return sb.toString();
    }

    private /* synthetic */ void lambda$connect$4(Promise promise, AsyncResult createConnection) {
        if (createConnection.failed()) {
            promise.fail(createConnection.cause());
            return;
        }
        PooledRedisConnection conn = (PooledRedisConnection)createConnection.result();
        this.createConnectionInternal(this.connectOptions, RedisRole.SENTINEL, (Handler<AsyncResult<PooledRedisConnection>>)((Handler)create -> {
            if (create.failed()) {
                LOG.error((Object)"Redis PUB/SUB wrap failed.", create.cause());
                promise.fail(create.cause());
                return;
            }
            PooledRedisConnection sentinel = (PooledRedisConnection)create.result();
            sentinel.handler(msg -> {
                if (msg.type() == ResponseType.MULTI && "MESSAGE".equalsIgnoreCase(msg.get(0).toString())) {
                    if (conn != null) {
                        ((RedisStandaloneConnection)conn.actual()).fail(ErrorType.create("SWITCH-MASTER Received +switch-master message from Redis Sentinel."));
                    } else {
                        LOG.warn((Object)"Received +switch-master message from Redis Sentinel.");
                    }
                }
            });
            sentinel.send(Request.cmd(Command.SUBSCRIBE).arg("+switch-master"), (Handler<AsyncResult<Response>>)((Handler)send -> {
                if (send.failed()) {
                    promise.fail(send.cause());
                } else {
                    promise.complete((Object)new RedisSentinelConnection(conn, sentinel));
                }
            }));
            sentinel.exceptionHandler(t -> {
                if (conn != null) {
                    ((RedisStandaloneConnection)conn.actual()).fail((Throwable)t);
                } else {
                    LOG.error((Object)"Unhandled exception in Sentinel PUBSUB", t);
                }
            });
        }));
    }

    private static class Pair<L, R> {
        final L left;
        final R right;

        Pair(L left, R right) {
            this.left = left;
            this.right = right;
        }
    }
}

