/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl;

import io.zeebe.client.ZeebeClient;
import io.zeebe.client.ZeebeClientBuilder;
import io.zeebe.client.ZeebeClientConfiguration;
import io.zeebe.client.impl.ZeebeClientImpl;
import java.time.Duration;
import java.util.Properties;

public class ZeebeClientBuilderImpl
implements ZeebeClientBuilder,
ZeebeClientConfiguration {
    private String brokerContactPoint = "0.0.0.0:26500";
    private int jobWorkerMaxJobsActive = 32;
    private int numJobWorkerExecutionThreads = 1;
    private String defaultJobWorkerName = "default";
    private Duration defaultJobTimeout = Duration.ofMinutes(5L);
    private Duration defaultJobPollInterval = Duration.ofMillis(100L);
    private Duration defaultMessageTimeToLive = Duration.ofHours(1L);
    private Duration defaultRequestTimeout = Duration.ofSeconds(20L);

    @Override
    public String getBrokerContactPoint() {
        return this.brokerContactPoint;
    }

    @Override
    public ZeebeClientBuilder brokerContactPoint(String contactPoint) {
        this.brokerContactPoint = contactPoint;
        return this;
    }

    @Override
    public int getDefaultJobWorkerMaxJobsActive() {
        return this.jobWorkerMaxJobsActive;
    }

    @Override
    public ZeebeClientBuilder defaultJobWorkerMaxJobsActive(int maxJobsActive) {
        this.jobWorkerMaxJobsActive = maxJobsActive;
        return this;
    }

    @Override
    public int getNumJobWorkerExecutionThreads() {
        return this.numJobWorkerExecutionThreads;
    }

    @Override
    public ZeebeClientBuilder numJobWorkerExecutionThreads(int numSubscriptionThreads) {
        this.numJobWorkerExecutionThreads = numSubscriptionThreads;
        return this;
    }

    @Override
    public String getDefaultJobWorkerName() {
        return this.defaultJobWorkerName;
    }

    @Override
    public Duration getDefaultJobTimeout() {
        return this.defaultJobTimeout;
    }

    @Override
    public Duration getDefaultJobPollInterval() {
        return this.defaultJobPollInterval;
    }

    @Override
    public ZeebeClientBuilder defaultJobWorkerName(String workerName) {
        this.defaultJobWorkerName = workerName;
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultJobTimeout(Duration timeout) {
        this.defaultJobTimeout = timeout;
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultJobPollInterval(Duration pollInterval) {
        this.defaultJobPollInterval = pollInterval;
        return this;
    }

    @Override
    public ZeebeClientBuilder defaultMessageTimeToLive(Duration timeToLive) {
        this.defaultMessageTimeToLive = timeToLive;
        return this;
    }

    @Override
    public Duration getDefaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    @Override
    public ZeebeClientBuilder defaultRequestTimeout(Duration requestTimeout) {
        this.defaultRequestTimeout = requestTimeout;
        return this;
    }

    @Override
    public Duration getDefaultRequestTimeout() {
        return this.defaultRequestTimeout;
    }

    @Override
    public ZeebeClient build() {
        return new ZeebeClientImpl(this);
    }

    @Override
    public ZeebeClientBuilder withProperties(Properties properties) {
        if (properties.containsKey("zeebe.client.broker.contactPoint")) {
            this.brokerContactPoint(properties.getProperty("zeebe.client.broker.contactPoint"));
        }
        if (properties.containsKey("zeebe.client.worker.threads")) {
            this.numJobWorkerExecutionThreads(Integer.parseInt(properties.getProperty("zeebe.client.worker.threads")));
        }
        if (properties.containsKey("zeebe.client.worker.maxJobsActive")) {
            this.defaultJobWorkerMaxJobsActive(Integer.parseInt(properties.getProperty("zeebe.client.worker.maxJobsActive")));
        }
        if (properties.containsKey("zeebe.client.job.worker")) {
            this.defaultJobWorkerName(properties.getProperty("zeebe.client.job.worker"));
        }
        if (properties.containsKey("zeebe.client.job.timeout")) {
            this.defaultJobTimeout(Duration.ofMillis(Integer.parseInt(properties.getProperty("zeebe.client.job.timeout"))));
        }
        if (properties.containsKey("zeebe.client.job.pollinterval")) {
            this.defaultJobTimeout(Duration.ofMillis(Integer.parseInt(properties.getProperty("zeebe.client.job.pollinterval"))));
        }
        if (properties.containsKey("zeebe.client.message.timeToLive")) {
            this.defaultMessageTimeToLive(Duration.ofMillis(Long.parseLong(properties.getProperty("zeebe.client.message.timeToLive"))));
        }
        if (properties.containsKey("zeebe.client.requestTimeout")) {
            this.defaultRequestTimeout(Duration.ofMillis(Long.parseLong(properties.getProperty("zeebe.client.requestTimeout"))));
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ZeebeClientBuilderImpl.appendProperty(sb, "brokerContactPoint", this.brokerContactPoint);
        ZeebeClientBuilderImpl.appendProperty(sb, "jobWorkerMaxJobsActive", this.jobWorkerMaxJobsActive);
        ZeebeClientBuilderImpl.appendProperty(sb, "numJobWorkerExecutionThreads", this.numJobWorkerExecutionThreads);
        ZeebeClientBuilderImpl.appendProperty(sb, "defaultJobWorkerName", this.defaultJobWorkerName);
        ZeebeClientBuilderImpl.appendProperty(sb, "defaultJobTimeout", this.defaultJobTimeout);
        ZeebeClientBuilderImpl.appendProperty(sb, "defaultJobPollInterval", this.defaultJobPollInterval);
        ZeebeClientBuilderImpl.appendProperty(sb, "defaultMessageTimeToLive", this.defaultMessageTimeToLive);
        ZeebeClientBuilderImpl.appendProperty(sb, "defaultRequestTimeout", this.defaultRequestTimeout);
        return sb.toString();
    }

    private static void appendProperty(StringBuilder sb, String propertyName, Object value) {
        sb.append(propertyName + ": " + value + "\n");
    }
}

