/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.zeebe.client.ZeebeClient;
import io.zeebe.client.ZeebeClientConfiguration;
import io.zeebe.client.api.command.ActivateJobsCommandStep1;
import io.zeebe.client.api.command.CancelWorkflowInstanceCommandStep1;
import io.zeebe.client.api.command.ClientException;
import io.zeebe.client.api.command.CompleteJobCommandStep1;
import io.zeebe.client.api.command.CreateWorkflowInstanceCommandStep1;
import io.zeebe.client.api.command.DeployWorkflowCommandStep1;
import io.zeebe.client.api.command.FailJobCommandStep1;
import io.zeebe.client.api.command.PublishMessageCommandStep1;
import io.zeebe.client.api.command.ResolveIncidentCommandStep1;
import io.zeebe.client.api.command.SetVariablesCommandStep1;
import io.zeebe.client.api.command.TopologyRequestStep1;
import io.zeebe.client.api.command.UpdateRetriesJobCommandStep1;
import io.zeebe.client.api.worker.JobClient;
import io.zeebe.client.api.worker.JobWorkerBuilderStep1;
import io.zeebe.client.impl.ZeebeObjectMapper;
import io.zeebe.client.impl.command.ActivateJobsCommandImpl;
import io.zeebe.client.impl.command.CancelWorkflowInstanceCommandImpl;
import io.zeebe.client.impl.command.CreateWorkflowInstanceCommandImpl;
import io.zeebe.client.impl.command.DeployWorkflowCommandImpl;
import io.zeebe.client.impl.command.JobUpdateRetriesCommandImpl;
import io.zeebe.client.impl.command.PublishMessageCommandImpl;
import io.zeebe.client.impl.command.ResolveIncidentCommandImpl;
import io.zeebe.client.impl.command.SetVariablesCommandImpl;
import io.zeebe.client.impl.command.TopologyRequestImpl;
import io.zeebe.client.impl.worker.JobClientImpl;
import io.zeebe.client.impl.worker.JobWorkerBuilderImpl;
import io.zeebe.gateway.protocol.GatewayGrpc;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ZeebeClientImpl
implements ZeebeClient {
    private final ZeebeClientConfiguration config;
    private final ZeebeObjectMapper objectMapper;
    private final GatewayGrpc.GatewayStub asyncStub;
    private final ManagedChannel channel;
    private final ScheduledExecutorService executorService;
    private final List<Closeable> closeables = new CopyOnWriteArrayList<Closeable>();
    private final JobClient jobClient;

    public ZeebeClientImpl(ZeebeClientConfiguration configuration) {
        this(configuration, ZeebeClientImpl.buildChannel(configuration));
    }

    public ZeebeClientImpl(ZeebeClientConfiguration configuration, ManagedChannel channel) {
        this(configuration, channel, ZeebeClientImpl.buildGatewayStub(channel));
    }

    public ZeebeClientImpl(ZeebeClientConfiguration configuration, ManagedChannel channel, GatewayGrpc.GatewayStub gatewayStub) {
        this(configuration, channel, gatewayStub, ZeebeClientImpl.buildExecutorService(configuration));
    }

    public ZeebeClientImpl(ZeebeClientConfiguration config, ManagedChannel channel, GatewayGrpc.GatewayStub gatewayStub, ScheduledExecutorService executorService) {
        this.config = config;
        this.objectMapper = new ZeebeObjectMapper();
        this.channel = channel;
        this.asyncStub = gatewayStub;
        this.executorService = executorService;
        this.jobClient = this.newJobClient();
    }

    public static ManagedChannel buildChannel(ZeebeClientConfiguration config) {
        URI address;
        try {
            address = new URI("zb://" + config.getBrokerContactPoint());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to parse broker contact point", e);
        }
        return ManagedChannelBuilder.forAddress((String)address.getHost(), (int)address.getPort()).usePlaintext().build();
    }

    public static GatewayGrpc.GatewayStub buildGatewayStub(ManagedChannel channel) {
        return GatewayGrpc.newStub((Channel)channel);
    }

    private static ScheduledExecutorService buildExecutorService(ZeebeClientConfiguration configuration) {
        int threadCount = configuration.getNumJobWorkerExecutionThreads();
        return Executors.newScheduledThreadPool(threadCount);
    }

    @Override
    public TopologyRequestStep1 newTopologyRequest() {
        return new TopologyRequestImpl(this.asyncStub, this.config.getDefaultRequestTimeout());
    }

    @Override
    public ZeebeClientConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public void close() {
        this.closeables.forEach(c -> {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(15L, TimeUnit.SECONDS)) {
                throw new ClientException("Timed out awaiting termination of job worker executor after 15 seconds");
            }
        }
        catch (InterruptedException e) {
            throw new ClientException("Unexpected interrupted awaiting termination of job worker executor", e);
        }
        this.channel.shutdown();
        try {
            if (!this.channel.awaitTermination(15L, TimeUnit.SECONDS)) {
                throw new ClientException("Timed out awaiting termination of in-flight request channel after 15 seconds");
            }
        }
        catch (InterruptedException e) {
            throw new ClientException("Unexpectedly interrupted awaiting termination of in-flight request channel", e);
        }
    }

    @Override
    public DeployWorkflowCommandStep1 newDeployCommand() {
        return new DeployWorkflowCommandImpl(this.asyncStub, this.config.getDefaultRequestTimeout());
    }

    @Override
    public CreateWorkflowInstanceCommandStep1 newCreateInstanceCommand() {
        return new CreateWorkflowInstanceCommandImpl(this.asyncStub, this.objectMapper, this.config.getDefaultRequestTimeout());
    }

    @Override
    public CancelWorkflowInstanceCommandStep1 newCancelInstanceCommand(long workflowInstanceKey) {
        return new CancelWorkflowInstanceCommandImpl(this.asyncStub, workflowInstanceKey, this.config.getDefaultRequestTimeout());
    }

    @Override
    public SetVariablesCommandStep1 newSetVariablesCommand(long elementInstanceKey) {
        return new SetVariablesCommandImpl(this.asyncStub, this.objectMapper, elementInstanceKey, this.config.getDefaultRequestTimeout());
    }

    @Override
    public PublishMessageCommandStep1 newPublishMessageCommand() {
        return new PublishMessageCommandImpl(this.asyncStub, this.config, this.objectMapper);
    }

    @Override
    public ResolveIncidentCommandStep1 newResolveIncidentCommand(long incidentKey) {
        return new ResolveIncidentCommandImpl(this.asyncStub, incidentKey, this.config.getDefaultRequestTimeout());
    }

    @Override
    public UpdateRetriesJobCommandStep1 newUpdateRetriesCommand(long jobKey) {
        return new JobUpdateRetriesCommandImpl(this.asyncStub, jobKey, this.config.getDefaultRequestTimeout());
    }

    @Override
    public JobWorkerBuilderStep1 newWorker() {
        return new JobWorkerBuilderImpl(this.config, this.asyncStub, this.jobClient, this.objectMapper, this.executorService, this.closeables);
    }

    private JobClient newJobClient() {
        return new JobClientImpl(this.asyncStub, this.config, this.objectMapper);
    }

    @Override
    public ActivateJobsCommandStep1 newActivateJobsCommand() {
        return new ActivateJobsCommandImpl(this.asyncStub, this.config, this.objectMapper);
    }

    @Override
    public CompleteJobCommandStep1 newCompleteCommand(long jobKey) {
        return this.jobClient.newCompleteCommand(jobKey);
    }

    @Override
    public FailJobCommandStep1 newFailCommand(long jobKey) {
        return this.jobClient.newFailCommand(jobKey);
    }
}

