/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.zeebe.client.api.command.InternalClientException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class ZeebeObjectMapper
extends ObjectMapper {
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};
    private static final TypeReference<Map<String, String>> STRING_MAP_TYPE_REFERENCE = new TypeReference<Map<String, String>>(){};

    public <T> T fromJson(String json, Class<T> typeClass) {
        try {
            return (T)this.readValue(json, typeClass);
        }
        catch (IOException e) {
            throw new InternalClientException(String.format("Failed to deserialize json '%s' to class '%s'", json, typeClass), e);
        }
    }

    public Map<String, Object> fromJsonAsMap(String json) {
        try {
            return (Map)this.readValue(json, MAP_TYPE_REFERENCE);
        }
        catch (IOException e) {
            throw new InternalClientException(String.format("Failed to deserialize json '%s' to 'Map<String, Object>'", json), e);
        }
    }

    public Map<String, String> fromJsonAsStringMap(String json) {
        try {
            return (Map)this.readValue(json, STRING_MAP_TYPE_REFERENCE);
        }
        catch (IOException e) {
            throw new InternalClientException(String.format("Failed to deserialize json '%s' to 'Map<String, String>'", json), e);
        }
    }

    public String toJson(Object value) {
        try {
            return this.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new InternalClientException(String.format("Failed to serialize object '%s' to json", value), e);
        }
    }

    public String validateJson(String propertyName, String jsonInput) {
        try {
            return this.readTree(jsonInput).toString();
        }
        catch (IOException e) {
            throw new InternalClientException(String.format("Failed to validate json input '%s' for property '%s'", jsonInput, propertyName), e);
        }
    }

    public String validateJson(String propertyName, InputStream jsonInput) {
        try {
            return this.readTree(jsonInput).toString();
        }
        catch (IOException e) {
            throw new InternalClientException(String.format("Failed to validate json input stream for property '%s'", propertyName), e);
        }
    }
}

