/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.command;

import io.zeebe.client.api.ZeebeFuture;
import io.zeebe.client.api.command.CancelWorkflowInstanceCommandStep1;
import io.zeebe.client.api.command.FinalCommandStep;
import io.zeebe.client.impl.ZeebeClientFutureImpl;
import io.zeebe.gateway.protocol.GatewayGrpc;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class CancelWorkflowInstanceCommandImpl
implements CancelWorkflowInstanceCommandStep1 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.CancelWorkflowInstanceRequest.Builder builder;
    private Duration requestTimeout;

    public CancelWorkflowInstanceCommandImpl(GatewayGrpc.GatewayStub asyncStub, long workflowInstanceKey, Duration requestTimeout) {
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.builder = GatewayOuterClass.CancelWorkflowInstanceRequest.newBuilder();
        this.builder.setWorkflowInstanceKey(workflowInstanceKey);
    }

    @Override
    public FinalCommandStep<Void> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<Void> send() {
        GatewayOuterClass.CancelWorkflowInstanceRequest request = this.builder.build();
        ZeebeClientFutureImpl future = new ZeebeClientFutureImpl();
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).cancelWorkflowInstance(request, future);
        return future;
    }
}

