/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.command;

import io.zeebe.client.api.ZeebeFuture;
import io.zeebe.client.api.command.FinalCommandStep;
import io.zeebe.client.api.command.ResolveIncidentCommandStep1;
import io.zeebe.client.impl.ZeebeClientFutureImpl;
import io.zeebe.gateway.protocol.GatewayGrpc;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class ResolveIncidentCommandImpl
implements ResolveIncidentCommandStep1 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.ResolveIncidentRequest.Builder builder;
    private Duration requestTimeout;

    public ResolveIncidentCommandImpl(GatewayGrpc.GatewayStub asyncStub, long incidentKey, Duration requestTimeout) {
        this.asyncStub = asyncStub;
        this.builder = GatewayOuterClass.ResolveIncidentRequest.newBuilder().setIncidentKey(incidentKey);
        this.requestTimeout = requestTimeout;
    }

    @Override
    public FinalCommandStep<Void> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<Void> send() {
        GatewayOuterClass.ResolveIncidentRequest request = this.builder.build();
        ZeebeClientFutureImpl future = new ZeebeClientFutureImpl();
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).resolveIncident(request, future);
        return future;
    }
}

