/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.response;

import io.zeebe.client.api.response.BrokerInfo;
import io.zeebe.client.api.response.PartitionBrokerRole;
import io.zeebe.client.api.response.PartitionInfo;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BrokerInfoImpl
implements BrokerInfo {
    private final int nodeId;
    private final String host;
    private final int port;
    private final List<PartitionInfo> partitions;

    public BrokerInfoImpl(GatewayOuterClass.BrokerInfo broker) {
        this.nodeId = broker.getNodeId();
        this.host = broker.getHost();
        this.port = broker.getPort();
        this.partitions = new ArrayList<PartitionInfo>();
        for (GatewayOuterClass.Partition partition : broker.getPartitionsList()) {
            this.partitions.add(new PartitionInfoImpl(partition));
        }
    }

    @Override
    public int getNodeId() {
        return this.nodeId;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getAddress() {
        return String.format("%s:%d", this.host, this.port);
    }

    @Override
    public List<PartitionInfo> getPartitions() {
        return this.partitions;
    }

    public String toString() {
        return "BrokerInfoImpl{nodeId=" + this.nodeId + ", host='" + this.host + '\'' + ", port=" + this.port + ", partitions=" + this.partitions + '}';
    }

    class PartitionInfoImpl
    implements PartitionInfo {
        private final int partitionId;
        private final PartitionBrokerRole role;

        PartitionInfoImpl(GatewayOuterClass.Partition partition) {
            this.partitionId = partition.getPartitionId();
            if (partition.getRole() == GatewayOuterClass.Partition.PartitionBrokerRole.LEADER) {
                this.role = PartitionBrokerRole.LEADER;
            } else if (partition.getRole() == GatewayOuterClass.Partition.PartitionBrokerRole.FOLLOWER) {
                this.role = PartitionBrokerRole.FOLLOWER;
            } else {
                throw new RuntimeException(String.format("Unexpected partition broker role %s, should be one of %s", partition.getRole(), Arrays.toString((Object[])PartitionBrokerRole.values())));
            }
        }

        @Override
        public int getPartitionId() {
            return this.partitionId;
        }

        @Override
        public PartitionBrokerRole getRole() {
            return this.role;
        }

        @Override
        public boolean isLeader() {
            return this.role == PartitionBrokerRole.LEADER;
        }

        public String toString() {
            return "PartitionInfoImpl{partitionId=" + this.partitionId + ", role=" + (Object)((Object)this.role) + '}';
        }
    }
}

