/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.response;

import io.zeebe.client.api.response.Workflow;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.Objects;

public class WorkflowImpl
implements Workflow {
    protected final long workflowKey;
    protected final String bpmnProcessId;
    protected final int version;
    protected final String resourceName;

    public WorkflowImpl(GatewayOuterClass.WorkflowMetadata workflow) {
        this(workflow.getWorkflowKey(), workflow.getBpmnProcessId(), workflow.getVersion(), workflow.getResourceName());
    }

    public WorkflowImpl(long workflowKey, String bpmnProcessId, int version, String resourceName) {
        this.workflowKey = workflowKey;
        this.bpmnProcessId = bpmnProcessId;
        this.version = version;
        this.resourceName = resourceName;
    }

    @Override
    public long getWorkflowKey() {
        return this.workflowKey;
    }

    @Override
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowImpl workflow = (WorkflowImpl)o;
        return this.workflowKey == workflow.workflowKey && this.version == workflow.version && Objects.equals(this.bpmnProcessId, workflow.bpmnProcessId) && Objects.equals(this.resourceName, workflow.resourceName);
    }

    public int hashCode() {
        return Objects.hash(this.workflowKey, this.bpmnProcessId, this.version, this.resourceName);
    }

    public String toString() {
        return "WorkflowImpl{workflowKey=" + this.workflowKey + ", bpmnProcessId='" + this.bpmnProcessId + '\'' + ", version=" + this.version + ", resourceName='" + this.resourceName + '\'' + '}';
    }
}

