/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.client.impl.worker;

import io.zeebe.client.ZeebeClientConfiguration;
import io.zeebe.client.api.worker.JobClient;
import io.zeebe.client.api.worker.JobHandler;
import io.zeebe.client.api.worker.JobWorker;
import io.zeebe.client.api.worker.JobWorkerBuilderStep1;
import io.zeebe.client.impl.ZeebeObjectMapper;
import io.zeebe.client.impl.command.ArgumentUtil;
import io.zeebe.client.impl.worker.JobPoller;
import io.zeebe.client.impl.worker.JobRunnableFactory;
import io.zeebe.client.impl.worker.JobWorkerImpl;
import io.zeebe.gateway.protocol.GatewayGrpc;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import java.io.Closeable;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public class JobWorkerBuilderImpl
implements JobWorkerBuilderStep1,
JobWorkerBuilderStep1.JobWorkerBuilderStep2,
JobWorkerBuilderStep1.JobWorkerBuilderStep3 {
    private final GatewayGrpc.GatewayStub gatewayStub;
    private final JobClient jobClient;
    private final ZeebeObjectMapper objectMapper;
    private final ScheduledExecutorService executorService;
    private final List<Closeable> closeables;
    private String jobType;
    private JobHandler handler;
    private long timeout;
    private String workerName;
    private int maxJobsActive;
    private Duration pollInterval;
    private Duration requestTimeout;
    private List<String> fetchVariables;

    public JobWorkerBuilderImpl(ZeebeClientConfiguration configuration, GatewayGrpc.GatewayStub gatewayStub, JobClient jobClient, ZeebeObjectMapper objectMapper, ScheduledExecutorService executorService, List<Closeable> closeables) {
        this.gatewayStub = gatewayStub;
        this.jobClient = jobClient;
        this.objectMapper = objectMapper;
        this.executorService = executorService;
        this.closeables = closeables;
        this.timeout = configuration.getDefaultJobTimeout().toMillis();
        this.workerName = configuration.getDefaultJobWorkerName();
        this.maxJobsActive = configuration.getDefaultJobWorkerMaxJobsActive();
        this.pollInterval = configuration.getDefaultJobPollInterval();
        this.requestTimeout = configuration.getDefaultRequestTimeout();
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep2 jobType(String type) {
        this.jobType = type;
        return this;
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 handler(JobHandler handler) {
        this.handler = handler;
        return this;
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 timeout(Duration timeout) {
        return this.timeout(timeout.toMillis());
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 name(String workerName) {
        this.workerName = workerName;
        return this;
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 maxJobsActive(int maxJobsActive) {
        this.maxJobsActive = maxJobsActive;
        return this;
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 pollInterval(Duration pollInterval) {
        this.pollInterval = pollInterval;
        return this;
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 fetchVariables(List<String> fetchVariables) {
        this.fetchVariables = fetchVariables;
        return this;
    }

    @Override
    public JobWorkerBuilderStep1.JobWorkerBuilderStep3 fetchVariables(String ... fetchVariables) {
        return this.fetchVariables(Arrays.asList(fetchVariables));
    }

    @Override
    public JobWorker open() {
        ArgumentUtil.ensureNotNullNorEmpty("jobType", this.jobType);
        ArgumentUtil.ensureNotNull("jobHandler", this.handler);
        ArgumentUtil.ensureGreaterThan("timeout", this.timeout, 0L);
        ArgumentUtil.ensureNotNullNorEmpty("workerName", this.workerName);
        ArgumentUtil.ensureGreaterThan("maxJobsActive", this.maxJobsActive, 0L);
        GatewayOuterClass.ActivateJobsRequest.Builder requestBuilder = GatewayOuterClass.ActivateJobsRequest.newBuilder().setType(this.jobType).setTimeout(this.timeout).setWorker(this.workerName).setMaxJobsToActivate(this.maxJobsActive);
        if (this.fetchVariables != null) {
            requestBuilder.addAllFetchVariable(this.fetchVariables);
        }
        JobRunnableFactory jobRunnableFactory = new JobRunnableFactory(this.jobClient, this.handler);
        JobPoller jobPoller = new JobPoller(this.gatewayStub, requestBuilder, this.objectMapper, this.requestTimeout);
        JobWorkerImpl jobWorker = new JobWorkerImpl(this.maxJobsActive, this.executorService, this.pollInterval, jobRunnableFactory, jobPoller);
        this.closeables.add(jobWorker);
        return jobWorker;
    }
}

