/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.charting.rows;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import kg.apc.charting.AbstractGraphPanelChartElement;
import kg.apc.charting.AbstractGraphRow;
import kg.apc.charting.elements.GraphPanelChartSumElement;

public class GraphRowSumValues
extends AbstractGraphRow
implements Iterator<Map.Entry<Long, AbstractGraphPanelChartElement>> {
    private ConcurrentSkipListMap<Long, GraphPanelChartSumElement> values = new ConcurrentSkipListMap();
    private double rollingSum;
    private Iterator<Map.Entry<Long, GraphPanelChartSumElement>> iterator;
    private boolean isRollingSum = true;
    private boolean excludeOutOfRangeValues = false;
    private static final long excludeCount = 15L;
    private int countX = 0;

    @Override
    public void setExcludeOutOfRangeValues(boolean excludeOutOfRangeValues) {
        this.excludeOutOfRangeValues = excludeOutOfRangeValues;
    }

    public GraphRowSumValues() {
    }

    public GraphRowSumValues(boolean doRollingSum) {
        this.isRollingSum = doRollingSum;
    }

    @Override
    public void add(long xVal, double yVal) {
        if (this.values.containsKey(xVal)) {
            GraphPanelChartSumElement el = this.values.get(xVal);
            el.add(yVal);
            yVal = el.getValue();
        } else {
            GraphPanelChartSumElement el = new GraphPanelChartSumElement(yVal);
            this.values.put(xVal, el);
            ++this.countX;
        }
        super.add(xVal, yVal);
    }

    @Override
    public Iterator<Map.Entry<Long, AbstractGraphPanelChartElement>> iterator() {
        this.rollingSum = 0.0;
        this.iterator = this.values.entrySet().iterator();
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Map.Entry<Long, AbstractGraphPanelChartElement> next() {
        Map.Entry<Long, GraphPanelChartSumElement> entry = this.iterator.next();
        GraphPanelChartSumElement ret = entry.getValue();
        ExactEntry retValue = null;
        if (this.isRollingSum) {
            this.rollingSum += ret.getValue();
            retValue = new ExactEntry(entry.getKey(), new GraphPanelChartSumElement(this.rollingSum));
        } else {
            retValue = new ExactEntry(entry.getKey(), new GraphPanelChartSumElement(ret.getValue()));
        }
        return retValue;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int size() {
        return this.countX;
    }

    @Override
    public long getMaxX() {
        if (!this.excludeOutOfRangeValues) {
            return super.getMaxX();
        }
        long retMax = 0L;
        Iterator iter = this.values.keySet().iterator();
        if (iter.hasNext()) {
            retMax = (Long)iter.next();
        }
        long excludeValue = (long)this.getGranulationValue() * 15L;
        while (iter.hasNext()) {
            long value = (Long)iter.next();
            if (value <= retMax || value - retMax >= excludeValue) continue;
            retMax = value;
        }
        return retMax;
    }

    @Override
    public AbstractGraphPanelChartElement getElement(long value) {
        if (!this.isRollingSum) {
            return this.values.get(value);
        }
        if (!this.values.containsKey(value)) {
            return null;
        }
        long sum = 0L;
        Iterator<Map.Entry<Long, GraphPanelChartSumElement>> it = this.values.entrySet().iterator();
        boolean valueReached = false;
        while (it.hasNext() && !valueReached) {
            Map.Entry<Long, GraphPanelChartSumElement> entry = it.next();
            sum = (long)((double)sum + entry.getValue().getValue());
            if (entry.getKey() != value) continue;
            valueReached = true;
        }
        return new GraphPanelChartSumElement(sum);
    }

    private static class ExactEntry
    implements Map.Entry<Long, AbstractGraphPanelChartElement> {
        private long key;
        private final AbstractGraphPanelChartElement value;

        public ExactEntry(long aKey, AbstractGraphPanelChartElement aValue) {
            this.key = aKey;
            this.value = aValue;
        }

        @Override
        public Long getKey() {
            return this.key;
        }

        @Override
        public AbstractGraphPanelChartElement getValue() {
            return this.value;
        }

        @Override
        public AbstractGraphPanelChartElement setValue(AbstractGraphPanelChartElement value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

