/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.samplers;

import java.io.IOException;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.spi.AbstractSelectableChannel;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.Interruptible;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class AbstractIPSampler
extends AbstractSampler
implements Serializable,
Cloneable,
Interruptible {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String RECV_BUFFER_LEN_PROPERTY = "kg.apc.jmeter.samplers.ReceiveBufferSize";
    public static final String RESULT_DATA_LIMIT = "kg.apc.jmeter.samplers.ResultDataLimit";
    public static final String HOSTNAME = "hostname";
    public static final String PORT = "port";
    public static final String TIMEOUT = "timeout";
    public static final String DATA = "data";
    public static final String CRLF = "\r\n";
    public static final String EMPTY = "";
    public static final String RC200 = "200";
    public static final String RC500 = "500";
    protected static final int recvBufSize = JMeterUtils.getPropDefault((String)"kg.apc.jmeter.samplers.ReceiveBufferSize", (int)4096);
    private transient ByteBuffer recvBuf;
    protected final int recvDataLimit = JMeterUtils.getPropDefault((String)"kg.apc.jmeter.samplers.ResultDataLimit", (int)Integer.MAX_VALUE);

    public AbstractIPSampler() {
        if (this.recvDataLimit < Integer.MAX_VALUE) {
            log.info("Limiting result data to " + this.recvDataLimit);
        }
    }

    public ByteBuffer getRecvBuf() {
        if (this.recvBuf == null) {
            this.recvBuf = ByteBuffer.allocateDirect(recvBufSize);
        }
        return this.recvBuf;
    }

    public final String getHostName() {
        return this.getPropertyAsString(HOSTNAME);
    }

    public String getPort() {
        return this.getPropertyAsString(PORT);
    }

    public String getRequestData() {
        return this.getPropertyAsString(DATA);
    }

    public String getTimeout() {
        return this.getPropertyAsString(TIMEOUT);
    }

    public void setHostName(String text) {
        this.setProperty(HOSTNAME, text);
    }

    public void setPort(String text) {
        this.setProperty(PORT, text);
    }

    public void setRequestData(String text) {
        this.setProperty(DATA, text);
    }

    public void setTimeout(String text) {
        this.setProperty(TIMEOUT, text);
    }

    protected int getPortAsInt() {
        try {
            return Integer.parseInt(this.getPort());
        }
        catch (NumberFormatException ex) {
            log.error("Wrong port: " + this.getTimeout(), (Throwable)ex);
            return 0;
        }
    }

    protected int getTimeoutAsInt() {
        try {
            return Integer.parseInt(this.getTimeout());
        }
        catch (NumberFormatException ex) {
            log.error("Wrong timeout: " + this.getTimeout(), (Throwable)ex);
            return 0;
        }
    }

    public SampleResult sample(Entry entry) {
        SampleResult res = new SampleResult();
        res.setSampleLabel(this.getName());
        res.setSamplerData(this.getRequestData());
        res.sampleStart();
        res.setDataType("text");
        res.setSuccessful(true);
        res.setResponseCode(RC200);
        try {
            res.setResponseData(this.processIO(res));
        }
        catch (Exception ex) {
            if (!(ex instanceof SocketTimeoutException)) {
                log.error(this.getHostName(), (Throwable)ex);
            }
            res.sampleEnd();
            res.setSuccessful(false);
            res.setResponseCode(RC500);
            res.setResponseMessage(ex.toString());
            res.setResponseData((ex.toString() + CRLF + JMeterPluginsUtils.getStackTrace(ex)).getBytes());
        }
        return res;
    }

    protected abstract AbstractSelectableChannel getChannel() throws IOException;

    protected abstract byte[] processIO(SampleResult var1) throws Exception;
}

