/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.samplers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Scanner;
import java.util.regex.Pattern;
import kg.apc.io.SocketChannelWithTimeouts;
import kg.apc.jmeter.samplers.AbstractIPSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class HTTPRawSampler
extends AbstractIPSampler {
    private static final String FILE_NAME = "fileName";
    private static final String KEEPALIVE = "keepalive";
    private static final String PARSE = "parse";
    private static final String RNpattern = "\\r\\n";
    private static final String SPACE = " ";
    protected static final Logger log = LoggingManager.getLoggerForClass();
    private static final Pattern anyContent = Pattern.compile(".+", 32);
    private SocketChannel savedSock;
    private static final int fileSendingChunk = JMeterUtils.getPropDefault((String)"kg.apc.jmeter.samplers.FileReadChunkSize", (int)4096);

    public HTTPRawSampler() {
        log.debug("File reading chunk size: " + fileSendingChunk);
    }

    @Override
    public SampleResult sample(Entry entry) {
        SampleResult res = super.sample(entry);
        if (this.isParseResult()) {
            this.parseResponse(res);
        }
        return res;
    }

    protected byte[] readResponse(SocketChannel channel, SampleResult res) throws IOException {
        ByteArrayOutputStream response = new ByteArrayOutputStream();
        ByteBuffer recvBuf = this.getRecvBuf();
        recvBuf.clear();
        boolean firstPack = true;
        int responseSize = 0;
        if (log.isDebugEnabled()) {
            log.debug("Start reading response");
        }
        try {
            int cnt;
            while ((cnt = channel.read(recvBuf)) != -1) {
                responseSize += cnt;
                if (firstPack) {
                    res.latencyEnd();
                    firstPack = false;
                }
                recvBuf.flip();
                if (response.size() <= this.recvDataLimit) {
                    byte[] bytes = new byte[cnt];
                    recvBuf.get(bytes);
                    response.write(bytes);
                }
                recvBuf.clear();
            }
            if (response.size() < 1) {
                log.warn("Read no bytes from socket, seems it was closed. Let it be so.");
                channel.close();
            }
        }
        catch (IOException ex) {
            channel.close();
            throw ex;
        }
        if (log.isDebugEnabled()) {
            log.debug("Done reading response");
        }
        res.sampleEnd();
        if (!this.isUseKeepAlive()) {
            channel.close();
        }
        res.setBytes(responseSize);
        return response.toByteArray();
    }

    private void parseResponse(SampleResult res) {
        String line;
        int e;
        Scanner scanner = new Scanner(res.getResponseDataAsString());
        scanner.useDelimiter(RNpattern);
        if (!scanner.hasNextLine()) {
            return;
        }
        String httpStatus = scanner.nextLine();
        int s = httpStatus.indexOf(SPACE);
        if (s < (e = httpStatus.indexOf(SPACE, s + 1))) {
            String rc = httpStatus.substring(s, e).trim();
            try {
                int rcInt = Integer.parseInt(rc);
                if (rcInt < 100 || rcInt > 599) {
                    return;
                }
                res.setResponseCode(rc);
                res.setResponseMessage(httpStatus.substring(e).trim());
            }
            catch (NumberFormatException ex) {
                return;
            }
        } else {
            return;
        }
        if (!scanner.hasNextLine()) {
            return;
        }
        int n = 1;
        StringBuilder headers = new StringBuilder();
        while (scanner.hasNextLine() && !(line = scanner.nextLine()).isEmpty()) {
            headers.append(line).append("\r\n");
            ++n;
        }
        res.setResponseHeaders(headers.toString());
        if (scanner.hasNext()) {
            res.setResponseData(scanner.next(anyContent).getBytes());
        } else {
            res.setResponseData("".getBytes());
        }
    }

    @Override
    protected byte[] processIO(SampleResult res) throws Exception {
        SocketChannel sock = this.getSocketChannel();
        if (!this.getRequestData().isEmpty()) {
            ByteBuffer sendBuf = ByteBuffer.wrap(this.getRequestData().getBytes());
            sock.write(sendBuf);
        }
        this.sendFile(this.getFileToSend(), sock);
        if (log.isDebugEnabled()) {
            log.debug("Sent request");
        }
        return this.readResponse(sock, res);
    }

    protected SocketChannel getSocketChannel() throws IOException {
        int port;
        if (this.isUseKeepAlive() && this.savedSock != null) {
            return this.savedSock;
        }
        try {
            port = Integer.parseInt(this.getPort());
        }
        catch (NumberFormatException ex) {
            log.warn("Wrong port number: " + this.getPort() + ", defaulting to 80", (Throwable)ex);
            port = 80;
        }
        InetSocketAddress address = new InetSocketAddress(this.getHostName(), port);
        this.savedSock = (SocketChannel)this.getChannel();
        this.savedSock.connect(address);
        return this.savedSock;
    }

    public boolean isUseKeepAlive() {
        return this.getPropertyAsBoolean(KEEPALIVE);
    }

    public void setUseKeepAlive(boolean selected) {
        this.setProperty(KEEPALIVE, selected);
    }

    @Override
    protected AbstractSelectableChannel getChannel() throws IOException {
        int t = this.getTimeoutAsInt();
        if (t > 0) {
            SocketChannelWithTimeouts res = (SocketChannelWithTimeouts)SocketChannelWithTimeouts.open();
            res.setConnectTimeout(t);
            res.setReadTimeout(t);
            return res;
        }
        return SocketChannel.open();
    }

    public boolean isParseResult() {
        return this.getPropertyAsBoolean(PARSE);
    }

    public void setParseResult(boolean selected) {
        this.setProperty(PARSE, selected);
    }

    public String getFileToSend() {
        return this.getPropertyAsString(FILE_NAME);
    }

    public void setFileToSend(String text) {
        this.setProperty(FILE_NAME, text);
    }

    public boolean interrupt() {
        if (this.savedSock != null && this.savedSock.isOpen()) {
            try {
                this.savedSock.close();
            }
            catch (IOException ex) {
                log.warn("Exception while interrupting channel: ", (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    private void sendFile(String filename, SocketChannel sock) throws IOException {
        if (filename.isEmpty()) {
            return;
        }
        FileInputStream is = new FileInputStream(new File(filename));
        FileChannel source = is.getChannel();
        ByteBuffer sendBuf = ByteBuffer.allocateDirect(fileSendingChunk);
        while (source.read(sendBuf) > 0) {
            sendBuf.flip();
            if (log.isDebugEnabled()) {
                log.debug("Sending " + sendBuf);
            }
            sock.write(sendBuf);
            sendBuf.rewind();
        }
        source.close();
    }
}

