/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import java.awt.Color;
import kg.apc.charting.AbstractGraphRow;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.graphs.AbstractGraphPanelVisualizer;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.samplers.SampleResult;

public class ResponseTimesDistributionGui
extends AbstractGraphPanelVisualizer {
    public ResponseTimesDistributionGui() {
        this.setGranulation(100);
        this.graphPanel.getGraphObject().setxAxisLabel("Response times in ms");
        this.graphPanel.getGraphObject().setYAxisLabel("Number of responses");
    }

    private void addThreadGroupRecord(String threadGroupName, long time, int granulation) {
        String aggLabel = "Overall Response Times";
        AbstractGraphRow row = (AbstractGraphRow)this.model.get(threadGroupName);
        AbstractGraphRow rowAgg = (AbstractGraphRow)this.modelAggregate.get(aggLabel);
        if (row == null) {
            row = this.getNewRow(this.model, 4, threadGroupName, 0, true, false, false, true, false);
        }
        if (rowAgg == null) {
            rowAgg = this.getNewRow(this.modelAggregate, 4, aggLabel, 0, true, false, false, true, Color.RED, false);
        }
        row.add(time, 1.0);
        row.setGranulationValue(granulation);
        rowAgg.add(time, 1.0);
        rowAgg.setGranulationValue(granulation);
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("Response Times Distribution");
    }

    public void add(SampleResult res) {
        if (!this.isSampleIncluded(res)) {
            return;
        }
        int granulation = this.getGranulation();
        this.addThreadGroupRecord(res.getSampleLabel(), res.getTime() - res.getTime() % (long)granulation, granulation);
        this.updateGui(null);
    }

    @Override
    protected JSettingsPanel createSettingsPanel() {
        return new JSettingsPanel(this, 3235);
    }

    @Override
    public String getWikiPage() {
        return "RespTimesDistribution";
    }
}

