/*
 * Decompiled with CFR 0.152.
 */
package nccloud.open.api.auto.token.cur.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;
import nccloud.open.api.auto.token.cur.utils.Base64Util;

public class CompressUtil {
    private static int buffSize = 1024;

    public static String deflaterCompress(String source) throws Exception {
        String value = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Deflater compressor = new Deflater();
        try {
            byte[] input = source.getBytes("UTF-8");
            compressor.setLevel(-1);
            compressor.setInput(input);
            compressor.finish();
            byte[] buf = new byte[buffSize];
            while (!compressor.finished()) {
                int count = compressor.deflate(buf);
                bos.write(buf, 0, count);
            }
            value = Base64Util.encryptBASE64(bos.toByteArray());
        }
        finally {
            bos.close();
            compressor.end();
        }
        return value;
    }

    public static String deflaterDecompress(String source) throws Exception {
        String value = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Inflater decompressor = new Inflater();
        try {
            try {
                byte[] input = Base64Util.decryptBASE64(source);
                decompressor.setInput(input);
                byte[] buf = new byte[buffSize];
                while (!decompressor.finished()) {
                    int count = decompressor.inflate(buf);
                    bos.write(buf, 0, count);
                }
                value = new String(bos.toByteArray(), "UTF-8");
            }
            catch (IOException | DataFormatException e) {
                throw new Exception("\ufffd\ufffd\u0479\ufffd\ucce3 ", e);
            }
        }
        finally {
            bos.close();
            decompressor.end();
        }
        return value;
    }

    public static String gzipCompress(String source) throws Exception {
        String value = null;
        try (ByteArrayOutputStream out = null;){
            try {
                out = new ByteArrayOutputStream();
                GZIPOutputStream gzip = new GZIPOutputStream(out);
                byte[] input = source.getBytes("UTF-8");
                gzip.write(input);
                gzip.close();
                value = Base64Util.encryptBASE64(out.toByteArray());
            }
            catch (IOException e) {
                throw new Exception("gzip\u0479\ufffd\ufffd\ufffd\ucce3 ", e);
            }
        }
        return value;
    }

    public static String gzipDecompress(String source) throws Exception {
        String value = null;
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        try {
            try {
                int n;
                byte[] input = Base64Util.decryptBASE64(source);
                out = new ByteArrayOutputStream();
                in = new ByteArrayInputStream(input);
                GZIPInputStream ungzip = new GZIPInputStream(in);
                byte[] buffer = new byte[buffSize];
                while ((n = ungzip.read(buffer)) >= 0) {
                    out.write(buffer, 0, n);
                }
                ungzip.close();
                value = new String(out.toByteArray(), "UTF-8");
            }
            catch (IOException e) {
                throw new Exception("gzip\ufffd\ufffd\u0479\ufffd\ucce3 ", e);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return value;
    }
}

