/*
 * Copyright (c) 2019-2029, Dreamlu 卢春梦 (596392912@qq.com & www.dreamlu.net).
 * <p>
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE 3.0;
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.gnu.org/licenses/lgpl.html
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.dreamlu.mica.core.utils;

/**
 * char 常量池
 *
 * @author L.cm
 */
public interface CharPool {
	// @formatter:off
	char UPPER_A          = 'A';
	char LOWER_A          = 'a';
	char UPPER_Z          = 'Z';
	char LOWER_Z          = 'z';
	char DOT              = '.';
	char AT               = '@';
	char LEFT_BRACE       = '{';
	char RIGHT_BRACE      = '}';
	char LEFT_BRACKET     = '(';
	char RIGHT_BRACKET    = ')';
	char DASH             = '-';
	char PERCENT          = '%';
	char PIPE             = '|';
	char PLUS             = '+';
	char QUESTION_MARK    = '?';
	char EXCLAMATION_MARK = '!';
	char EQUALS           = '=';
	char AMPERSAND        = '&';
	char ASTERISK         = '*';
	char STAR             = ASTERISK;
	char BACK_SLASH       = '\\';
	char COLON            = ':';
	char COMMA            = ',';
	char DOLLAR           = '$';
	char SLASH            = '/';
	char HASH             = '#';
	char HAT              = '^';
	char LEFT_CHEV        = '<';
	char NEWLINE          = '\n';
	char N                = 'n';
	char Y                = 'y';
	char QUOTE            = '\"';
	char RETURN           = '\r';
	char TAB              = '\t';
	char RIGHT_CHEV       = '>';
	char SEMICOLON        = ';';
	char SINGLE_QUOTE     = '\'';
	char BACKTICK         = '`';
	char SPACE            = ' ';
	char TILDA            = '~';
	char LEFT_SQ_BRACKET  = '[';
	char RIGHT_SQ_BRACKET = ']';
	char UNDERSCORE       = '_';
	char ONE              = '1';
	char ZERO             = '0';
	// @formatter:on
}
