/*
 * Decompiled with CFR 0.152.
 */
package net.kingborn.test;

import java.io.File;
import java.io.IOException;
import java.nio.charset.CodingErrorAction;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.kingborn.core.util.JsonKit;
import net.kingborn.test.BaseUrl;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.util.EntityUtils;

public class HttpUtils {
    private static PoolingHttpClientConnectionManager connManager = null;
    private static CloseableHttpClient httpClient = null;
    public static final int CONNECT_TIMEOUT = 180000;
    public static final int SOCKET_TIMEOUT = 180000;
    public static final long REQUEST_TIMEOUT = 180000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doHttpPost(String url) {
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(180000).setConnectTimeout(180000).setExpectContinueEnabled(false).build();
        httpPost.setConfig(requestConfig);
        String result = null;
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpPost);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            httpPost.releaseConnection();
        }
        return result;
    }

    public static String doHttpPost(BaseUrl baseUrl) {
        return HttpUtils.doHttpPost(baseUrl, null);
    }

    public static String doHttpPost(BaseUrl baseUrl, Map<String, Object> cookieMap) {
        return HttpUtils.doHttpPost(baseUrl, null, null, cookieMap);
    }

    public static String doHttpPost(BaseUrl baseUrl, Map<String, Object> getParamsMap, Map<String, Object> postParamsMap, Map<String, Object> cookieMap) {
        return HttpUtils.doHttpPost(baseUrl, getParamsMap, postParamsMap, cookieMap, null);
    }

    public static String doHttpPost(BaseUrl baseUrl, Map<String, Object> getParamsMap, Map<String, Object> postParamsMap, Map<String, Object> cookieMap, Map<String, String> filePathMap) {
        return HttpUtils.doHttpPost(baseUrl, getParamsMap, null, postParamsMap, cookieMap, filePathMap);
    }

    public static String doHttpPost(BaseUrl baseUrl, Map<String, Object> postParamsMap, Map<String, String> headerMap) {
        return HttpUtils.doHttpPost(baseUrl, null, headerMap, postParamsMap, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doHttpPost(BaseUrl baseUrl, Map<String, Object> getParamsMap, Map<String, String> headerMap, Map<String, Object> postParamsMap, Map<String, Object> cookieMap, Map<String, String> filePathMap) {
        HttpPost httpPost = new HttpPost(HttpUtils.createWholeUrl(baseUrl.toString(), getParamsMap));
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(180000).setConnectTimeout(180000).setExpectContinueEnabled(false).build();
        httpPost.setConfig(requestConfig);
        System.out.println(HttpUtils.createWholeUrl(baseUrl.toString(), getParamsMap));
        if (headerMap != null && headerMap.size() > 0) {
            Set<String> headerKeySet = headerMap.keySet();
            for (String string : headerKeySet) {
                httpPost.setHeader(string, headerMap.get(string));
            }
        }
        if (filePathMap != null && filePathMap.size() > 0) {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            Set<String> filePathKeySet = filePathMap.keySet();
            for (String string : filePathKeySet) {
                File file = new File(filePathMap.get(string));
                builder.addBinaryBody(string, file);
            }
            if (postParamsMap != null && postParamsMap.keySet().size() > 0) {
                Set<String> set = postParamsMap.keySet();
                for (String string : set) {
                    builder.addTextBody(string, postParamsMap.get(string).toString(), ContentType.create((String)"application/x-www-form-urlencoded", (String)"UTF-8"));
                }
            }
            HttpEntity httpEntity = builder.build();
            httpPost.setEntity(httpEntity);
        } else {
            StringEntity stringEntity = new StringEntity(JsonKit.toJson(postParamsMap), "UTF-8");
            stringEntity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)stringEntity);
        }
        String result = null;
        CloseableHttpResponse response = null;
        try {
            Header[] headerArray;
            BasicCookieStore basicCookieStore = new BasicCookieStore();
            if (cookieMap != null && cookieMap.size() > 0) {
                Set<String> set = cookieMap.keySet();
                for (String key : set) {
                    String value = cookieMap.get(key).toString();
                    BasicClientCookie cookie = new BasicClientCookie(key, value);
                    cookie.setVersion(0);
                    cookie.setDomain(baseUrl.getDomain());
                    cookie.setAttribute("port", baseUrl.getPort() + "");
                    cookie.setPath(baseUrl.getPath());
                    basicCookieStore.addCookie((Cookie)cookie);
                }
            }
            httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setDefaultCookieStore((CookieStore)basicCookieStore).build();
            response = httpClient.execute((HttpUriRequest)httpPost);
            System.out.println(response.getStatusLine());
            for (Header header : headerArray = response.getAllHeaders()) {
                System.out.println(header.getName() + ": " + header.getValue());
            }
            System.out.println("Content-Type: " + response.getHeaders("Content-Type"));
            result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            System.out.println("===================cookie start=======================");
            List list = basicCookieStore.getCookies();
            for (int index = 0; index < list.size(); ++index) {
                System.out.println("cookies: " + list.get(index));
            }
            System.out.println("===================cookie end=========================");
        }
        catch (ClientProtocolException clientProtocolException) {
            clientProtocolException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            httpPost.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doHttpGet(BaseUrl baseUrl, Map<String, Object> getParamsMap, Map<String, String> headerMap, Map<String, Object> cookieMap) {
        HttpGet httpGet = new HttpGet(HttpUtils.createWholeUrl(baseUrl.toString(), getParamsMap));
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(180000).setConnectTimeout(180000).setExpectContinueEnabled(false).build();
        httpGet.setConfig(requestConfig);
        System.out.println(HttpUtils.createWholeUrl(baseUrl.toString(), getParamsMap));
        if (headerMap != null && headerMap.size() > 0) {
            Set<String> headerKeySet = headerMap.keySet();
            for (String headerKey : headerKeySet) {
                httpGet.setHeader(headerKey, headerMap.get(headerKey));
            }
        }
        String result = null;
        CloseableHttpResponse response = null;
        try {
            if (cookieMap != null && cookieMap.size() > 0) {
                BasicCookieStore cookieStore = new BasicCookieStore();
                Set<String> keySet = cookieMap.keySet();
                for (String key : keySet) {
                    String value = cookieMap.get(key).toString();
                    BasicClientCookie cookie = new BasicClientCookie(key, value);
                    cookie.setVersion(0);
                    cookie.setDomain(baseUrl.getDomain());
                    cookie.setAttribute("port", baseUrl.getPort() + "");
                    cookie.setPath(baseUrl.getPath());
                    cookieStore.addCookie((Cookie)cookie);
                }
                httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setDefaultCookieStore((CookieStore)cookieStore).build();
            }
            response = httpClient.execute((HttpUriRequest)httpGet);
            System.out.println(response.getStatusLine());
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            httpGet.releaseConnection();
        }
        return result;
    }

    public static String createWholeUrl(String baseUrl, Map<String, Object> getParamsMap) {
        if (getParamsMap == null) {
            return baseUrl;
        }
        String getParams = HttpUtils.createParamsStr(getParamsMap);
        getParams = getParams == null || "".equals(getParams) ? "" : "?" + getParams;
        return baseUrl + getParams;
    }

    public static String createParamsStr(Map<String, Object> getParamsMap) {
        if (getParamsMap == null) {
            return "";
        }
        Set<String> keySet = getParamsMap.keySet();
        if (keySet.size() == 0) {
            return "";
        }
        String paramsStr = "";
        for (String key : keySet) {
            paramsStr = paramsStr + key + "=" + getParamsMap.get(key) + "&";
        }
        paramsStr = paramsStr.substring(0, paramsStr.length() - 1);
        return paramsStr;
    }

    static {
        try {
            SSLContext sslContext = SSLContexts.custom().useTLS().build();
            sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }}, null);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext)).build();
            connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
            SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).build();
            connManager.setDefaultSocketConfig(socketConfig);
            ConnectionConfig connectionConfig = ConnectionConfig.custom().setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).setCharset(Consts.UTF_8).build();
            connManager.setDefaultConnectionConfig(connectionConfig);
            connManager.setMaxTotal(200);
            connManager.setDefaultMaxPerRoute(20);
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}

