/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.action;

import cn.hutool.system.oshi.CpuInfo;
import cn.hutool.system.oshi.OshiUtil;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import javax.sql.DataSource;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Tag(name="\u540e\u7aef-\u7cfb\u7edf\u4fe1\u606f")
@Controller
@RequestMapping(value={"/${ms.manager.path}/basic/system"})
public class SystemAction
extends BaseAction {
    @Autowired
    private DataSource dataSource;

    @Hidden
    @Operation(summary="\u52a0\u8f7dUI\u7684\u8868\u5355\u9875\u9762")
    @GetMapping(value={"/index"})
    public String index(HttpServletRequest request) {
        return "/basic/system/index";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u4fe1\u606f")
    @PostMapping(value={"/info"})
    @ResponseBody
    public ResultData info(HttpServletResponse response, HttpServletRequest request) {
        Properties props = System.getProperties();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CPU\u6838\u6570", String.valueOf(Runtime.getRuntime().availableProcessors()));
        map.put("\u865a\u62df\u673a\u5185\u5b58\u603b\u91cf", String.valueOf(Runtime.getRuntime().totalMemory() / 0x100000L));
        map.put("\u865a\u62df\u673a\u7a7a\u95f2\u5185\u5b58\u91cf", String.valueOf(Runtime.getRuntime().freeMemory() / 0x100000L));
        map.put("\u865a\u62df\u673a\u4f7f\u7528\u6700\u5927\u5185\u5b58\u91cf", String.valueOf(Runtime.getRuntime().maxMemory() / 0x100000L));
        map.put("\u7cfb\u7edf\u540d\u79f0", props.getProperty("os.name"));
        map.put("\u7cfb\u7edf\u6784\u67b6", props.getProperty("os.arch"));
        map.put("\u7cfb\u7edf\u7248\u672c", props.getProperty("os.version"));
        map.put("Java\u7248\u672c", props.getProperty("java.version"));
        map.put("Java\u5b89\u88c5\u8def\u5f84", props.getProperty("java.home"));
        CpuInfo cpu = OshiUtil.getCpuInfo();
        map.put("cpu\u4fe1\u606f", cpu.getCpuModel() + cpu.getCpuNum());
        map.put("\u5185\u5b58\u603b\u91cf", OshiUtil.getMemory().getTotal() / 0x100000L);
        map.put("\u5185\u5b58\u53ef\u7528", OshiUtil.getMemory().getAvailable() / 0x100000L);
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            DatabaseMetaData mtdt = connection.getMetaData();
            map.put("\u6570\u636e\u5e93\u94fe\u63a5", mtdt.getURL());
            map.put("\u6570\u636e\u5e93", mtdt.getDatabaseProductName());
            map.put("\u6570\u636e\u5e93\u7248\u672c", mtdt.getDatabaseProductVersion());
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        ServletContext context = request.getServletContext();
        map.put("web\u5bb9\u5668", context.getServerInfo());
        map.put("\u53d1\u5e03\u8def\u5f84", context.getRealPath(""));
        return ResultData.build().success(map);
    }
}

