/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.biz.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.mingsoft.base.biz.impl.BaseBizImpl;
import net.mingsoft.base.dao.IBaseDao;
import net.mingsoft.basic.biz.IManagerBiz;
import net.mingsoft.basic.dao.IManagerDao;
import net.mingsoft.basic.dao.IRoleDao;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.entity.RoleEntity;
import net.mingsoft.basic.util.SpringUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="managerBiz")
@Transactional
public class ManagerBizImpl
extends BaseBizImpl<IManagerDao, ManagerEntity>
implements IManagerBiz {
    private IManagerDao managerDao;

    public IManagerDao getManagerDao() {
        return this.managerDao;
    }

    @Autowired
    public void setManagerDao(IManagerDao managerDao) {
        this.managerDao = managerDao;
    }

    public IBaseDao getDao() {
        return this.managerDao;
    }

    @Override
    public void updateUserPasswordByUserName(ManagerEntity manager) {
        this.managerDao.updateUserPasswordByUserName(manager);
    }

    @Override
    public List<ManagerEntity> queryAllChildManager(int managerId) {
        return this.managerDao.queryAllChildManager(managerId);
    }

    @Override
    public List<ManagerEntity> queryAllManager(List<ManagerEntity> managerList) {
        IRoleDao roleDao = SpringUtil.getBean(IRoleDao.class);
        List roleList = roleDao.selectList((Wrapper)new QueryWrapper());
        for (ManagerEntity manager : managerList) {
            StringBuilder roleNames = new StringBuilder();
            String[] roleIds = manager.getRoleIds().split(",");
            ArrayList allRoleName = new ArrayList();
            for (String roleId : roleIds) {
                List roleNameList = roleList.stream().filter(roleEntity -> roleEntity.getId().equals(roleId)).map(RoleEntity::getRoleName).collect(Collectors.toList());
                allRoleName.addAll(roleNameList);
            }
            roleNames.append(StringUtils.join(allRoleName, (String)","));
            manager.setRoleName(roleNames.toString());
        }
        return managerList;
    }

    @Override
    public ManagerEntity getManagerByManagerName(String managerName) {
        ManagerEntity managerEntity = new ManagerEntity();
        managerEntity.setManagerName(managerName);
        return (ManagerEntity)((Object)this.managerDao.getByEntity(managerEntity));
    }
}

