/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.constant.e.BaseSessionEnum;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.filter.DateValueFilter;
import net.mingsoft.base.filter.DoubleValueFilter;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.constant.e.SessionConstEnum;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.biz.IContentModelBiz;
import net.mingsoft.mdiy.biz.IContentModelFieldBiz;
import net.mingsoft.mdiy.biz.IFormBiz;
import net.mingsoft.mdiy.entity.ContentModelEntity;
import net.mingsoft.mdiy.entity.FormEntity;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u81ea\u5b9a\u4e49\u6a21\u578b\u63a5\u53e3")
@Controller
@RequestMapping(value={"/${ms.manager.path}/mdiy/contentModel/"})
public class ContentModelAction
extends BaseAction {
    private static final String TABLE_NAME_PREFIX = "mdiy_";
    private static final String TABLE_NAME_SPLIT = "_";
    @Autowired
    private IContentModelBiz contentModelBiz;
    @Autowired
    IFormBiz formBiz;
    @Autowired
    private IContentModelFieldBiz fieldBiz;

    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/mdiy/content_model/index";
    }

    @GetMapping(value={"/form"})
    public String form(@ModelAttribute ContentModelEntity contentModel, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (contentModel.getCmId() > 0) {
            BaseEntity contentModelEntity = this.contentModelBiz.getEntity(contentModel.getCmId());
            model.addAttribute("contentModelEntity", (Object)contentModelEntity);
        }
        return "/mdiy/content_model/form";
    }

    @ApiOperation(value="\u67e5\u8be2\u81ea\u5b9a\u4e49\u6a21\u578b\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="cmTipsName", value="\u8868\u540d\u63d0\u793a\u6587\u5b57", required=false, paramType="query"), @ApiImplicitParam(name="cmTableName", value="\u8868\u5355\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="cmModelId", value="\u81ea\u5b9a\u4e49\u6a21\u578b\u6a21\u5757\u7f16\u53f7", required=false, paramType="query")})
    @GetMapping(value={"/list"})
    @ResponseBody
    public void list(@ModelAttribute @ApiIgnore ContentModelEntity contentModel, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        contentModel.setAppId(BasicUtil.getAppId());
        BasicUtil.startPage();
        List contentModelList = this.contentModelBiz.query((BaseEntity)contentModel);
        this.outJson(response, JSONArray.toJSONString((Object)new EUListBean(contentModelList, (int)BasicUtil.endPage((List)contentModelList).getTotal()), (SerializeFilter[])new SerializeFilter[]{new DoubleValueFilter(), new DateValueFilter()}));
    }

    @ApiOperation(value="\u83b7\u53d6\u81ea\u5b9a\u4e49\u6a21\u578b\u63a5\u53e3")
    @ApiImplicitParam(name="cmId", value="\u81ea\u5b9a\u4e49\u6a21\u578b\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @ResponseBody
    public void get(@ModelAttribute @ApiIgnore ContentModelEntity contentModel, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (contentModel.getCmId() <= 0) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("cm.id")}));
            return;
        }
        ContentModelEntity _contentModel = (ContentModelEntity)this.contentModelBiz.getEntity(contentModel.getCmId());
        this.outJson(response, JSONObject.toJSON((Object)((Object)_contentModel)));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u6a21\u578b\u7f16\u53f7")
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:content:del"})
    public void delete(@RequestBody List<ContentModelEntity> contentModels, HttpServletResponse response, HttpServletRequest request) {
        for (int i = 0; i < contentModels.size(); ++i) {
            if (contentModels.size() <= 0 || contentModels.get(i) == null) continue;
            ContentModelEntity cme = (ContentModelEntity)this.contentModelBiz.getEntity(contentModels.get(i).getCmId());
            if (cme != null) {
                this.contentModelBiz.dropTable(cme.getCmTableName());
            }
            this.contentModelBiz.deleteEntity(contentModels.get(i).getCmId());
        }
        this.outJson(response, true);
    }

    @ApiOperation(value="\u4fdd\u5b58\u5185\u5bb9\u6a21\u578b\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="cmTipsName", value="\u8868\u540d\u63d0\u793a\u6587\u5b57", required=true, paramType="query"), @ApiImplicitParam(name="cmTableName", value="\u8868\u5355\u540d\u79f0", required=true, paramType="query")})
    @PostMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:content:save"})
    public void save(@ModelAttribute @ApiIgnore ContentModelEntity contentModel, HttpServletRequest request, HttpServletResponse response) {
        contentModel.setAppId(BasicUtil.getAppId());
        if (!StringUtil.checkLength((String)contentModel.getCmTipsName(), (int)1, (int)30)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("content.model.tips.name"), "1", "30"}));
            return;
        }
        if (!StringUtil.checkLength((String)contentModel.getCmTableName(), (int)1, (int)10)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("content.model.table.name"), "1", "10"}));
            return;
        }
        ManagerEntity managerSession = (ManagerEntity)BasicUtil.getSession((BaseSessionEnum)SessionConstEnum.MANAGER_SESSION);
        int managerId = managerSession.getManagerId();
        ContentModelEntity contentModelEntity = new ContentModelEntity();
        contentModelEntity.setCmTableName(TABLE_NAME_PREFIX + contentModel.getCmTableName() + TABLE_NAME_SPLIT + managerId);
        if (this.contentModelBiz.getEntity((BaseEntity)contentModelEntity) != null) {
            this.outJson(response, null, false, this.getResString("err.exist", new String[]{this.getResString("content.model")}));
            return;
        }
        contentModel.setCmTableName(TABLE_NAME_PREFIX + contentModel.getCmTableName() + TABLE_NAME_SPLIT + managerId);
        this.contentModelBiz.createTable(contentModel.getCmTableName(), null);
        this.contentModelBiz.saveEntity((BaseEntity)contentModel);
        int cmId = ((ContentModelEntity)((Object)this.contentModelBiz.getEntity((BaseEntity)contentModelEntity))).getCmId();
        this.outJson(response, null, true, String.valueOf(cmId));
    }

    @ApiOperation(value="\u66f4\u65b0\u5185\u5bb9\u6a21\u578b\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="cmId", value="\u81ea\u5b9a\u4e49\u6a21\u578b\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="cmTipsName", value="\u8868\u540d\u63d0\u793a\u6587\u5b57", required=true, paramType="query")})
    @PostMapping(value={"/update"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:content:update"})
    public void update(@ModelAttribute @ApiIgnore ContentModelEntity contentModel, HttpServletRequest request, HttpServletResponse response) {
        if (!StringUtil.checkLength((String)contentModel.getCmTipsName(), (int)1, (int)30)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("content.model.tips.name"), "1", "30"}));
            return;
        }
        this.contentModelBiz.updateEntity((BaseEntity)contentModel);
        this.outJson(response, null, true, null);
    }

    @ApiOperation(value=" \u5224\u65ad\u81ea\u5b9a\u4e49\u6a21\u578b\u8868\u540d\u662f\u5426\u91cd\u590d\u63a5\u53e3")
    @ApiImplicitParam(name="cmTableName", value="\u8868\u5355\u540d\u79f0", required=true, paramType="path")
    @GetMapping(value={"/{cmTableName}/checkcmTableNameExist"})
    @ResponseBody
    public boolean checkcmTableNameExist(@PathVariable @ApiIgnore String cmTableName, HttpServletRequest request) {
        ManagerEntity managerSession = (ManagerEntity)BasicUtil.getSession((BaseSessionEnum)SessionConstEnum.MANAGER_SESSION);
        int managerId = managerSession.getManagerId();
        cmTableName = TABLE_NAME_PREFIX + cmTableName + TABLE_NAME_SPLIT + managerId;
        ContentModelEntity contentModel = new ContentModelEntity();
        contentModel.setCmTableName(cmTableName);
        FormEntity formEntity = new FormEntity();
        formEntity.setFormTableName(cmTableName);
        return this.contentModelBiz.getEntity((BaseEntity)contentModel) != null || this.formBiz.getEntity((BaseEntity)formEntity) != null;
    }
}

