/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action;

import com.alibaba.fastjson.serializer.SerializeFilter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.constant.e.TableEnum;
import net.mingsoft.base.filter.DateValueFilter;
import net.mingsoft.base.filter.DoubleValueFilter;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.biz.IColumnBiz;
import net.mingsoft.basic.entity.ColumnEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.biz.IContentModelBiz;
import net.mingsoft.mdiy.biz.IContentModelFieldBiz;
import net.mingsoft.mdiy.constant.e.ContentModelFieldEnum;
import net.mingsoft.mdiy.entity.ContentModelEntity;
import net.mingsoft.mdiy.entity.ContentModelFieldEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u81ea\u5b9a\u4e49\u6a21\u578b\u5b57\u6bb5\u63a5\u53e3")
@Controller
@RequestMapping(value={"/${ms.manager.path}/mdiy/contentModel/contentModelField"})
public class ContentModelFieldAction
extends BaseAction {
    @Autowired
    private IContentModelFieldBiz contentModelFieldBiz;
    @Autowired
    private IContentModelBiz contentModelBiz;
    @Autowired
    private IColumnBiz columnBiz;

    @GetMapping(value={"/{contentModelId}/index"})
    public String index(@PathVariable int contentModelId, HttpServletRequest request, @ApiIgnore ModelMap model, HttpServletResponse response) {
        model.addAttribute("contentModelId", (Object)contentModelId);
        model.put((Object)"fieldTypes", (Object)ContentModelFieldEnum.toMap());
        return "/mdiy/content_model/index_filed";
    }

    @ApiOperation(value="\u8868\u5355\u5217\u8868")
    @ApiImplicitParam(name="contentModelId", value="\u7ed1\u5b9a\u5185\u5bb9\u6a21\u578b\u8868ID", required=true, paramType="path")
    @GetMapping(value={"/{contentModelId}/list"})
    public void list(@PathVariable @ApiIgnore int contentModelId, HttpServletRequest request, @ApiIgnore ModelMap model, HttpServletResponse response) {
        BasicUtil.startPage();
        List<ContentModelFieldEntity> contentModelFieldList = this.contentModelFieldBiz.queryListByCmid(contentModelId);
        model.put((Object)"fieldTypes", (Object)ContentModelFieldEnum.toMap());
        model.put((Object)"contentModelId", (Object)contentModelId);
        model.addAttribute("contentModelFieldList", contentModelFieldList);
        this.outJson(response, JSONArray.toJSONString((Object)new EUListBean(contentModelFieldList, (int)BasicUtil.endPage(contentModelFieldList).getTotal()), (SerializeFilter[])new SerializeFilter[]{new DoubleValueFilter(), new DateValueFilter()}));
    }

    @ApiOperation(value="\u4fdd\u5b58\u5185\u5bb9\u6a21\u578b\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldCmid", value="\u7ed1\u5b9a\u5185\u5bb9\u6a21\u578b\u8868ID", required=true, paramType="query"), @ApiImplicitParam(name="fieldTipsName", value="\u5b57\u6bb5\u63d0\u793a\u6587\u5b57", required=true, paramType="query"), @ApiImplicitParam(name="fieldFieldName", value="\u5b57\u6bb5\u540d\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="fieldType", value="\u5b57\u6bb5\u7c7b\u578b(1\u5355\u884c\u6587\u672c 2\u591a\u884c\u6587\u672c 3=HTML\u6587\u672c4=\u6574\u6570\u7c7b\u578b 5=\u5c0f\u6570\u7c7b\u578b6=\u65f6\u95f4\u7c7b\u578b7=\u56fe\u72478=\u9644\u4ef6\u7c7b\u578b9=\u4f7f\u7528option\u4e0b\u62c9\u684610=\u4f7f\u7528radio\u9009\u9879\u536111=Checkbox\u591a\u9009\u6846)", required=true, paramType="query")})
    @PostMapping(value={"/save"})
    @ResponseBody
    public void save(@ModelAttribute @ApiIgnore ContentModelFieldEntity field, HttpServletRequest request, HttpServletResponse response) {
        ContentModelEntity contentModel = (ContentModelEntity)this.contentModelBiz.getEntity(field.getFieldCmid());
        if (!StringUtil.checkLength((String)field.getFieldTipsName(), (int)1, (int)30)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("content.model.field.tips.name"), "1", "30"}));
            return;
        }
        if (!StringUtil.checkLength((String)field.getFieldFieldName(), (int)1, (int)30)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("content.model.field.column.ame"), "1", "30"}));
            return;
        }
        if (this.contentModelFieldBiz.getEntityByCmId(field.getFieldCmid(), field.getFieldFieldName()) != null) {
            this.outJson(response, null, false, this.getResString("err.exist", new String[]{this.getResString("content.model.field")}));
            return;
        }
        this.contentModelFieldBiz.saveEntity(field);
        HashMap<String, String> fileds = new HashMap<String, String>();
        fileds.put("fieldName", field.getFieldFieldName());
        fileds.put("fieldType", field.getFieldColumnType());
        fileds.put("default", field.getFieldDefault());
        this.contentModelFieldBiz.alterTable(contentModel.getCmTableName(), fileds, TableEnum.ALTER_ADD);
        this.outJson(response, null, true, null);
    }

    @ApiOperation(value="\u5220\u9664\u8868\u5355\u7c7b\u578b\u63a5\u53e3")
    @PostMapping(value={"/delete"})
    @ResponseBody
    public void delete(@RequestBody List<ContentModelFieldEntity> contentModelFields, HttpServletRequest request, HttpServletResponse response) {
        for (int i = 0; i < contentModelFields.size(); ++i) {
            ContentModelFieldEntity field = (ContentModelFieldEntity)this.contentModelFieldBiz.getEntity(contentModelFields.get(i).getFieldId());
            this.contentModelFieldBiz.deleteEntity(contentModelFields.get(i).getFieldId());
            ContentModelEntity contentModel = (ContentModelEntity)this.contentModelBiz.getEntity(field.getFieldCmid());
            if (contentModel == null) continue;
            HashMap<String, String> fields = new HashMap<String, String>();
            fields.put("fieldName", field.getFieldFieldName());
            this.contentModelFieldBiz.alterTable(contentModel.getCmTableName(), fields, TableEnum.ALTER_DROP);
        }
        this.outJson(response, true);
    }

    @ApiOperation(value="\u7f16\u8f91\u8868\u5355\u63a5\u53e3")
    @ApiImplicitParam(name="filedId", value="\u81ea\u589e\u957fID", required=true, paramType="path")
    @GetMapping(value={"/{filedId}/edit"})
    @ResponseBody
    public void edit(@PathVariable @ApiIgnore int filedId, HttpServletResponse response) {
        ContentModelFieldEntity contentModelField = (ContentModelFieldEntity)this.contentModelFieldBiz.getEntity(filedId);
        this.outJson(response, contentModelField);
    }

    @ApiOperation(value="\u66f4\u65b0\u5185\u5bb9\u6a21\u578b\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fieldCmid", value="\u7ed1\u5b9a\u5185\u5bb9\u6a21\u578b\u8868ID", required=true, paramType="query"), @ApiImplicitParam(name="fieldTipsName", value="\u5b57\u6bb5\u63d0\u793a\u6587\u5b57", required=false, paramType="query"), @ApiImplicitParam(name="fieldFieldName", value="\u5b57\u6bb5\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="fieldType", value="\u5b57\u6bb5\u7c7b\u578b(1\u5355\u884c\u6587\u672c 2\u591a\u884c\u6587\u672c 3=HTML\u6587\u672c4=\u6574\u6570\u7c7b\u578b 5=\u5c0f\u6570\u7c7b\u578b6=\u65f6\u95f4\u7c7b\u578b7=\u56fe\u72478=\u9644\u4ef6\u7c7b\u578b9=\u4f7f\u7528option\u4e0b\u62c9\u684610=\u4f7f\u7528radio\u9009\u9879\u536111=Checkbox\u591a\u9009\u6846)", required=false, paramType="query"), @ApiImplicitParam(name="fieldCmid", value="\u5b57\u6bb5\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="fieldLength", value="\u5b57\u6bb5\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="fieldDefault", value="\u5b57\u6bb5\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="fieldIsNull", value="\u5b57\u6bb5\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="fieldIsSearch", value="\u5b57\u6bb5\u540d\u79f0", required=false, paramType="query")})
    @PostMapping(value={"/update"})
    @ResponseBody
    public void update(@ModelAttribute @ApiIgnore ContentModelFieldEntity contentModelFieldEntity, HttpServletRequest request, HttpServletResponse response) {
        this.contentModelFieldBiz.updateEntity(contentModelFieldEntity);
        this.outJson(response, true);
    }

    @ApiOperation(value="\u8fd4\u56decms\u6a21\u5757\u7684\u81ea\u5b9a\u4e49\u6a21\u578b\u7684html\u9875\u9762\uff08\u9002\u7528\u4e8ecms\u6a21\u5757\uff09")
    @ApiImplicitParam(name="columnId", value="\u680f\u76ee\u7f16\u53f7", required=true, paramType="path")
    @GetMapping(value={"/{columnId}/queryField"})
    public String queryField(@PathVariable @ApiIgnore int columnId, @ApiIgnore ModelMap model, HttpServletRequest request) {
        ColumnEntity column = (ColumnEntity)this.columnBiz.getEntity(columnId);
        if (column != null) {
            ContentModelEntity contentModel;
            int fieldCmid = column.getColumnContentModelId();
            List<ContentModelFieldEntity> listField = this.contentModelFieldBiz.queryListByCmid(fieldCmid);
            int basicId = BasicUtil.getInt((String)"basicId");
            if (basicId != 0 && (contentModel = (ContentModelEntity)this.contentModelBiz.getEntity(fieldCmid)) != null) {
                ArrayList<String> listFieldName = new ArrayList<String>();
                for (int i = 0; i < listField.size(); ++i) {
                    ContentModelFieldEntity field = listField.get(i);
                    listFieldName.add(field.getFieldFieldName());
                }
                HashMap<String, Integer> where = new HashMap<String, Integer>();
                where.put("basicId", basicId);
                List fieldLists = this.contentModelFieldBiz.queryBySQL(contentModel.getCmTableName(), listFieldName, where);
                if (fieldLists != null && fieldLists.size() > 0) {
                    Map filedValue = (Map)fieldLists.get(0);
                    model.addAttribute("filedValue", (Object)filedValue);
                }
            }
            model.addAttribute("listField", listField);
            model.addAttribute("appId", (Object)BasicUtil.getAppId());
        }
        return "/mdiy/content_model/content_model_field";
    }
}

