/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action;

import com.alibaba.fastjson.serializer.SerializeFilter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.filter.DateValueFilter;
import net.mingsoft.base.filter.DoubleValueFilter;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.biz.IDictBiz;
import net.mingsoft.mdiy.entity.DictEntity;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u5b57\u5178\u8868\u7ba1\u7406\u63a5\u53e3")
@Controller
@RequestMapping(value={"/${ms.manager.path}/mdiy/dict"})
public class DictAction
extends BaseAction {
    @Autowired
    private IDictBiz dictBiz;

    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/mdiy/dict/index";
    }

    @ApiOperation(value="\u67e5\u8be2\u5b57\u5178\u8868\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dictValue", value="\u6570\u636e\u503c", required=false, paramType="query"), @ApiImplicitParam(name="dictLabel", value="\u6807\u7b7e\u540d", required=false, paramType="query"), @ApiImplicitParam(name="dictType", value="\u7c7b\u578b", required=false, paramType="query"), @ApiImplicitParam(name="dictDescription", value="\u63cf\u8ff0", required=false, paramType="query"), @ApiImplicitParam(name="dictSort", value="\u6392\u5e8f\uff08\u5347\u5e8f\uff09", required=false, paramType="query"), @ApiImplicitParam(name="dictParentId", value="\u7236\u7ea7\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="isChild", value="\u5b50\u4e1a\u52a1\u5173\u8054", required=false, paramType="query")})
    @GetMapping(value={"/list"})
    @ResponseBody
    public void list(@ModelAttribute @ApiIgnore DictEntity dict, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        dict.setAppId(BasicUtil.getAppId());
        BasicUtil.startPage();
        List dictList = this.dictBiz.query((BaseEntity)dict);
        this.outJson(response, JSONArray.toJSONString((Object)new EUListBean(dictList, (int)BasicUtil.endPage((List)dictList).getTotal()), (SerializeFilter[])new SerializeFilter[]{new DoubleValueFilter(), new DateValueFilter()}));
    }

    @GetMapping(value={"/form"})
    public String form(@ModelAttribute DictEntity dict, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (dict.getDictId() != null) {
            BaseEntity dictEntity = this.dictBiz.getEntity(dict.getDictId());
            model.addAttribute("dictEntity", (Object)dictEntity);
        }
        return "/mdiy/dict/form";
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178\u8be6\u60c5\u63a5\u53e3")
    @ApiImplicitParam(name="dictId", value="\u5b57\u5178\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @ResponseBody
    public void get(@ModelAttribute @ApiIgnore DictEntity dict, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (dict.getDictId() <= 0) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("dict.id")}));
            return;
        }
        DictEntity _dict = (DictEntity)this.dictBiz.getEntity(dict.getDictId());
        this.outJson(response, (BaseEntity)_dict);
    }

    @ApiOperation(value="\u4fdd\u5b58\u5b57\u5178\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dictLabel", value="\u6807\u7b7e\u540d", required=true, paramType="query"), @ApiImplicitParam(name="dictType", value="\u7c7b\u578b", required=true, paramType="query"), @ApiImplicitParam(name="dictValue", value="\u6570\u636e\u503c", required=false, paramType="query"), @ApiImplicitParam(name="dictDescription", value="\u63cf\u8ff0", required=false, paramType="query"), @ApiImplicitParam(name="dictSort", value="\u6392\u5e8f\uff08\u5347\u5e8f\uff09", required=false, paramType="query"), @ApiImplicitParam(name="dictParentId", value="\u7236\u7ea7\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="isChild", value="\u5b50\u4e1a\u52a1\u5173\u8054", required=false, paramType="query"), @ApiImplicitParam(name="dictRemarks", value="\u5907\u6ce8\u4fe1\u606f", required=false, paramType="query")})
    @PostMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:dict:save"})
    public void save(@ModelAttribute @ApiIgnore DictEntity dict, HttpServletResponse response, HttpServletRequest request) {
        dict.setAppId(BasicUtil.getAppId());
        if (this.dictBiz.getByTypeAndLabel(dict.getDictType(), dict.getDictLabel()) != null) {
            this.outJson(response, null, false, this.getResString("diy.dict.type.and.label.repeat"));
            return;
        }
        this.dictBiz.saveEntity((BaseEntity)dict);
        if (StringUtil.isBlank((Object)dict.getDictValue())) {
            dict.setDictValue(dict.getDictId() + "");
            this.dictBiz.updateEntity((BaseEntity)dict);
        }
        this.outJson(response, true);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5b57\u5178")
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:dict:del"})
    public void delete(@RequestBody List<DictEntity> dicts, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[dicts.size()];
        for (int i = 0; i < dicts.size(); ++i) {
            ids[i] = dicts.get(i).getDictId();
        }
        this.dictBiz.delete(ids);
        this.outJson(response, true);
    }

    @ApiOperation(value="\u66f4\u65b0\u5b57\u5178\u4fe1\u606f\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dictId", value="\u5b57\u5178\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="dictLabel", value="\u6807\u7b7e\u540d", required=true, paramType="query"), @ApiImplicitParam(name="dictType", value="\u7c7b\u578b", required=true, paramType="query"), @ApiImplicitParam(name="dictValue", value="\u6570\u636e\u503c", required=false, paramType="query"), @ApiImplicitParam(name="dictDescription", value="\u63cf\u8ff0", required=false, paramType="query"), @ApiImplicitParam(name="dictSort", value="\u6392\u5e8f\uff08\u5347\u5e8f\uff09", required=false, paramType="query"), @ApiImplicitParam(name="dictParentId", value="\u7236\u7ea7\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="isChild", value="\u5b50\u4e1a\u52a1\u5173\u8054", required=false, paramType="query"), @ApiImplicitParam(name="dictRemarks", value="\u5907\u6ce8\u4fe1\u606f", required=false, paramType="query")})
    @PostMapping(value={"/update"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:dict:update"})
    public void update(@ModelAttribute @ApiIgnore DictEntity dict, HttpServletResponse response, HttpServletRequest request) {
        DictEntity _dict = this.dictBiz.getByTypeAndLabel(dict.getDictType(), dict.getDictLabel());
        if (_dict != null && !_dict.getDictId().equals(dict.getDictId())) {
            this.outJson(response, null, false, this.getResString("diy.dict.type.and.label.repeat"));
            return;
        }
        if (StringUtil.isBlank((Object)dict.getDictValue())) {
            dict.setDictValue(null);
        }
        this.dictBiz.updateEntity((BaseEntity)dict);
        this.outJson(response, true);
    }
}

