/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action;

import com.alibaba.fastjson.serializer.SerializeFilter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.constant.e.BaseSessionEnum;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.filter.DateValueFilter;
import net.mingsoft.base.filter.DoubleValueFilter;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.constant.e.SessionConstEnum;
import net.mingsoft.basic.entity.ManagerEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.biz.IFormBiz;
import net.mingsoft.mdiy.biz.IFormFieldBiz;
import net.mingsoft.mdiy.entity.FormEntity;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u81ea\u5b9a\u4e49\u8868\u5355\u63a5\u53e3")
@Controller
@RequestMapping(value={"/${ms.manager.path}/mdiy/form"})
public class FormAction
extends BaseAction {
    private static final String TABLE_NAME_PREFIX = "mdiy_";
    private static final String TABLE_NAME_SPLIT = "_";
    @Autowired
    IFormBiz formBiz;
    @Autowired
    IFormFieldBiz formFieldBiz;

    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/mdiy/form/index";
    }

    @ApiOperation(value="\u67e5\u8be2\u81ea\u5b9a\u4e49\u8868\u5355\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="formTipsName", value="\u81ea\u5b9a\u4e49\u8868\u5355\u63d0\u793a\u6587\u5b57", required=false, paramType="query"), @ApiImplicitParam(name="formTableName", value="\u81ea\u5b9a\u4e49\u8868\u5355\u8868\u540d", required=false, paramType="query"), @ApiImplicitParam(name="dfManagerid", value="\u81ea\u5b9a\u4e49\u8868\u5355\u5173\u8054\u7684\u5173\u8054\u5458id", required=false, paramType="query")})
    @GetMapping(value={"/list"})
    @ResponseBody
    public void list(@ModelAttribute @ApiIgnore FormEntity form, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        form.setAppId(BasicUtil.getAppId());
        BasicUtil.startPage();
        List formList = this.formBiz.query((BaseEntity)form);
        this.outJson(response, JSONArray.toJSONString((Object)new EUListBean(formList, (int)BasicUtil.endPage((List)formList).getTotal()), (SerializeFilter[])new SerializeFilter[]{new DoubleValueFilter(), new DateValueFilter()}));
    }

    @GetMapping(value={"/form"})
    public String form(@ModelAttribute FormEntity form, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (form.getFormId() != null) {
            FormEntity formEntity = (FormEntity)this.formBiz.getEntity(form.getFormId());
            model.addAttribute("formEntity", (Object)formEntity);
        }
        return "/mdiy/form/form";
    }

    @ApiOperation(value="\u83b7\u53d6\u81ea\u5b9a\u4e49\u8868\u5355\u63a5\u53e3")
    @ApiImplicitParam(name="formId", value="\u81ea\u5b9a\u4e49\u8868\u5355\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @ResponseBody
    public void get(@ModelAttribute @ApiIgnore FormEntity form, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (form.getFormId() <= 0) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("form.id")}));
            return;
        }
        FormEntity _form = (FormEntity)this.formBiz.getEntity(form.getFormId());
        this.outJson(response, (BaseEntity)_form);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u8868\u5355\u63a5\u53e3")
    @PostMapping(value={"/delete"})
    @ResponseBody
    public void delete(@RequestBody List<FormEntity> forms, HttpServletResponse response, HttpServletRequest request) {
        for (int i = 0; i < forms.size(); ++i) {
            FormEntity form = (FormEntity)this.formBiz.getEntity(forms.get(i).getFormId());
            if (form == null) {
                this.outJson(response, null, false, this.getResString("err.not.exist", new String[]{this.getResString("diy.form")}));
                return;
            }
            this.formBiz.dropTable(form.getFormTableName());
            this.formBiz.deleteEntity(forms.get(i).getFormId());
        }
        this.outJson(response, true);
    }

    @ApiOperation(value="\u4fdd\u5b58\u81ea\u5b9a\u4e49\u8868\u5355\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="formTableName", value="\u81ea\u5b9a\u4e49\u8868\u5355\u8868\u540d", required=true, paramType="query"), @ApiImplicitParam(name="formTipsName", value="\u81ea\u5b9a\u4e49\u8868\u5355\u63d0\u793a\u6587\u5b57", required=false, paramType="query"), @ApiImplicitParam(name="dfManagerid", value="\u81ea\u5b9a\u4e49\u8868\u5355\u5173\u8054\u7684\u5173\u8054\u5458id", required=false, paramType="query"), @ApiImplicitParam(name="formAppId", value="\u81ea\u5b9a\u4e49\u8868\u5355\u5173\u8054\u7684\u5e94\u7528\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="formUrl", value="\u8868\u5355\u7684\u8bbf\u95ee\u5730\u5740", required=false, paramType="query")})
    @PostMapping(value={"/save"})
    @RequiresPermissions(value={"mdiy:form:save"})
    public void save(@ModelAttribute @ApiIgnore FormEntity form, HttpServletRequest request, HttpServletResponse response) {
        if (!StringUtil.checkLength((String)form.getFormTableName(), (int)1, (int)20)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("fieldTipsName"), "1", "20"}));
            return;
        }
        if (!StringUtil.checkLength((String)form.getFormTipsName(), (int)1, (int)20)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("fieldFieldName"), "1", "20"}));
            return;
        }
        ManagerEntity managerSession = (ManagerEntity)BasicUtil.getSession((BaseSessionEnum)SessionConstEnum.MANAGER_SESSION);
        int managerId = managerSession.getManagerId();
        String formTableName = TABLE_NAME_PREFIX + form.getFormTableName() + TABLE_NAME_SPLIT + managerId;
        FormEntity _form = new FormEntity();
        _form.setFormTableName(formTableName);
        if (this.formBiz.getEntity((BaseEntity)_form) != null) {
            this.outJson(response, null, false, this.getResString("err.exist", new String[]{this.getResString("diy.form.table.name")}));
            return;
        }
        int appId = this.getAppId(request);
        form.setAppId(BasicUtil.getAppId());
        String tableName = TABLE_NAME_PREFIX + form.getFormTableName() + TABLE_NAME_SPLIT + managerId;
        form.setFormTableName(tableName);
        this.formBiz.createDiyFormTable(form.getFormTableName(), null);
        this.formBiz.saveEntity((BaseEntity)form);
        _form.setAppId(BasicUtil.getAppId());
        _form = (FormEntity)((Object)this.formBiz.getEntity((BaseEntity)_form));
        int diyFormId = _form.getFormId();
        this.outJson(response, null, true, String.valueOf(diyFormId));
    }

    @ApiOperation(value="\u66f4\u65b0\u81ea\u5b9a\u4e49\u8868\u5355\u8868\u4fe1\u606f\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="formTableName", value="\u81ea\u5b9a\u4e49\u8868\u5355\u8868\u540d", required=true, paramType="query"), @ApiImplicitParam(name="formTipsName", value="\u81ea\u5b9a\u4e49\u8868\u5355\u63d0\u793a\u6587\u5b57", required=false, paramType="query"), @ApiImplicitParam(name="dfManagerid", value="\u81ea\u5b9a\u4e49\u8868\u5355\u5173\u8054\u7684\u5173\u8054\u5458id", required=false, paramType="query"), @ApiImplicitParam(name="updateBy", value="\u6700\u540e\u66f4\u65b0\u7528\u6237\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="updateDate", value="\u6700\u540e\u66f4\u65b0\u65e5\u671f", required=false, paramType="query")})
    @PostMapping(value={"/update"})
    @RequiresPermissions(value={"mdiy:form:update"})
    public void update(@ModelAttribute @ApiIgnore FormEntity form, HttpServletResponse response, HttpServletRequest request) {
        if (!StringUtil.checkLength((String)form.getFormTableName(), (int)1, (int)20)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("fieldTipsName"), "1", "20"}));
            return;
        }
        if (!StringUtil.checkLength((String)form.getFormTipsName(), (int)1, (int)20)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("fieldFieldName"), "1", "20"}));
            return;
        }
        FormEntity _form = new FormEntity();
        _form.setFormTableName(form.getFormTableName());
        _form.setAppId(BasicUtil.getAppId());
        _form = (FormEntity)((Object)this.formBiz.getEntity((BaseEntity)_form));
        int formId = _form.getFormId();
        form.setFormId(formId);
        this.formBiz.updateEntity((BaseEntity)form);
        this.outJson(response, null, true, String.valueOf(formId));
    }

    @ApiOperation(value="\u9a8c\u8bc1\u81ea\u5b9a\u4e49\u8868\u540d\u5408\u6cd5\u6027\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="formId", value="\u81ea\u5b9a\u4e49\u8868\u5355\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="formTableName", value="\u81ea\u5b9a\u4e49\u8868\u5355\u8868\u540d", required=true, paramType="query")})
    @GetMapping(value={"/checkTableNameExist"})
    public void checkTableNameExist(@ModelAttribute @ApiIgnore FormEntity form, HttpServletRequest request, HttpServletResponse response) {
        ManagerEntity managerSession = (ManagerEntity)BasicUtil.getSession((BaseSessionEnum)SessionConstEnum.MANAGER_SESSION);
        int managerId = managerSession.getManagerId();
        String formTableName = TABLE_NAME_PREFIX + form.getFormTableName() + TABLE_NAME_SPLIT + managerId;
        FormEntity _form = new FormEntity();
        _form.setFormTableName(formTableName);
        _form = (FormEntity)((Object)this.formBiz.getEntity((BaseEntity)_form));
        if (_form == null) {
            this.outJson(response, null, false);
            return;
        }
        this.outJson(response, null, true);
    }

    @ApiOperation(value="\u52a0\u8f7d\u81ea\u5b9a\u4e49\u8868\u5355\u7684\u6570\u636e\u5217\u8868\u9875\u9762\u63a5\u53e3")
    @ApiImplicitParam(name="formId", value="\u81ea\u5b9a\u4e49\u8868\u5355\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/querydata"})
    public String query(@ModelAttribute @ApiIgnore FormEntity form, HttpServletRequest request, @ApiIgnore ModelMap model) {
        int pageNo = 1;
        if (request.getParameter("pageNo") != null) {
            pageNo = Integer.parseInt(request.getParameter("pageNo"));
        }
        int appId = BasicUtil.getAppId();
        int count = this.formBiz.countDiyFormData(form.getFormId(), appId);
        Map map = this.formBiz.queryDiyFormData(form.getFormId(), appId, null);
        if (map != null) {
            List fields = (List)map.get("fields");
            if (fields != null) {
                model.addAttribute("fields", (Object)fields);
            }
            if (map.get("list") != null) {
                model.addAttribute("list", map.get("list"));
            }
        }
        model.addAttribute("title", (Object)request.getParameter("title"));
        return "/mdiy/diy_form/diy_form_data_list";
    }

    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u81ea\u5b9a\u4e49\u8868\u5355\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u8bb0\u5f55\u7f16\u53f7", required=true, paramType="path"), @ApiImplicitParam(name="diyFormId", value="\u8868\u5355\u7f16\u53f7", required=true, paramType="path")})
    @PostMapping(value={"/{diyFormId}/{id}/delete"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:form:del"})
    public void delete(@ApiIgnore @PathVariable(value="id") int id, @ApiIgnore @PathVariable(value="diyFormId") int diyFormId, HttpServletRequest request, HttpServletResponse response) {
        this.formBiz.deleteQueryDiyFormData(id, diyFormId);
        this.outJson(response, null, true);
    }
}

