/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.constant.e.TableEnum;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.biz.IFormBiz;
import net.mingsoft.mdiy.biz.IFormFieldBiz;
import net.mingsoft.mdiy.constant.e.DiyFormFieldEnum;
import net.mingsoft.mdiy.entity.FormEntity;
import net.mingsoft.mdiy.entity.FormFieldEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u81ea\u5b9a\u4e49\u8868\u5355\u5b57\u6bb5\u63a5\u53e3")
@Controller(value="diyFormField")
@RequestMapping(value={"/${ms.manager.path}/mdiy/form/formField"})
public class FormFieldAction
extends BaseAction {
    private static final String FIELD_ID = "id";
    private static final String FIELD_DATE = "date";
    private static final String FIELD_FORMID = "formId";
    @Autowired
    private IFormFieldBiz diyFormFieldBiz;
    @Autowired
    private IFormBiz diyFormBiz;

    @ApiOperation(value="\u67e5\u8be2\u5b57\u6bb5\u7684\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParam(name="diyFormId", value="\u81ea\u5b9a\u4e49\u8868\u5355\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/list"})
    @ResponseBody
    public Map list(@ApiIgnore int diyFormId, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<FormFieldEntity> fieldList = this.diyFormFieldBiz.queryByDiyFormId(diyFormId);
        map.put("fieldList", fieldList);
        Map fieldType = DiyFormFieldEnum.toMap();
        map.put("fieldType", fieldType);
        map.put("fieldNum", fieldType.size());
        return map;
    }

    @ApiOperation(value="\u6dfb\u52a0\u81ea\u5b9a\u4e49\u5b57\u6bb5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="diyFormId", value="\u81ea\u5b9a\u4e49\u8868\u5355\u7f16\u53f7", required=true, paramType="path"), @ApiImplicitParam(name="diyFormFieldTipsName", value="\u5b57\u6bb5\u63d0\u793a\u6587\u5b57", required=true, paramType="query"), @ApiImplicitParam(name="diyFormFieldFieldName", value="\u5b57\u6bb5\u540d\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="diyFormFieldFormId", value="\u5bf9\u5e94\u7684\u81ea\u5b9a\u4e49from\u7684id", required=true, paramType="query"), @ApiImplicitParam(name="diyFormFieldType", value="\u5b57\u6bb5\u7c7b\u578b1\u5b57\u7b262\u65e5\u671f3\u6587\u672c4\u6574\u578b5\u5c0f\u6570", required=true, paramType="query"), @ApiImplicitParam(name="diyFormFieldDefault", value="\u5b57\u6bb5\u7684\u9ed8\u8ba4\u503c0\uff0cnull", required=true, paramType="query"), @ApiImplicitParam(name="diyFormFieldSort", value="\u6392\u5e8f", required=false, paramType="query"), @ApiImplicitParam(name="diyFormFieldIsNull", value="\u5224\u65ad\u5b57\u6bb5\u4e3a\u5fc5\u586b\u8fd8\u662f\u53ef\u9009", required=false, paramType="query")})
    @PostMapping(value={"/{diyFormId}/save"})
    @ResponseBody
    public void save(@ModelAttribute @ApiIgnore FormFieldEntity diyFormfield, @ApiIgnore @PathVariable int diyFormId, HttpServletResponse response) {
        FormEntity diyForm = (FormEntity)this.diyFormBiz.getEntity(diyFormId);
        if (diyForm == null) {
            this.outJson(response, null, false, this.getResString("err.not.exist", new String[]{this.getResString("diy.form")}));
            return;
        }
        if (!StringUtil.checkLength((String)diyFormfield.getDiyFormFieldTipsName(), (int)1, (int)20)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("diy.form.tips.name"), "1", "20"}));
            return;
        }
        if (!StringUtil.checkLength((String)diyFormfield.getDiyFormFieldFieldName(), (int)1, (int)20)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("diy.form.table.column.name"), "1", "20"}));
            return;
        }
        if (this.diyFormFieldBiz.getByFieldName(diyFormfield.getDiyFormFieldFormId(), diyFormfield.getDiyFormFieldFieldName()) != null) {
            this.outJson(response, null, false, this.getResString("err.exist", new String[]{this.getResString("diy.form.table.column.name")}));
            return;
        }
        HashMap<String, String> fileds = new HashMap<String, String>();
        fileds.put("fieldName", diyFormfield.getDiyFormFieldFieldName());
        fileds.put("fieldType", diyFormfield.getDiyFormFieldColumnType());
        fileds.put("default", diyFormfield.getDiyFormFieldDefault());
        this.diyFormFieldBiz.alterTable(diyForm.getFormTableName(), fileds, TableEnum.ALTER_ADD);
        this.diyFormFieldBiz.saveEntity(diyFormfield);
        this.outJson(response, null, true, null);
    }

    @ApiOperation(value="\u83b7\u53d6\u7f16\u8f91\u7684\u5b57\u6bb5\u5b9e\u4f53\u7684\u4fe1\u606f\u63a5\u53e3")
    @ApiImplicitParam(name="diyFormFieldId", value="\u81ea\u5b9a\u4e49\u8868\u5355\u5b57\u6bb5\u7f16\u53f7", required=true, paramType="path")
    @GetMapping(value={"/{diyFormFieldId}/edit"})
    @ResponseBody
    public Map edit(@PathVariable @ApiIgnore int diyFormFieldId, HttpServletRequest request) {
        HashMap<String, FormFieldEntity> mode = new HashMap<String, FormFieldEntity>();
        FormFieldEntity diyFormfield = (FormFieldEntity)this.diyFormFieldBiz.getEntity(diyFormFieldId);
        mode.put("diyFormfield", diyFormfield);
        return mode;
    }

    @ApiOperation(value="\u66f4\u65b0\u5b57\u6bb5\u4fe1\u606f\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="diyFormId", value="\u81ea\u5b9a\u4e49\u8868\u5355\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="diyFormFieldTipsName", value="\u5b57\u6bb5\u63d0\u793a\u6587\u5b57", required=true, paramType="query"), @ApiImplicitParam(name="diyFormFieldFieldName", value="\u5b57\u6bb5\u540d\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="diyFormFieldFormId", value="\u5bf9\u5e94\u7684\u81ea\u5b9a\u4e49from\u7684id", required=true, paramType="query"), @ApiImplicitParam(name="diyFormFieldType", value="\u5b57\u6bb5\u7c7b\u578b1\u5b57\u7b262\u65e5\u671f3\u6587\u672c4\u6574\u578b5\u5c0f\u6570", required=true, paramType="query"), @ApiImplicitParam(name="diyFormFieldDefault", value="\u5b57\u6bb5\u7684\u9ed8\u8ba4\u503c0\uff0cnull", required=true, paramType="query"), @ApiImplicitParam(name="diyFormFieldSort", value="\u6392\u5e8f", required=false, paramType="query"), @ApiImplicitParam(name="diyFormFieldIsNull", value="\u5224\u65ad\u5b57\u6bb5\u4e3a\u5fc5\u586b\u8fd8\u662f\u53ef\u9009", required=false, paramType="query")})
    @PostMapping(value={"/update"})
    @ResponseBody
    public void update(@ModelAttribute @ApiIgnore FormFieldEntity diyFormfield, HttpServletResponse response) {
        if (!StringUtil.checkLength((String)diyFormfield.getDiyFormFieldTipsName(), (int)1, (int)20)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("fieldTipsName"), "1", "20"}));
            return;
        }
        if (!StringUtil.checkLength((String)diyFormfield.getDiyFormFieldFieldName(), (int)1, (int)20)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("fieldFieldName"), "1", "20"}));
            return;
        }
        FormEntity diyForm = (FormEntity)this.diyFormBiz.getEntity(diyFormfield.getDiyFormFieldFormId());
        FormFieldEntity oldField = (FormFieldEntity)this.diyFormFieldBiz.getEntity(diyFormfield.getDiyFormFieldId());
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("fieldOldName", oldField.getDiyFormFieldFieldName());
        fields.put("fieldName", diyFormfield.getDiyFormFieldFieldName());
        fields.put("fieldType", diyFormfield.getDiyFormFieldColumnType());
        fields.put("default", diyFormfield.getDiyFormFieldDefault());
        if (diyForm == null) {
            this.outJson(response, null, false, this.getResString("err.not.exist"));
            return;
        }
        this.diyFormFieldBiz.alterTable(diyForm.getFormTableName(), fields, "modify");
        this.diyFormFieldBiz.updateEntity(diyFormfield);
        this.outJson(response, null, true, null);
    }

    @ApiOperation(value="\u5224\u65ad\u5b57\u6bb5\u540d\u662f\u5426\u5b58\u5728\u91cd\u590d\u63a5\u53e3")
    @ApiImplicitParam(name="diyFormFieldFieldName", value="\u5b57\u6bb5\u540d", required=true, paramType="path")
    @GetMapping(value={"/{diyFormFieldFieldName}/checkFieldNameExist"})
    @ResponseBody
    public boolean checkFieldNameExist(@PathVariable @ApiIgnore String diyFormFieldFieldName, HttpServletRequest request) {
        int diyFormFieldFormId = 1;
        if (request.getParameter("diyFormFieldFormId") != null) {
            diyFormFieldFormId = Integer.parseInt(request.getParameter("diyFormFieldFormId"));
        }
        return diyFormFieldFieldName.equalsIgnoreCase(FIELD_ID) || diyFormFieldFieldName.equalsIgnoreCase(FIELD_DATE) || diyFormFieldFieldName.equalsIgnoreCase(FIELD_FORMID) || this.diyFormFieldBiz.getByFieldName(diyFormFieldFormId, diyFormFieldFieldName) != null;
    }

    @ApiOperation(value="\u5220\u9664\u81ea\u5b9a\u4e49\u5b57\u6bb5\u63a5\u53e3")
    @ApiImplicitParam(name="fieldId", value="\u8868\u5355\u7f16\u53f7", required=true, paramType="path")
    @PostMapping(value={"/{fieldId}/delete"})
    public void delete(@PathVariable @ApiIgnore int fieldId, HttpServletRequest request, HttpServletResponse response) {
        FormFieldEntity diyFormField = (FormFieldEntity)this.diyFormFieldBiz.getEntity(fieldId);
        if (diyFormField == null) {
            this.outJson(response, null, false, this.getResString("err.not.exist", new String[]{this.getResString("diy.form.field")}));
            return;
        }
        FormEntity diyForm = (FormEntity)this.diyFormBiz.getEntity(diyFormField.getDiyFormFieldFormId());
        if (diyForm == null) {
            this.outJson(response, null, false, this.getResString("err.not.exist", new String[]{this.getResString("diy.form")}));
            return;
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("fieldName", diyFormField.getDiyFormFieldFieldName());
        this.diyFormFieldBiz.alterTable(diyForm.getFormTableName(), fields, "drop");
        this.diyFormFieldBiz.deleteEntity(diyFormField.getDiyFormFieldId());
        this.outJson(response, null, true);
    }
}

