/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action;

import com.alibaba.fastjson.serializer.SerializeFilter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.filter.DateValueFilter;
import net.mingsoft.base.filter.DoubleValueFilter;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.base.util.JSONObject;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.biz.IPageBiz;
import net.mingsoft.mdiy.entity.PageEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u81ea\u5b9a\u4e49\u9875\u9762\u63a5\u53e3")
@Controller
@RequestMapping(value={"/${ms.manager.path}/mdiy/page"})
public class PageAction
extends BaseAction {
    @Autowired
    private IPageBiz pageBiz;

    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/mdiy/page/index";
    }

    @ApiOperation(value="\u67e5\u8be2\u81ea\u5b9a\u4e49\u9875\u9762\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageModelId", value="\u6a21\u5757\u7f16\u53f7", required=false, paramType="query"), @ApiImplicitParam(name="pagePath", value="\u81ea\u5b9a\u4e49\u9875\u9762\u7ed1\u5b9a\u6a21\u677f\u7684\u8def\u5f84", required=false, paramType="query"), @ApiImplicitParam(name="pageTitle", value="\u81ea\u5b9a\u4e49\u9875\u9762\u6807\u9898", required=false, paramType="query"), @ApiImplicitParam(name="pageKey", value="\u81ea\u5b9a\u4e49\u9875\u9762\u8bbf\u95ee\u8def\u5f84", required=false, paramType="query")})
    @GetMapping(value={"/list"})
    @ResponseBody
    public void list(@ModelAttribute @ApiIgnore PageEntity page, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        page.setPageAppId(BasicUtil.getAppId());
        BasicUtil.startPage();
        List pageList = this.pageBiz.query(page);
        this.outJson(response, JSONArray.toJSONString((Object)new EUListBean(pageList, (int)BasicUtil.endPage((List)pageList).getTotal()), (SerializeFilter[])new SerializeFilter[]{new DoubleValueFilter(), new DateValueFilter()}));
    }

    @GetMapping(value={"/form"})
    public String form(@ModelAttribute PageEntity page, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (page.getPageId() != null) {
            BaseEntity pageEntity = this.pageBiz.getEntity(page.getPageId());
            model.addAttribute("pageEntity", (Object)pageEntity);
        }
        return "/mdiy/page/form";
    }

    @ApiOperation(value="\u83b7\u53d6\u81ea\u5b9a\u4e49\u9875\u9762\u63a5\u53e3")
    @ApiImplicitParam(name="pageId", value="\u81ea\u5b9a\u4e49\u9875\u9762\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @ResponseBody
    public void get(@ModelAttribute @ApiIgnore PageEntity page, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (page.getPageId() <= 0) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("page.id")}));
            return;
        }
        PageEntity _page = (PageEntity)this.pageBiz.getEntity(page.getPageId());
        this.outJson(response, _page);
    }

    @ApiOperation(value="\u4fdd\u5b58\u81ea\u5b9a\u4e49\u9875\u9762\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pagePath", value="\u81ea\u5b9a\u4e49\u9875\u9762\u7ed1\u5b9a\u6a21\u677f\u7684\u8def\u5f84", required=true, paramType="query"), @ApiImplicitParam(name="pageTitle", value="\u81ea\u5b9a\u4e49\u9875\u9762\u6807\u9898", required=true, paramType="query"), @ApiImplicitParam(name="pageKey", value="\u81ea\u5b9a\u4e49\u9875\u9762\u8bbf\u95ee\u8def\u5f84", required=true, paramType="query"), @ApiImplicitParam(name="pageModelId", value="\u6a21\u5757\u7f16\u53f7", required=false, paramType="query")})
    @PostMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:page:save"})
    public void save(@ModelAttribute @ApiIgnore PageEntity page, HttpServletResponse response, HttpServletRequest request) {
        page.setPageAppId(BasicUtil.getAppId());
        if (StringUtils.isBlank((CharSequence)(page.getPageAppId() + ""))) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("page.app.id")}));
            return;
        }
        if (!StringUtil.checkLength((String)(page.getPageAppId() + ""), (int)1, (int)10)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("page.app.id"), "1", "10"}));
            return;
        }
        if (StringUtils.isBlank((CharSequence)page.getPagePath())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("page.path")}));
            return;
        }
        if (!StringUtil.checkLength((String)(page.getPagePath() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("page.path"), "1", "255"}));
            return;
        }
        if (StringUtils.isBlank((CharSequence)page.getPageTitle())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("page.title")}));
            return;
        }
        if (!StringUtil.checkLength((String)(page.getPageTitle() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("page.title"), "1", "255"}));
            return;
        }
        if (StringUtils.isBlank((CharSequence)page.getPageKey())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("page.key")}));
            return;
        }
        if (!StringUtil.checkLength((String)(page.getPageKey() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("page.key"), "1", "255"}));
            return;
        }
        this.pageBiz.saveEntity(page);
        this.outJson(response, JSONObject.toJSONString((Object)((Object)page)));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u9875\u9762\u63a5\u53e3")
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:page:del"})
    public void delete(@RequestBody List<PageEntity> pages, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[pages.size()];
        for (int i = 0; i < pages.size(); ++i) {
            ids[i] = pages.get(i).getPageId();
        }
        this.pageBiz.delete(ids);
        this.outJson(response, true);
    }

    @ApiOperation(value="\u66f4\u65b0\u81ea\u5b9a\u4e49\u9875\u9762\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageId", value="\u81ea\u5b9a\u4e49\u9875\u9762\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="pagePath", value="\u81ea\u5b9a\u4e49\u9875\u9762\u7ed1\u5b9a\u6a21\u677f\u7684\u8def\u5f84", required=true, paramType="query"), @ApiImplicitParam(name="pageTitle", value="\u81ea\u5b9a\u4e49\u9875\u9762\u6807\u9898", required=true, paramType="query"), @ApiImplicitParam(name="pageKey", value="\u81ea\u5b9a\u4e49\u9875\u9762\u8bbf\u95ee\u8def\u5f84", required=true, paramType="query"), @ApiImplicitParam(name="pageModelId", value="\u6a21\u5757\u7f16\u53f7", required=false, paramType="query")})
    @PostMapping(value={"/update"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:page:update"})
    public void update(@ModelAttribute @ApiIgnore PageEntity page, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)page.getPagePath())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("page.path")}));
            return;
        }
        if (!StringUtil.checkLength((String)(page.getPagePath() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("page.path"), "1", "255"}));
            return;
        }
        if (StringUtils.isBlank((CharSequence)page.getPageTitle())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("page.title")}));
            return;
        }
        if (!StringUtil.checkLength((String)(page.getPageTitle() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("page.title"), "1", "255"}));
            return;
        }
        if (StringUtils.isBlank((CharSequence)page.getPageKey())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("page.key")}));
            return;
        }
        if (!StringUtil.checkLength((String)(page.getPageKey() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("page.key"), "1", "255"}));
            return;
        }
        this.pageBiz.updateEntity(page);
        this.outJson(response, JSONObject.toJSONString((Object)((Object)page)));
    }
}

