/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action;

import com.alibaba.fastjson.serializer.SerializeFilter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.filter.DateValueFilter;
import net.mingsoft.base.filter.DoubleValueFilter;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.base.util.JSONObject;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.biz.IColumnBiz;
import net.mingsoft.basic.entity.ColumnEntity;
import net.mingsoft.basic.entity.ManagerSessionEntity;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.biz.IContentModelFieldBiz;
import net.mingsoft.mdiy.biz.ISearchBiz;
import net.mingsoft.mdiy.constant.Const;
import net.mingsoft.mdiy.entity.ContentModelFieldEntity;
import net.mingsoft.mdiy.entity.SearchEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u81ea\u5b9a\u4e49\u641c\u7d22\u63a5\u53e3")
@Controller
@RequestMapping(value={"/${ms.manager.path}/mdiy/search"})
public class SearchAction
extends BaseAction {
    @Autowired
    private ISearchBiz searchBiz;
    @Autowired
    private IColumnBiz columnBiz;
    @Autowired
    private IContentModelFieldBiz fieldBiz;

    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        model.addAttribute("searchType", (Object)BasicUtil.resToMap((String)"net.mingsoft.mdiy.resources.search_type"));
        return "/mdiy/search/index";
    }

    @ApiOperation(value="\u67e5\u8be2\u81ea\u5b9a\u4e49\u641c\u7d22\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchName", value="\u641c\u7d22\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="searchTemplets", value="\u641c\u7d22\u7ed3\u679c\u6a21\u677f", required=false, paramType="query"), @ApiImplicitParam(name="searchType", value="\u641c\u7d22\u7c7b\u578b", required=false, paramType="query")})
    @GetMapping(value={"/list"})
    @ResponseBody
    public void list(@ModelAttribute @ApiIgnore SearchEntity search, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (search == null) {
            search = new SearchEntity();
        }
        search.setAppId(BasicUtil.getAppId());
        BasicUtil.startPage();
        List searchList = this.searchBiz.query((BaseEntity)search);
        this.outJson(response, JSONArray.toJSONString((Object)new EUListBean(searchList, (int)BasicUtil.endPage((List)searchList).getTotal()), (SerializeFilter[])new SerializeFilter[]{new DoubleValueFilter(), new DateValueFilter()}));
    }

    @GetMapping(value={"/form"})
    public void form(@ModelAttribute SearchEntity search, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (search.getSearchId() <= 0) {
            this.outJson(response, false);
            return;
        }
        SearchEntity searchEntity = (SearchEntity)((Object)this.searchBiz.getEntity((BaseEntity)search));
        this.outJson(response, (BaseEntity)searchEntity);
    }

    @ApiOperation(value="\u83b7\u53d6\u81ea\u5b9a\u4e49\u641c\u7d22\u8be6\u60c5")
    @ApiImplicitParam(name="searchId", value="\u81ea\u5b9a\u4e49\u641c\u7d22\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @ResponseBody
    public void get(@ModelAttribute @ApiIgnore SearchEntity search, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (search.getSearchId() <= 0) {
            this.outJson(response, null, false, this.getResString("err.error", new String[]{this.getResString("search.id")}));
            return;
        }
        SearchEntity _search = (SearchEntity)this.searchBiz.getEntity(search.getSearchId());
        this.outJson(response, (BaseEntity)_search);
    }

    @ApiOperation(value="\u4fdd\u5b58\u81ea\u5b9a\u4e49\u641c\u7d22\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchType", value="\u641c\u7d22\u7c7b\u578b", required=true, paramType="query"), @ApiImplicitParam(name="searchName", value="\u641c\u7d22\u540d\u79f0", required=true, paramType="query"), @ApiImplicitParam(name="searchTemplets", value="\u641c\u7d22\u7ed3\u679c\u6a21\u677f", required=false, paramType="query")})
    @PostMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:search:save"})
    public void save(@ModelAttribute @ApiIgnore SearchEntity search, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)search.getSearchType())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("search.type")}));
            return;
        }
        if (!StringUtil.checkLength((String)(search.getSearchType() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("search.type"), "1", "255"}));
            return;
        }
        if (StringUtils.isBlank((CharSequence)search.getSearchName())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("search.name")}));
            return;
        }
        if (!StringUtil.checkLength((String)(search.getSearchName() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("search.name"), "1", "255"}));
            return;
        }
        search.setAppId(BasicUtil.getAppId());
        this.searchBiz.saveEntity((BaseEntity)search);
        this.outJson(response, JSONObject.toJSONString((Object)((Object)search)));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u641c\u7d22\u63a5\u53e3")
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:search:del"})
    public void delete(@RequestBody List<SearchEntity> searchs, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[searchs.size()];
        for (int i = 0; i < searchs.size(); ++i) {
            ids[i] = searchs.get(i).getSearchId();
        }
        this.searchBiz.delete(ids);
        this.outJson(response, true);
    }

    @ApiOperation(value="\u66f4\u65b0\u81ea\u5b9a\u4e49\u641c\u7d22\u4fe1\u606f\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="searchType", value="\u641c\u7d22\u7c7b\u578b", required=true, paramType="query"), @ApiImplicitParam(name="searchName", value="\u641c\u7d22\u540d\u79f0", required=false, paramType="query"), @ApiImplicitParam(name="searchTemplets", value="\u641c\u7d22\u7ed3\u679c\u6a21\u677f", required=false, paramType="query")})
    @PostMapping(value={"/update"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:search:update"})
    public void update(@ModelAttribute @ApiIgnore SearchEntity search, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)search.getSearchType())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("search.type")}));
            return;
        }
        if (!StringUtil.checkLength((String)(search.getSearchType() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("search.type"), "1", "255"}));
            return;
        }
        this.searchBiz.updateEntity((BaseEntity)search);
        this.outJson(response, JSONObject.toJSONString((Object)((Object)search)));
    }

    @ApiOperation(value="\u67e5\u8be2\u680f\u76ee\u81ea\u5b9a\u4e49\u7684\u5b57\u6bb5\u540d\u63a5\u53e3")
    @ApiImplicitParam(name="columnId", value="\u680f\u76ee\u7f16\u53f7", required=true, paramType="path")
    @GetMapping(value={"/{columnId}/queryFieldName"})
    @ResponseBody
    public Map queryFieldName(@PathVariable @ApiIgnore int columnId, HttpServletRequest request) {
        HashMap<String, List<ContentModelFieldEntity>> model = new HashMap<String, List<ContentModelFieldEntity>>();
        ColumnEntity column = (ColumnEntity)this.columnBiz.getEntity(columnId);
        if (column != null) {
            int fieldCmid = column.getColumnContentModelId();
            List<ContentModelFieldEntity> listField = this.fieldBiz.queryListByCmid(fieldCmid);
            model.put("listField", listField);
        }
        return model;
    }

    @ApiOperation(value="\u751f\u6210\u641c\u7d22\u8868\u5355\u7684html\u6837\u5f0f")
    @GetMapping(value={"/generateSreachFormHtml"})
    public String generateSreachFormHtml(@ApiIgnore ModelMap model, HttpServletRequest request) {
        ManagerSessionEntity managerSession = this.getManagerBySession(request);
        int searchId = 0;
        if (!StringUtils.isBlank((CharSequence)request.getParameter("searchId"))) {
            searchId = Integer.valueOf(request.getParameter("searchId"));
        }
        Map field = new HashMap();
        field = request.getParameterMap();
        int basicCategoryId = 0;
        int cmId = 0;
        Map basicField = this.getMapByProperties(Const.BASIC_FIELD);
        Map basicAttribute = this.getMapByProperties(Const.BASIC_ATTRIBUTE);
        ArrayList listFieldName = new ArrayList();
        for (Map.Entry entry : field.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((String[])entry.getValue())[0];
            if (key.equals("columnId") && !StringUtils.isBlank((CharSequence)value) && !key.equals("searchId")) {
                basicCategoryId = Integer.valueOf(value);
            }
            if (key.equals("columnId") || key.equals("searchId")) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", key);
            map.put("type", value);
            if (!StringUtils.isBlank((CharSequence)((CharSequence)basicField.get(key)))) {
                map.put("ch", (String)basicField.get(key));
            } else {
                ContentModelFieldEntity fieldEntity;
                if (basicCategoryId != 0) {
                    ColumnEntity column = (ColumnEntity)this.columnBiz.getEntity(Integer.valueOf(basicCategoryId).intValue());
                    cmId = column.getColumnContentModelId();
                }
                if ((fieldEntity = this.fieldBiz.getEntityByCmId(cmId, key)) != null) {
                    String fieldTipsName = fieldEntity.getFieldTipsName();
                    map.put("ch", fieldTipsName);
                }
            }
            if (key.equals("article_type")) {
                map.put("default", basicAttribute.toString());
            } else {
                map.put("default", key.toString());
            }
            listFieldName.add(map);
        }
        model.addAttribute("searchId", (Object)searchId);
        model.addAttribute("searchType", (Object)request.getParameter("searchType"));
        model.addAttribute("websiteId", (Object)managerSession.getBasicId());
        model.addAttribute("listFieldName", listFieldName);
        model.addAttribute("basicCategoryId", (Object)basicCategoryId);
        return "/mdiy/search/search_field";
    }

    @ApiOperation(value="\u8df3\u8f6c\u81f3\u521b\u5efa\u641c\u7d22\u9875\u9762")
    @GetMapping(value={"/{searchId}/searchCode"})
    public String searchCode(@PathVariable int searchId, ModelMap model, HttpServletRequest request) {
        List columnList = this.columnBiz.queryColumnListByWebsiteId(BasicUtil.getAppId());
        SearchEntity searchEntity = new SearchEntity();
        searchEntity.setSearchId(searchId);
        SearchEntity search = (SearchEntity)((Object)this.searchBiz.getEntity((BaseEntity)searchEntity));
        model.addAttribute("columnList", (Object)JSONArray.toJSONString((Object)columnList, (SerializeFilter[])new SerializeFilter[0]));
        model.addAttribute("searchId", (Object)searchId);
        model.addAttribute("searchType", (Object)search.getSearchType());
        return "/mdiy/search/search_code";
    }
}

