/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.action;

import com.alibaba.fastjson.serializer.SerializeFilter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.filter.DateValueFilter;
import net.mingsoft.base.filter.DoubleValueFilter;
import net.mingsoft.base.util.JSONArray;
import net.mingsoft.base.util.JSONObject;
import net.mingsoft.basic.bean.EUListBean;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.basic.util.StringUtil;
import net.mingsoft.mdiy.action.BaseAction;
import net.mingsoft.mdiy.biz.ITableBiz;
import net.mingsoft.mdiy.entity.TableEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="\u81ea\u5b9a\u4e49\u8868\u7ba1\u7406\u63a5\u53e3")
@Controller
@RequestMapping(value={"/${ms.manager.path}/mdiy/table"})
public class TableAction
extends BaseAction {
    @Autowired
    private ITableBiz tableBiz;

    @GetMapping(value={"/index"})
    public String index(HttpServletResponse response, HttpServletRequest request) {
        return "/mdiy/table/index";
    }

    @ApiOperation(value="\u67e5\u8be2\u81ea\u5b9a\u4e49\u8868\u5217\u8868\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tableName", value="\u81ea\u5b9a\u4e49\u8868\u540d", required=false, paramType="query"), @ApiImplicitParam(name="tableMaster", value="\u4e3b\u8868\u6216\u4e3b\u4e1a\u52a1\u5173\u952e\u5b57", required=false, paramType="query"), @ApiImplicitParam(name="tableMasterId", value="\u6570\u636e\u7f16\u53f7\uff0c\u4e3b\u8981\u5173\u8054\u4e3b\u8868\u7f16\u53f7", required=false, paramType="query")})
    @GetMapping(value={"/list"})
    @ResponseBody
    public void list(@ModelAttribute @ApiIgnore TableEntity table, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model, BindingResult result) {
        BasicUtil.startPage();
        List tableList = this.tableBiz.query(table);
        this.outJson(response, JSONArray.toJSONString((Object)new EUListBean(tableList, (int)BasicUtil.endPage((List)tableList).getTotal()), (SerializeFilter[])new SerializeFilter[]{new DoubleValueFilter(), new DateValueFilter()}));
    }

    @GetMapping(value={"/form"})
    public String form(@ModelAttribute TableEntity table, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (table.getId() != null) {
            BaseEntity tableEntity = this.tableBiz.getEntity(Integer.parseInt(table.getId()));
            model.addAttribute("tableEntity", (Object)tableEntity);
        }
        return "/mdiy/table/form";
    }

    @ApiOperation(value=" \u83b7\u53d6\u81ea\u5b9a\u4e49\u8868\u8be6\u60c5")
    @ApiImplicitParam(name="id", value="\u81ea\u5b9a\u4e49\u8868\u7f16\u53f7", required=true, paramType="query")
    @GetMapping(value={"/get"})
    @ResponseBody
    public TableEntity get(@ModelAttribute @ApiIgnore TableEntity table, HttpServletResponse response, HttpServletRequest request, @ApiIgnore ModelMap model) {
        if (table.getId() == null) {
            return null;
        }
        TableEntity _table = (TableEntity)this.tableBiz.getEntity(Integer.parseInt(table.getId()));
        return _table;
    }

    @ApiOperation(value="\u4fdd\u5b58\u81ea\u5b9a\u4e49\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="appId", value="\u7ad9\u70b9\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="tableName", value="\u81ea\u5b9a\u4e49\u8868\u540d", required=true, paramType="query"), @ApiImplicitParam(name="tableMaster", value="\u4e3b\u8868\u6216\u4e3b\u4e1a\u52a1\u5173\u952e\u5b57", required=true, paramType="query"), @ApiImplicitParam(name="tableMasterId", value="\u6570\u636e\u7f16\u53f7\uff0c\u4e3b\u8981\u5173\u8054\u4e3b\u8868\u7f16\u53f7", required=true, paramType="query")})
    @PostMapping(value={"/save"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:table:save"})
    public void save(@ModelAttribute @ApiIgnore TableEntity table, HttpServletResponse response, HttpServletRequest request, BindingResult result) {
        if (StringUtils.isBlank((CharSequence)(table.getAppId() + ""))) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("app.id")}));
            return;
        }
        if (!StringUtil.checkLength((String)(table.getAppId() + ""), (int)1, (int)11)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("app.id"), "1", "11"}));
            return;
        }
        if (StringUtils.isBlank((CharSequence)table.getTableName())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("table.name")}));
            return;
        }
        if (!StringUtil.checkLength((String)(table.getTableName() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("table.name"), "1", "255"}));
            return;
        }
        if (StringUtils.isBlank((CharSequence)table.getTableMaster())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("table.master")}));
            return;
        }
        if (!StringUtil.checkLength((String)(table.getTableMaster() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("table.master"), "1", "255"}));
            return;
        }
        if (StringUtils.isBlank((CharSequence)table.getTableMasterId())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("table.master.id")}));
            return;
        }
        if (!StringUtil.checkLength((String)(table.getTableMasterId() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("table.master.id"), "1", "255"}));
            return;
        }
        this.tableBiz.saveEntity(table);
        this.outJson(response, JSONObject.toJSONString((Object)((Object)table)));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u81ea\u5b9a\u4e49\u8868")
    @PostMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:table:del"})
    public void delete(@RequestBody List<TableEntity> tables, HttpServletResponse response, HttpServletRequest request) {
        int[] ids = new int[tables.size()];
        for (int i = 0; i < tables.size(); ++i) {
            ids[i] = Integer.parseInt(tables.get(i).getId());
        }
        this.tableBiz.delete(ids);
        this.outJson(response, true);
    }

    @ApiOperation(value=" \u66f4\u65b0\u81ea\u5b9a\u4e49\u8868\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u81ea\u5b9a\u4e49\u8868\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="appId", value="\u7ad9\u70b9\u7f16\u53f7", required=true, paramType="query"), @ApiImplicitParam(name="tableName", value="\u81ea\u5b9a\u4e49\u8868\u540d", required=true, paramType="query"), @ApiImplicitParam(name="tableMaster", value="\u4e3b\u8868\u6216\u4e3b\u4e1a\u52a1\u5173\u952e\u5b57", required=true, paramType="query"), @ApiImplicitParam(name="tableMasterId", value="\u6570\u636e\u7f16\u53f7\uff0c\u4e3b\u8981\u5173\u8054\u4e3b\u8868\u7f16\u53f7", required=true, paramType="query")})
    @PostMapping(value={"/update"})
    @ResponseBody
    @RequiresPermissions(value={"mdiy:table:update"})
    public void update(@ModelAttribute @ApiIgnore TableEntity table, HttpServletResponse response, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)table.getId())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("id")}));
            return;
        }
        if (!StringUtil.checkLength((String)(table.getId() + ""), (int)1, (int)11)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("id"), "1", "11"}));
            return;
        }
        if (StringUtils.isBlank((CharSequence)(table.getAppId() + ""))) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("app.id")}));
            return;
        }
        if (!StringUtil.checkLength((String)(table.getAppId() + ""), (int)1, (int)11)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("app.id"), "1", "11"}));
            return;
        }
        if (StringUtils.isBlank((CharSequence)table.getTableName())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("table.name")}));
            return;
        }
        if (!StringUtil.checkLength((String)(table.getTableName() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("table.name"), "1", "255"}));
            return;
        }
        if (StringUtils.isBlank((CharSequence)table.getTableMaster())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("table.master")}));
            return;
        }
        if (!StringUtil.checkLength((String)(table.getTableMaster() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("table.master"), "1", "255"}));
            return;
        }
        if (StringUtils.isBlank((CharSequence)table.getTableMasterId())) {
            this.outJson(response, null, false, this.getResString("err.empty", new String[]{this.getResString("table.master.id")}));
            return;
        }
        if (!StringUtil.checkLength((String)(table.getTableMasterId() + ""), (int)1, (int)255)) {
            this.outJson(response, null, false, this.getResString("err.length", new String[]{this.getResString("table.master.id"), "1", "255"}));
            return;
        }
        this.tableBiz.updateEntity(table);
        this.outJson(response, JSONObject.toJSONString((Object)((Object)table)));
    }
}

