/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.mdiy.biz.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mingsoft.base.biz.impl.BaseBizImpl;
import net.mingsoft.base.dao.IBaseDao;
import net.mingsoft.mdiy.biz.IFormBiz;
import net.mingsoft.mdiy.constant.e.DiyFormFieldEnum;
import net.mingsoft.mdiy.dao.IFormDao;
import net.mingsoft.mdiy.dao.IFormFieldDao;
import net.mingsoft.mdiy.entity.FormEntity;
import net.mingsoft.mdiy.entity.FormFieldEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FormBizImpl
extends BaseBizImpl
implements IFormBiz {
    private static final String FORM_ID = "FROMID";
    private static final String DATE = "DATE";
    private static final String ID = "ID";
    @Autowired
    private IFormDao formDao;
    @Autowired
    private IFormFieldDao formFieldDao;

    protected IBaseDao getDao() {
        return this.formDao;
    }

    @Override
    public void saveDiyFormData(int formId, Map params) {
        FormEntity dfe = (FormEntity)this.formDao.getEntity(formId);
        if (dfe == null) {
            return;
        }
        String tableName = dfe.getFormTableName();
        List<FormFieldEntity> filedList = this.formFieldDao.queryByDiyFormId(formId);
        if (filedList == null) {
            return;
        }
        Map values = this.builderSqlMap(filedList, params);
        values.put(FORM_ID, formId);
        values.put(DATE, new Date());
        this.formFieldDao.insertBySQL(tableName, values);
    }

    @Override
    public Map queryDiyFormData(int diyFormId, int appId, Map whereMap) {
        FormEntity dfe = (FormEntity)this.formDao.getEntity(diyFormId);
        if (dfe != null) {
            List<FormFieldEntity> fieldList = this.formFieldDao.queryByDiyFormId(diyFormId);
            ArrayList fields = new ArrayList();
            HashMap<String, String> field = new HashMap<String, String>();
            ArrayList<String> keys = new ArrayList<String>();
            for (int i = 0; i < fieldList.size(); ++i) {
                field.put(fieldList.get(i).getDiyFormFieldFieldName(), fieldList.get(i).getDiyFormFieldTipsName());
                fields.add(field);
                keys.add(fieldList.get(i).getDiyFormFieldFieldName().toLowerCase());
            }
            HashMap<String, Object> wheres = new HashMap<String, Object>();
            wheres.put(FORM_ID, diyFormId);
            if (whereMap != null) {
                Set whereStr = whereMap.keySet();
                String[] array = whereStr.toArray(new String[whereStr.size()]);
                for (String str : array) {
                    if (keys.contains(str)) continue;
                    whereStr.remove(str);
                }
                for (FormFieldEntity formFieldEntity : fieldList) {
                    for (String key : whereStr) {
                        if (DiyFormFieldEnum.INT.toInt() == formFieldEntity.getDiyFormFieldType() || DiyFormFieldEnum.FLOAT.toInt() == formFieldEntity.getDiyFormFieldType()) {
                            wheres.put(key, whereMap.get(key));
                            continue;
                        }
                        wheres.put(key, "'" + whereMap.get(key) + "'");
                    }
                }
            } else {
                List list = this.formDao.queryBySQL(dfe.getFormTableName(), fields, wheres, 0, 10, null);
                wheres.put("list", list);
            }
            wheres.put("fields", fieldList);
            return wheres;
        }
        return null;
    }

    @Override
    public void deleteQueryDiyFormData(int id, int diyFormId) {
        FormEntity dfe = (FormEntity)this.formDao.getEntity(diyFormId);
        HashMap<String, Integer> wheres = new HashMap<String, Integer>();
        wheres.put(FORM_ID, diyFormId);
        wheres.put(ID, id);
        this.formDao.deleteBySQL(dfe.getFormTableName(), wheres);
    }

    @Override
    public int countDiyFormData(int diyFormId, int appId) {
        FormEntity dfe = (FormEntity)this.formDao.getEntity(diyFormId);
        HashMap<String, Integer> wheres = new HashMap<String, Integer>();
        wheres.put(FORM_ID, diyFormId);
        return this.formDao.countBySQL(dfe.getFormTableName(), wheres);
    }

    private Map builderSqlMap(List listField, Map params) {
        HashMap mapParams = new HashMap();
        for (int i = 0; i < listField.size(); ++i) {
            FormFieldEntity field = (FormFieldEntity)((Object)listField.get(i));
            String fieldName = field.getDiyFormFieldFieldName();
            String fieldNameLowerCase = field.getDiyFormFieldFieldName().toLowerCase();
            if (!StringUtils.isBlank((CharSequence)(params.get(fieldNameLowerCase) + ""))) {
                mapParams.put(fieldName, params.get(fieldNameLowerCase));
                continue;
            }
            mapParams.put(fieldName, params.get(fieldName));
        }
        return mapParams;
    }

    @Override
    public void createDiyFormTable(String table, Map<Object, List> fileds) {
        this.formDao.createDiyFormTable(table, fileds);
    }
}

