/*
 * Decompiled with CFR 0.152.
 */
package com.mingsoft.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileUtil {
    public static final String URF8 = "UTF-8";

    public static String readFile(String filePath) {
        String fileContent = "";
        try {
            File f = new File(filePath);
            if (f.isFile() && f.exists()) {
                String line;
                InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(f), URF8);
                BufferedReader reader = new BufferedReader(read);
                while ((line = reader.readLine()) != null) {
                    fileContent = String.valueOf(fileContent) + line + "\n";
                }
                reader.close();
                read.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileContent;
    }

    public static List readFolder(List<Map<String, String>> list, String folderPath) {
        if (list == null) {
            return null;
        }
        File file = new File(folderPath);
        File[] tempList = file.listFiles();
        if (tempList != null && tempList.length > 0) {
            File[] fileArray = tempList;
            int n = tempList.length;
            int n2 = 0;
            while (n2 < n) {
                File tmpFile = fileArray[n2];
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", file.getName());
                map.put("path", file.getPath());
                list.add(map);
                if (tmpFile.isDirectory()) {
                    FileUtil.readFolder(list, tmpFile.getPath());
                }
                ++n2;
            }
        }
        return list;
    }

    public static void writeFile(String content, String writePath, String charCoder) {
        try {
            File file = new File(writePath);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), charCoder);
            BufferedWriter reader = new BufferedWriter(osw);
            reader.write(content);
            osw.flush();
            reader.close();
            osw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void createFolder(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static void delFolders(String folderPath) {
        File file = new File(folderPath);
        if (!file.isDirectory()) {
            file.delete();
            return;
        }
        File[] tempList = file.listFiles();
        if (tempList != null && tempList.length > 0) {
            File[] fileArray = tempList;
            int n = tempList.length;
            int n2 = 0;
            while (n2 < n) {
                File tmpFile = fileArray[n2];
                if (tmpFile.isDirectory()) {
                    FileUtil.delFolders(tmpFile.getPath());
                } else {
                    tmpFile.delete();
                }
                ++n2;
            }
        } else {
            file.delete();
        }
        FileUtil.delFolders(file.getPath());
    }

    public static void delFile(String path) {
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
    }

    public static void writeTmpFile(String fileName, String content) {
        String strDir;
        String folderpath = strDir = System.getProperty("user.dir");
        String filepath = String.valueOf(folderpath) + File.separatorChar + fileName + ".tmp";
        FileUtil.writeFile(content, filepath, "utf-8");
    }

    public static String readTmpFile(String fileName) {
        String strDir;
        String folderpath = strDir = System.getProperty("user.dir");
        String filepath = String.valueOf(folderpath) + File.separatorChar + fileName + ".tmp";
        return FileUtil.readFile(filepath);
    }
}

